/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.ide.TypePresentationService;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomBundle;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ModelMergerUtil;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.reflect.DomGenericInfo;
import java.lang.reflect.Type;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResolvingElementQuickFix
implements LocalQuickFix,
IntentionAction {
    private final Class<? extends DomElement> myClazz;
    private final String myNewName;
    private final List<DomElement> myParents;
    private final DomCollectionChildDescription myChildDescription;
    private String myTypeName;

    public ResolvingElementQuickFix(Class<? extends DomElement> clazz, String newName, List<DomElement> parents, DomCollectionChildDescription childDescription) {
        this.myClazz = clazz;
        this.myNewName = newName;
        this.myParents = parents;
        this.myChildDescription = childDescription;
        this.myTypeName = TypePresentationService.getService().getTypePresentableName(this.myClazz);
    }

    public void setTypeName(String typeName) {
        this.myTypeName = typeName;
    }

    @Override
    @NotNull
    public String getName() {
        return DomBundle.message("create.new.element", this.myTypeName, this.myNewName);
    }

    @Override
    @NotNull
    public String getText() {
        return this.getName();
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return DomBundle.message("create.new.element.family", new Object[0]);
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return true;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        this.applyFix();
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        this.applyFix();
    }

    private void applyFix() {
        ResolvingElementQuickFix.chooseParent(this.myParents, (Consumer<DomElement>)((Consumer)parent -> new WriteCommandAction.Simple(parent.getManager().getProject(), new PsiFile[]{DomUtil.getFile(parent)}, (DomElement)parent){
            final /* synthetic */ DomElement val$parent;
            {
                this.val$parent = domElement;
                super(x0, x1);
            }

            @Override
            protected void run() throws Throwable {
                ResolvingElementQuickFix.this.doFix(this.val$parent, ResolvingElementQuickFix.this.myChildDescription, ResolvingElementQuickFix.this.myNewName);
            }
        }.execute()));
    }

    protected DomElement doFix(DomElement parent, DomCollectionChildDescription childDescription, String newName) {
        DomElement domElement = childDescription.addValue(parent);
        GenericDomValue nameDomElement = domElement.getGenericInfo().getNameDomElement(domElement);
        assert (nameDomElement != null);
        nameDomElement.setStringValue(newName);
        return domElement;
    }

    protected static void chooseParent(List<DomElement> files, final Consumer<DomElement> onChoose) {
        switch (files.size()) {
            case 0: {
                return;
            }
            case 1: {
                onChoose.consume((Object)files.iterator().next());
                return;
            }
        }
        JBPopupFactory.getInstance().createListPopup(new BaseListPopupStep<DomElement>(DomBundle.message("choose.file", new Object[0]), files){

            @Override
            public PopupStep onChosen(DomElement selectedValue, boolean finalChoice) {
                onChoose.consume((Object)selectedValue);
                return super.onChosen(selectedValue, finalChoice);
            }

            @Override
            public Icon getIconFor(DomElement aValue) {
                return DomUtil.getFile(aValue).getIcon(0);
            }

            @Override
            @NotNull
            public String getTextFor(DomElement value) {
                String name = DomUtil.getFile(value).getName();
                assert (name != null);
                return name;
            }
        }).showInBestPositionFor(DataManager.getInstance().getDataContext());
    }

    @Nullable
    public static <T extends DomElement> DomCollectionChildDescription getChildDescription(List<DomElement> contexts, Class<T> clazz) {
        if (contexts.size() == 0) {
            return null;
        }
        DomElement context = contexts.get(0);
        DomGenericInfo genericInfo = context.getGenericInfo();
        List<? extends DomCollectionChildDescription> descriptions = genericInfo.getCollectionChildrenDescriptions();
        for (DomCollectionChildDescription domCollectionChildDescription : descriptions) {
            Type type = domCollectionChildDescription.getType();
            if (!type.equals(clazz)) continue;
            return domCollectionChildDescription;
        }
        return null;
    }

    @Nullable
    public static ResolvingElementQuickFix createFix(String newName, Class<? extends DomElement> clazz, DomElement scope) {
        List<DomElement> parents = ModelMergerUtil.getImplementations(scope);
        return ResolvingElementQuickFix.createFix(newName, clazz, parents);
    }

    @Nullable
    public static ResolvingElementQuickFix createFix(String newName, Class<? extends DomElement> clazz, List<DomElement> parents) {
        DomCollectionChildDescription childDescription = ResolvingElementQuickFix.getChildDescription(parents, clazz);
        if (newName.length() > 0 && childDescription != null) {
            return new ResolvingElementQuickFix(clazz, newName, parents, childDescription);
        }
        return null;
    }

    public static LocalQuickFix[] createFixes(String newName, Class<? extends DomElement> clazz, DomElement scope) {
        LocalQuickFix[] localQuickFixArray;
        ResolvingElementQuickFix fix = ResolvingElementQuickFix.createFix(newName, clazz, scope);
        if (fix != null) {
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
            localQuickFixArray = localQuickFixArray2;
            localQuickFixArray2[0] = fix;
        } else {
            localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
        }
        return localQuickFixArray;
    }
}

