/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui.actions;

import com.intellij.ide.TypePresentationService;
import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.TypeChooser;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.ui.DomCollectionControl;
import java.awt.Component;
import java.lang.reflect.Type;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AddDomElementAction
extends AnAction {
    public AddDomElementAction() {
        super(ApplicationBundle.message("action.add", new Object[0]), null, DomCollectionControl.ADD_ICON);
    }

    @Override
    public void update(AnActionEvent e) {
        AnAction[] actions;
        if (!this.isEnabled(e)) {
            e.getPresentation().setEnabled(false);
            return;
        }
        for (AnAction action : actions = this.getChildren(e)) {
            e.getPresentation().setEnabled(true);
            action.update(e);
            if (e.getPresentation().isEnabled()) break;
        }
        if (actions.length == 1) {
            e.getPresentation().setText(actions[0].getTemplatePresentation().getText());
        } else {
            String actionText = this.getActionText(e);
            if (!actionText.endsWith("...")) {
                e.getPresentation().setText(actionText + (actions.length > 1 ? "..." : ""));
            }
        }
        e.getPresentation().setIcon(DomCollectionControl.ADD_ICON);
        super.update(e);
    }

    @Override
    public void actionPerformed(AnActionEvent e) {
        AnAction[] actions = this.getChildren(e);
        if (actions.length > 1) {
            DefaultActionGroup group = new DefaultActionGroup();
            for (AnAction action : actions) {
                group.add(action);
            }
            DataContext dataContext = e.getDataContext();
            ListPopup groupPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, group, dataContext, JBPopupFactory.ActionSelectionAid.NUMBERING, true);
            this.showPopup(groupPopup, e);
        } else if (actions.length == 1) {
            actions[0].actionPerformed(e);
        }
    }

    protected String getActionText(AnActionEvent e) {
        return e.getPresentation().getText();
    }

    protected boolean isEnabled(AnActionEvent e) {
        return true;
    }

    protected void showPopup(ListPopup groupPopup, AnActionEvent e) {
        Component component = e.getInputEvent().getComponent();
        if (component instanceof ActionButtonComponent) {
            groupPopup.showUnderneathOf(component);
        } else {
            groupPopup.showInBestPositionFor(e.getDataContext());
        }
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        Project project;
        Project project2 = project = e == null ? null : e.getProject();
        if (project == null) {
            return AnAction.EMPTY_ARRAY;
        }
        DomCollectionChildDescription[] descriptions = this.getDomCollectionChildDescriptions(e);
        final ArrayList<AnAction> actions = new ArrayList<AnAction>();
        for (DomCollectionChildDescription description : descriptions) {
            TypeChooser chooser = DomManager.getDomManager(project).getTypeChooserManager().getTypeChooser(description.getType());
            for (Type type : chooser.getChooserTypes()) {
                Class rawType = ReflectionUtil.getRawType((Type)type);
                String name = TypePresentationService.getService().getTypePresentableName(rawType);
                Icon icon = null;
                if (!this.showAsPopup() || descriptions.length == 1) {
                    icon = ElementPresentationManager.getIconForClass(rawType);
                }
                actions.add(this.createAddingAction(e, ApplicationBundle.message("action.add", new Object[0]) + " " + name, icon, type, description));
            }
        }
        if (actions.size() > 1 && this.showAsPopup()) {
            ActionGroup group = new ActionGroup(){

                @Override
                @NotNull
                public AnAction[] getChildren(@Nullable AnActionEvent e) {
                    return actions.toArray(new AnAction[actions.size()]);
                }
            };
            return new AnAction[]{new ShowPopupAction(group)};
        }
        if (actions.size() > 1) {
            actions.add(Separator.getInstance());
        } else if (actions.size() == 1) {
            // empty if block
        }
        return actions.toArray(new AnAction[actions.size()]);
    }

    protected abstract AnAction createAddingAction(AnActionEvent var1, String var2, Icon var3, Type var4, DomCollectionChildDescription var5);

    @NotNull
    protected abstract DomCollectionChildDescription[] getDomCollectionChildDescriptions(AnActionEvent var1);

    @Nullable
    protected abstract DomElement getParentDomElement(AnActionEvent var1);

    protected abstract JComponent getComponent(AnActionEvent var1);

    protected boolean showAsPopup() {
        return true;
    }

    protected class ShowPopupAction
    extends AnAction {
        protected final ActionGroup myGroup;

        protected ShowPopupAction(ActionGroup group) {
            super(ApplicationBundle.message("action.add", new Object[0]), null, DomCollectionControl.ADD_ICON);
            this.myGroup = group;
            this.setShortcutSet(CommonActionsPanel.getCommonShortcut(CommonActionsPanel.Buttons.ADD));
        }

        @Override
        public void actionPerformed(AnActionEvent e) {
            ListPopup groupPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, this.myGroup, e.getDataContext(), JBPopupFactory.ActionSelectionAid.NUMBERING, true);
            AddDomElementAction.this.showPopup(groupPopup, e);
        }
    }
}

