/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.evaluation;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueCallback;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public abstract class XDebuggerEvaluator {
    public abstract void evaluate(@NotNull String var1, @NotNull XEvaluationCallback var2, @Nullable XSourcePosition var3);

    public void evaluate(@NotNull XExpression expression, @NotNull XEvaluationCallback callback, @Nullable XSourcePosition expressionPosition) {
        this.evaluate(expression.getExpression(), callback, expressionPosition);
    }

    public boolean isCodeFragmentEvaluationSupported() {
        return true;
    }

    @Nullable
    public TextRange getExpressionRangeAtOffset(Project project, Document document, int offset, boolean sideEffectsAllowed) {
        return null;
    }

    @Nullable
    public ExpressionInfo getExpressionInfoAtOffset(@NotNull Project project, @NotNull Document document, int offset, boolean sideEffectsAllowed) {
        TextRange range = this.getExpressionRangeAtOffset(project, document, offset, sideEffectsAllowed);
        return range == null ? null : new ExpressionInfo(range);
    }

    @NotNull
    public Promise<ExpressionInfo> getExpressionInfoAtOffsetAsync(@NotNull Project project, @NotNull Document document, int offset, boolean sideEffectsAllowed) {
        return Promise.resolve(this.getExpressionInfoAtOffset(project, document, offset, sideEffectsAllowed));
    }

    @NotNull
    public String formatTextForEvaluation(@NotNull String text) {
        return text;
    }

    public EvaluationMode getEvaluationMode(@NotNull String text, int startOffset, int endOffset, @Nullable PsiFile psiFile) {
        return text.contains("\n") ? EvaluationMode.CODE_FRAGMENT : EvaluationMode.EXPRESSION;
    }

    public static interface XEvaluationCallback
    extends XValueCallback {
        public void evaluated(@NotNull XValue var1);
    }
}

