/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.frame;

import com.intellij.util.ThreeState;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XInstanceEvaluator;
import com.intellij.xdebugger.frame.XInlineDebuggerDataCallback;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XReferrersProvider;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public abstract class XValue
extends XValueContainer {
    public abstract void computePresentation(@NotNull XValueNode var1, @NotNull XValuePlace var2);

    @Nullable
    public String getEvaluationExpression() {
        return null;
    }

    @NotNull
    public Promise<XExpression> calculateEvaluationExpression() {
        String expression = this.getEvaluationExpression();
        XExpression res = expression != null ? XDebuggerUtil.getInstance().createExpression(expression, null, null, EvaluationMode.EXPRESSION) : null;
        return Promise.resolve(res);
    }

    @Nullable
    public XInstanceEvaluator getInstanceEvaluator() {
        return null;
    }

    @Nullable
    public XValueModifier getModifier() {
        return null;
    }

    public void computeSourcePosition(@NotNull XNavigatable navigatable) {
        navigatable.setSourcePosition(null);
    }

    @NotNull
    public ThreeState computeInlineDebuggerData(@NotNull XInlineDebuggerDataCallback callback) {
        return ThreeState.UNSURE;
    }

    public boolean canNavigateToSource() {
        return true;
    }

    public boolean canNavigateToTypeSource() {
        return false;
    }

    public void computeTypeSourcePosition(@NotNull XNavigatable navigatable) {
        navigatable.setSourcePosition(null);
    }

    @Nullable
    public XReferrersProvider getReferrersProvider() {
        return null;
    }
}

