/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Weighted;
import com.intellij.ui.paint.RectanglePainter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.xml.breadcrumbs.BreadcrumbsItem;
import com.intellij.xml.breadcrumbs.BreadcrumbsItemListener;
import com.intellij.xml.breadcrumbs.CrumbPresentation;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BreadcrumbsComponent<T extends BreadcrumbsItem>
extends JComponent
implements Disposable,
Weighted {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.xml.breadcrumbs.BreadcrumbsComponent");
    private static final Painter DEFAULT_PAINTER = new DefaultPainter(new ButtonSettings());
    private static final int EXTRA_WIDTH = 10;
    private List<BreadcrumbsItemListener<T>> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private Crumb myHovered;
    private PagedImage myBuffer;
    private List<Crumb> myCrumbs = new ArrayList<Crumb>();
    private final CrumbLineMouseListener myMouseListener = new CrumbLineMouseListener(this);
    private List<T> myItems;
    private int myOffset;

    public BreadcrumbsComponent() {
        this.addMouseListener(this.myMouseListener);
        this.addMouseMotionListener(this.myMouseListener);
        this.setToolTipText("");
    }

    public void setItems(@Nullable List<T> itemsList) {
        if (this.myItems != itemsList) {
            this.myItems = itemsList;
            this.myCrumbs = null;
        }
        this.repaint();
    }

    public void setOffset(int offset) {
        if (this.myOffset != offset) {
            this.myOffset = offset;
            this.repaint();
        }
    }

    public void addBreadcrumbsItemListener(@NotNull BreadcrumbsItemListener<T> listener) {
        this.myListeners.add(listener);
    }

    public void removeBreadcrumbsItemListener(@NotNull BreadcrumbsItemListener<T> listener) {
        this.myListeners.remove(listener);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Crumb c = this.getCrumb(event.getPoint());
        if (c != null) {
            String text = c.getTooltipText();
            return text == null ? super.getToolTipText(event) : text;
        }
        return super.getToolTipText(event);
    }

    @Nullable
    public Crumb getCrumb(@NotNull Point p) {
        if (this.myCrumbs != null) {
            Rectangle r = this.getBounds();
            p.translate(r.x, r.y);
            if (!r.contains(p)) {
                return null;
            }
            if (this.myBuffer == null) {
                return null;
            }
            int offset = this.myBuffer.getPageOffset();
            for (Crumb each : this.myCrumbs) {
                if (p.x + offset < each.getOffset() || p.x + offset >= each.getOffset() + each.getWidth()) continue;
                return each;
            }
        }
        return null;
    }

    public void setHoveredCrumb(@Nullable Crumb crumb) {
        if (crumb != null) {
            crumb.setHovered(true);
        }
        if (this.myHovered != null) {
            this.myHovered.setHovered(false);
        }
        this.myHovered = crumb;
        for (BreadcrumbsItemListener<BreadcrumbsItem> breadcrumbsItemListener : this.myListeners) {
            breadcrumbsItemListener.itemHovered(this.myHovered != null ? this.myHovered.myItem : null);
        }
        this.repaint();
    }

    public void nextPage() {
        int page;
        if (this.myBuffer != null && (page = this.myBuffer.getPage()) + 1 < this.myBuffer.getPageCount()) {
            this.myBuffer.setPage(page + 1);
        }
        this.repaint();
    }

    public void previousPage() {
        int page;
        if (this.myBuffer != null && (page = this.myBuffer.getPage()) - 1 >= 0) {
            this.myBuffer.setPage(page - 1);
        }
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Dimension d = this.getSize();
        FontMetrics fm = g2.getFontMetrics();
        if (this.myItems != null) {
            List<Crumb> crumbList;
            boolean veryDirty = this.myCrumbs == null || this.myBuffer != null && !this.myBuffer.isValid(d.width);
            List<Crumb> list = crumbList = veryDirty ? this.createCrumbList(fm, this.myItems, d.width) : this.myCrumbs;
            if (crumbList != null) {
                if (veryDirty) {
                    this.myBuffer = new PagedImage(BreadcrumbsComponent.getTotalWidth(crumbList), d.width);
                    this.myBuffer.setPage(this.myBuffer.getPageCount() - 1);
                }
                assert (this.myBuffer != null);
                super.paint(g2);
                this.myBuffer.paintPage(g2, crumbList, DEFAULT_PAINTER, d.height);
                this.myCrumbs = crumbList;
            }
        } else {
            super.paint(g2);
        }
    }

    private void setSelectedCrumb(@NotNull Crumb<T> c, int modifiers) {
        T selectedElement = c.getItem();
        HashSet items = new HashSet();
        boolean light = false;
        for (Crumb each : this.myCrumbs) {
            Object item = each.getItem();
            if (item != null && items.contains(item)) {
                light = false;
            }
            each.setLight(light);
            if (item != null && !light) {
                items.add(item);
            }
            if (selectedElement == item) {
                each.setSelected(true);
                light = true;
                continue;
            }
            each.setSelected(false);
        }
        this.fireItemSelected(selectedElement, modifiers);
        this.repaint();
    }

    private void fireItemSelected(@Nullable T item, int modifiers) {
        if (item != null) {
            for (BreadcrumbsItemListener<T> listener : this.myListeners) {
                listener.itemSelected(item, modifiers);
            }
        }
    }

    @Nullable
    private List<Crumb> createCrumbList(@NotNull FontMetrics fm, @NotNull List<T> elements, int width) {
        if (elements.size() == 0) {
            return null;
        }
        LinkedList<Crumb> result = new LinkedList<Crumb>();
        int screenWidth = 0;
        Crumb<BreadcrumbsItem> rightmostCrumb = null;
        NavigationCrumb fwd = new NavigationCrumb(this, fm, true, DEFAULT_PAINTER);
        for (int i2 = elements.size() - 1; i2 >= 0; --i2) {
            NavigationCrumb forward = new NavigationCrumb(this, fm, true, DEFAULT_PAINTER);
            NavigationCrumb backward = new NavigationCrumb(this, fm, false, DEFAULT_PAINTER);
            BreadcrumbsItem element = (BreadcrumbsItem)elements.get(i2);
            String s = element.getDisplayText();
            Dimension d = DEFAULT_PAINTER.getSize(s, fm, width - forward.getWidth() - backward.getWidth());
            Crumb<BreadcrumbsItem> crumb = new Crumb<BreadcrumbsItem>(this, s, d.width + 10, element);
            if (screenWidth + d.width > width) {
                Crumb<BreadcrumbsItem> first = null;
                if (screenWidth + backward.getWidth() > width && !result.isEmpty()) {
                    first = result.removeFirst();
                    screenWidth -= first.getWidth();
                }
                result.addFirst(backward);
                int dummyWidth = width - (screenWidth += backward.getWidth() - this.myOffset);
                if (dummyWidth > 0) {
                    DummyCrumb dummy = new DummyCrumb(dummyWidth);
                    if (rightmostCrumb != null) {
                        result.add(result.indexOf(rightmostCrumb) + 1, dummy);
                    } else {
                        result.addLast(dummy);
                    }
                }
                screenWidth = forward.getWidth();
                result.addFirst(forward);
                if (first != null) {
                    result.addFirst(first);
                    screenWidth += first.getWidth();
                }
                rightmostCrumb = first != null ? first : crumb;
            }
            result.addFirst(crumb);
            screenWidth += d.width;
        }
        if (rightmostCrumb != null && screenWidth < width) {
            result.add(result.indexOf(rightmostCrumb) + 2, new DummyCrumb(width - screenWidth - fwd.getWidth() - 8));
        }
        int offset = this.myOffset;
        for (Crumb each : result) {
            each.setOffset(offset);
            offset += each.getWidth();
        }
        if (result.size() > 0) {
            for (int i3 = result.size() - 1; i3 >= 0; --i3) {
                Crumb c = result.get(i3);
                if (c instanceof DummyCrumb) continue;
                c.setSelected(true);
                break;
            }
        }
        return result;
    }

    private static int getTotalWidth(@NotNull List<Crumb> crumbList) {
        int totalWidth = 0;
        for (Crumb each : crumbList) {
            totalWidth += each.getWidth();
        }
        return totalWidth;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Graphics2D g2 = (Graphics2D)GraphicsUtil.safelyGetGraphics((Component)this);
        Dimension dim = new Dimension(Integer.MAX_VALUE, g2 != null ? BreadcrumbsComponent.DEFAULT_PAINTER.getSize((String)"DUMMY", (FontMetrics)g2.getFontMetrics(), (int)Integer.MAX_VALUE).height + 1 : 1);
        JBInsets.addTo((Dimension)dim, (Insets)this.getInsets());
        return dim;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void dispose() {
        this.removeMouseListener(this.myMouseListener);
        this.removeMouseMotionListener(this.myMouseListener);
        this.myListeners = null;
    }

    @Override
    public double getWeight() {
        return Double.MAX_VALUE;
    }

    private static class DefaultPainter
    extends Painter {
        public DefaultPainter(@NotNull PainterSettings s) {
            super(s);
        }

        @Override
        public void paint(@NotNull Crumb c, @NotNull Graphics2D g2, int height, int pageOffset) {
            String string;
            FontMetrics fm;
            Font font;
            PainterSettings s = this.getSettings();
            Font oldFont = g2.getFont();
            int offset = c.getOffset() - pageOffset;
            int width = c.getWidth();
            RectanglePainter.paint((Graphics2D)g2, (int)(offset + 2), (int)2, (int)(width - 4), (int)(height - 4), (int)4, (Color)s.getBackgroundColor(c), (Color)s.getBorderColor(c));
            Color textColor = s.getForegroundColor(c);
            if (textColor != null) {
                g2.setColor(textColor);
            }
            if ((font = s.getFont(g2, c)) != null) {
                g2.setFont(font);
            }
            if ((fm = g2.getFontMetrics()).stringWidth(string = c.getString()) > width) {
                int charWidth;
                int dotsWidth = fm.stringWidth("...");
                StringBuilder sb = new StringBuilder();
                int length = 0;
                for (int i2 = 0; i2 < string.length() && length + (charWidth = fm.charWidth(string.charAt(i2))) + dotsWidth <= width; ++i2) {
                    length += charWidth;
                    sb.append(string.charAt(i2));
                }
                string = sb.append("...").toString();
            }
            g2.drawString(string, offset + 2 + 5, height - fm.getDescent() - 5);
            g2.setFont(oldFont);
        }

        @Override
        @NotNull
        Dimension getSize(@NotNull @NonNls String s, @NotNull FontMetrics fm, int maxWidth) {
            int width = fm.stringWidth(s) + 4;
            return new Dimension(width > maxWidth ? maxWidth : width, fm.getHeight() + 4);
        }
    }

    static abstract class Painter {
        public static final int ROUND_VALUE = 2;
        private final PainterSettings mySettings;

        public Painter(@NotNull PainterSettings s) {
            this.mySettings = s;
        }

        protected PainterSettings getSettings() {
            return this.mySettings;
        }

        abstract void paint(@NotNull Crumb var1, @NotNull Graphics2D var2, int var3, int var4);

        @NotNull
        Dimension getSize(@NotNull @NonNls String s, @NotNull FontMetrics fm, int maxWidth) {
            int w = fm.stringWidth(s);
            return new Dimension(w > maxWidth ? maxWidth : w, fm.getHeight());
        }
    }

    static class ButtonSettings
    extends PainterSettings {
        ButtonSettings() {
        }

        static Color getBackgroundColor(boolean selected, boolean hovered, boolean light, boolean navigationCrumb) {
            return EditorColorsManager.getInstance().getGlobalScheme().getAttributes(hovered ? EditorColors.BREADCRUMBS_HOVERED : (selected ? EditorColors.BREADCRUMBS_CURRENT : (light && !navigationCrumb ? EditorColors.BREADCRUMBS_INACTIVE : EditorColors.BREADCRUMBS_DEFAULT))).getBackgroundColor();
        }

        @Override
        @Nullable
        Color getBackgroundColor(@NotNull Crumb c) {
            CrumbPresentation presentation;
            Object item = c.getItem();
            if (item != null && (presentation = ((BreadcrumbsItem)item).getPresentation()) != null) {
                return presentation.getBackgroundColor(c.isSelected(), c.isHovered(), c.isLight());
            }
            return super.getBackgroundColor(c);
        }
    }

    static abstract class PainterSettings {
        PainterSettings() {
        }

        @Nullable
        Color getBackgroundColor(@NotNull Crumb c) {
            return PainterSettings.getAttributes(c).getBackgroundColor();
        }

        @Nullable
        Color getForegroundColor(@NotNull Crumb c) {
            return PainterSettings.getAttributes(c).getForegroundColor();
        }

        @Nullable
        Color getBorderColor(@NotNull Crumb c) {
            return PainterSettings.getAttributes(c).getEffectColor();
        }

        @Nullable
        Font getFont(@NotNull Graphics g2, @NotNull Crumb c) {
            return null;
        }

        @NotNull
        static TextAttributesKey getKey(Crumb c) {
            return c.isHovered() ? EditorColors.BREADCRUMBS_HOVERED : (c.isSelected() ? EditorColors.BREADCRUMBS_CURRENT : (c.isLight() && !(c instanceof NavigationCrumb) ? EditorColors.BREADCRUMBS_INACTIVE : EditorColors.BREADCRUMBS_DEFAULT));
        }

        @NotNull
        static TextAttributes getAttributes(Crumb c) {
            return EditorColorsManager.getInstance().getGlobalScheme().getAttributes(PainterSettings.getKey(c));
        }
    }

    private static class DummyCrumb
    extends Crumb {
        public DummyCrumb(int width) {
            super(null, width);
        }

        @Override
        public void paint(@NotNull Graphics2D g2, @NotNull Painter painter, int height, int pageOffset) {
        }

        @Override
        public void performAction(int modifiers) {
        }

        @Override
        public String toString() {
            return "DUMMY";
        }
    }

    private static class NavigationCrumb
    extends Crumb {
        @NonNls
        private static final String FORWARD = ">>";
        @NonNls
        private static final String BACKWARD = "<<";
        private final boolean myForward;
        private final BreadcrumbsComponent myLine;

        public NavigationCrumb(@NotNull BreadcrumbsComponent line, @NotNull FontMetrics fm, boolean forward, @NotNull Painter p) {
            super(forward ? FORWARD : BACKWARD, p.getSize((String)(forward ? FORWARD : BACKWARD), (FontMetrics)fm, (int)Integer.MAX_VALUE).width + 10);
            this.myForward = forward;
            this.myLine = line;
        }

        @Override
        public void performAction(int modifiers) {
            if (this.myForward) {
                this.myLine.nextPage();
            } else {
                this.myLine.previousPage();
            }
        }
    }

    private static class Crumb<T extends BreadcrumbsItem> {
        private final String myString;
        private int myOffset = -1;
        private final int myWidth;
        private T myItem;
        private BreadcrumbsComponent myLine;
        private boolean mySelected;
        private boolean myHovered;
        private boolean myLight;

        public Crumb(BreadcrumbsComponent line, String string, int width, T item) {
            this(string, width);
            this.myLine = line;
            this.myItem = item;
        }

        public Crumb(String string, int width) {
            this.myString = string;
            this.myWidth = width;
        }

        public String getString() {
            return this.myString;
        }

        public int getOffset() {
            LOG.assertTrue(this.myOffset != -1, (Object)("Negative offet for crumb: " + this.myString));
            return this.myOffset;
        }

        public int getWidth() {
            return this.myWidth;
        }

        public void setOffset(int offset) {
            this.myOffset = offset;
        }

        public String toString() {
            return this.getString();
        }

        public void setSelected(boolean selected) {
            this.mySelected = selected;
        }

        public void setLight(boolean light) {
            this.myLight = light;
        }

        public boolean isHovered() {
            return this.myHovered;
        }

        public boolean isSelected() {
            return this.mySelected;
        }

        public boolean isLight() {
            return this.myLight;
        }

        public void paint(@NotNull Graphics2D g2, @NotNull Painter painter, int height, int pageOffset) {
            painter.paint(this, g2, height, pageOffset);
        }

        @Nullable
        public String getTooltipText() {
            T element = this.getItem();
            if (element != null) {
                return ((BreadcrumbsItem)element).getTooltip();
            }
            return null;
        }

        public T getItem() {
            return this.myItem;
        }

        public void performAction(int modifiers) {
            this.myLine.setSelectedCrumb(this, modifiers);
        }

        public void setHovered(boolean b) {
            this.myHovered = b;
        }
    }

    private static class CrumbLineMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        private final BreadcrumbsComponent myBreadcrumbs;
        private Crumb myHoveredCrumb;

        public CrumbLineMouseListener(@NotNull BreadcrumbsComponent line) {
            this.myBreadcrumbs = line;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Crumb crumb = this.myBreadcrumbs.getCrumb(e.getPoint());
            if (crumb != this.myHoveredCrumb) {
                this.myBreadcrumbs.setHoveredCrumb(crumb);
                this.myHoveredCrumb = crumb;
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.mouseMoved(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.mouseMoved(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Crumb crumb = this.myBreadcrumbs.getCrumb(e.getPoint());
            if (crumb != null) {
                crumb.performAction(e.getModifiers());
            }
        }
    }

    private static class PagedImage {
        private final int myPageWidth;
        private int myPage;
        private final int myTotalWidth;

        public PagedImage(int totalWidth, int pageWidth) {
            this.myPageWidth = pageWidth;
            this.myTotalWidth = totalWidth;
        }

        public int getPageCount() {
            if (this.myTotalWidth < this.myPageWidth) {
                return 1;
            }
            return this.myTotalWidth / this.myPageWidth;
        }

        public void setPage(int page) {
            assert (page >= 0);
            assert (page < this.getPageCount());
            this.myPage = page;
        }

        public int getPage() {
            return this.myPage;
        }

        private void repaint(@NotNull Graphics2D g2, @NotNull List<Crumb> crumbList, @NotNull Painter painter, int height) {
            UISettings.setupAntialiasing(g2);
            int pageOffset = this.getPageOffset();
            for (Crumb each : crumbList) {
                if (each.getOffset() < pageOffset || each.getOffset() >= pageOffset + this.myPageWidth) continue;
                each.paint(g2, painter, height, pageOffset);
            }
        }

        public int getPageOffset() {
            return this.myPage * this.myPageWidth;
        }

        public void paintPage(@NotNull Graphics2D g2, @NotNull List<Crumb> list, @NotNull Painter p, int height) {
            this.repaint(g2, list, p, height);
        }

        public boolean isValid(int width) {
            return width == this.myPageWidth;
        }
    }
}

