/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testFramework.fixtures.LightCodeInsightFixtureTestCase;
import com.intellij.util.ArrayUtil;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LightInspectionTestCase
extends LightCodeInsightFixtureTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        for (String environmentClass : this.getEnvironmentClasses()) {
            this.myFixture.addClass(environmentClass);
        }
        InspectionProfileEntry inspection = this.getInspection();
        if (inspection != null) {
            this.myFixture.enableInspections(new InspectionProfileEntry[]{inspection});
            Project project = this.myFixture.getProject();
            HighlightDisplayKey displayKey = HighlightDisplayKey.find(inspection.getShortName());
            InspectionProfileImpl currentProfile = ProjectInspectionProfileManager.getInstance((Project)project).getCurrentProfile();
            HighlightDisplayLevel errorLevel = currentProfile.getErrorLevel(displayKey, null);
            if (errorLevel == HighlightDisplayLevel.DO_NOT_SHOW) {
                currentProfile.setErrorLevel(displayKey, HighlightDisplayLevel.WARNING, project);
            }
        }
        Sdk sdk = ModuleRootManager.getInstance(ModuleManager.getInstance(this.getProject()).getModules()[0]).getSdk();
        if (JAVA_1_7.getSdk().getName().equals(sdk == null ? null : sdk.getName())) {
            PsiClass object = JavaPsiFacade.getInstance(this.getProject()).findClass("java.lang.Object", GlobalSearchScope.allScope(this.getProject()));
            LightInspectionTestCase.assertNotNull((Object)object);
            PsiClass component = JavaPsiFacade.getInstance(this.getProject()).findClass("java.awt.Component", GlobalSearchScope.allScope(this.getProject()));
            LightInspectionTestCase.assertNotNull((Object)component);
        }
    }

    @Nullable
    protected abstract InspectionProfileEntry getInspection();

    @Language(value="JAVA")
    protected String[] getEnvironmentClasses() {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    protected void addEnvironmentClass(@Language(value="JAVA") @NotNull String classText) {
        this.myFixture.addClass(classText);
    }

    protected final void doStatementTest(@Language(value="JAVA", prefix="class X { void m() {", suffix="}}") @NotNull String statementText) {
        this.doTest("class X { void m() {" + statementText + "}}");
    }

    protected final void doMemberTest(@Language(value="JAVA", prefix="class X {", suffix="}") @NotNull String memberText) {
        this.doTest("class X {" + memberText + "}");
    }

    protected final void doTest(@Language(value="JAVA") @NotNull String classText) {
        StringBuilder newText = new StringBuilder();
        int start = 0;
        int end = classText.indexOf("/*");
        while (end >= 0) {
            newText.append(classText, start, end);
            start = end + 2;
            end = classText.indexOf("*/", end);
            if (end < 0) {
                throw new IllegalArgumentException("invalid class text");
            }
            String text = classText.substring(start, end);
            if (text.isEmpty()) {
                newText.append("</warning>");
            } else if ("!".equals(text)) {
                newText.append("</error>");
            } else if ("_".equals(text)) {
                newText.append("<caret>");
            } else if (text.startsWith("!")) {
                newText.append("<error descr=\"").append(text.substring(1)).append("\">");
            } else {
                newText.append("<warning descr=\"").append(text).append("\">");
            }
            start = end + 2;
            end = classText.indexOf("/*", end + 1);
        }
        newText.append(classText, start, classText.length());
        this.myFixture.configureByText("X.java", newText.toString());
        this.myFixture.testHighlighting(true, false, false, new String[0]);
    }

    @Override
    protected String getBasePath() {
        InspectionProfileEntry inspection = this.getInspection();
        LightInspectionTestCase.assertNotNull((String)"File-based tests should either return an inspection or override this method", (Object)inspection);
        String className = inspection.getClass().getName();
        String[] words = className.split("\\.");
        StringBuilder basePath = new StringBuilder("/plugins/InspectionGadgets/test/");
        int lastWordIndex = words.length - 1;
        for (int i2 = 0; i2 < lastWordIndex; ++i2) {
            String word = words[i2];
            if (word.equals("ig")) {
                word = "igtest";
            }
            basePath.append(word).append('/');
        }
        String lastWord = words[lastWordIndex];
        lastWord = StringUtil.trimEnd((String)lastWord, (String)"Inspection");
        int length = lastWord.length();
        boolean upperCase = false;
        for (int i3 = 0; i3 < length; ++i3) {
            char ch = lastWord.charAt(i3);
            if (Character.isUpperCase(ch)) {
                if (!upperCase) {
                    upperCase = true;
                    if (i3 != 0) {
                        basePath.append('_');
                    }
                }
                basePath.append(Character.toLowerCase(ch));
                continue;
            }
            upperCase = false;
            basePath.append(ch);
        }
        return basePath.toString();
    }

    protected final void doTest() {
        this.doNamedTest(this.getTestName(false));
    }

    protected final void doNamedTest(String name) {
        this.myFixture.configureByFile(name + ".java");
        this.myFixture.testHighlighting(true, false, false, new String[0]);
    }
}

