/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.openapi.util.Getter;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.AsyncPromiseKt;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

class DonePromise<T>
implements Getter<T>,
Promise<T> {
    private final T result;

    public DonePromise(T result) {
        this.result = result;
    }

    @Override
    @NotNull
    public Promise<T> done(@NotNull Consumer<? super T> done2) {
        if (!AsyncPromiseKt.isObsolete(done2)) {
            done2.consume(this.result);
        }
        return this;
    }

    @Override
    @NotNull
    public Promise<T> processed(@NotNull AsyncPromise<? super T> fulfilled) {
        fulfilled.setResult(this.result);
        return this;
    }

    @Override
    @NotNull
    public Promise<T> processed(@NotNull Consumer<? super T> processed2) {
        this.done(processed2);
        return this;
    }

    @Override
    @NotNull
    public Promise<T> rejected(@NotNull Consumer<Throwable> rejected2) {
        return this;
    }

    @Override
    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> then(@NotNull Function<? super T, ? extends SUB_RESULT> done2) {
        if (done2 instanceof Obsolescent && ((Obsolescent)done2).isObsolete()) {
            return Promises.rejectedPromise("obsolete");
        }
        return Promises.resolvedPromise(done2.fun(this.result));
    }

    @Override
    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> thenAsync(@NotNull Function<? super T, Promise<SUB_RESULT>> done2) {
        return (Promise)done2.fun(this.result);
    }

    @Override
    @NotNull
    public Promise.State getState() {
        return Promise.State.FULFILLED;
    }

    @Override
    @Nullable
    public T blockingGet(int timeout, @NotNull TimeUnit timeUnit) {
        return this.result;
    }

    public T get() {
        return this.result;
    }

    @Override
    public void notify(@NotNull AsyncPromise<? super T> child) {
        child.setResult(this.result);
    }
}

