/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.util.messages.Topic;
import org.jetbrains.annotations.NotNull;

public abstract class VirtualFileManager
implements ModificationTracker {
    public static final Topic<BulkFileListener> VFS_CHANGES = new Topic<BulkFileListener>("NewVirtualFileSystem changes", BulkFileListener.class);
    public static final ModificationTracker VFS_STRUCTURE_MODIFICATIONS = new ModificationTracker(){

        @Override
        public long getModificationCount() {
            return VirtualFileManager.getInstance().getStructureModificationCount();
        }
    };

    @NotNull
    public static VirtualFileManager getInstance() {
        VirtualFileManager virtualFileManager = ApplicationManager.getApplication().getComponent(VirtualFileManager.class);
        if (virtualFileManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VirtualFileManager", "getInstance"));
        }
        return virtualFileManager;
    }

    @NotNull
    public static String constructUrl(@NotNull String protocol, @NotNull String path) {
        if (protocol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protocol", "com/intellij/openapi/vfs/VirtualFileManager", "constructUrl"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/VirtualFileManager", "constructUrl"));
        }
        String string = protocol + "://" + path;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/VirtualFileManager", "constructUrl"));
        }
        return string;
    }

    public abstract void notifyPropertyChanged(@NotNull VirtualFile var1, @NotNull String var2, Object var3, Object var4);

    @Override
    public abstract long getModificationCount();

    public abstract long getStructureModificationCount();
}

