/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.plugins;

import java.util.Collections;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryVar;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.language.cpp.plugins.CppBasePlugin;
import org.gradle.language.cpp.tasks.CppCompile;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.tasks.LinkSharedLibrary;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainRegistryInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.platform.base.Platform;

@Incubating
public class CppLibraryPlugin
implements Plugin<ProjectInternal> {
    public void apply(final ProjectInternal project) {
        project.getPluginManager().apply(CppBasePlugin.class);
        TaskContainerInternal tasks = project.getTasks();
        ConfigurationContainer configurations = project.getConfigurations();
        DirectoryVar buildDirectory = project.getLayout().getBuildDirectory();
        ObjectFactory objectFactory = project.getObjects();
        CppCompile compile = (CppCompile)tasks.create("compileCpp", CppCompile.class);
        compile.includes("src/main/public");
        compile.includes("src/main/headers");
        compile.includes(configurations.getByName("cppCompileIncludePath"));
        ConfigurableFileTree sourceTree = project.fileTree((Object)"src/main/cpp");
        sourceTree.include(new String[]{"**/*.cpp"});
        sourceTree.include(new String[]{"**/*.c++"});
        compile.source(sourceTree);
        compile.setCompilerArgs(Collections.emptyList());
        compile.setPositionIndependentCode(true);
        compile.setMacros(Collections.emptyMap());
        compile.setObjectFileDir((Provider<? extends Directory>)buildDirectory.dir("main/objs"));
        DefaultNativePlatform currentPlatform = new DefaultNativePlatform("current");
        compile.setTargetPlatform((NativePlatform)currentPlatform);
        NativeToolChain toolChain = (NativeToolChain)((NativeToolChainRegistryInternal)project.getModelRegistry().realize("toolChains", NativeToolChainRegistryInternal.class)).getForPlatform((Platform)currentPlatform);
        final PlatformToolProvider platformToolChain = ((NativeToolChainInternal)toolChain).select((NativePlatformInternal)currentPlatform);
        compile.setToolChain(toolChain);
        final LinkSharedLibrary link = (LinkSharedLibrary)tasks.create("linkMain", LinkSharedLibrary.class);
        link.source((Object)compile.getObjectFileDirectory().getAsFileTree());
        link.lib((Object)configurations.getByName("nativeLink"));
        link.setLinkerArgs(Collections.emptyList());
        String linkFileName = platformToolChain.getSharedLibraryLinkFileName("build/lib/" + project.getName());
        Provider runtimeFile = buildDirectory.file(project.getProviders().provider((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return platformToolChain.getSharedLibraryName("lib/" + project.getName());
            }
        }));
        link.setOutputFile(runtimeFile);
        link.setTargetPlatform((NativePlatform)currentPlatform);
        link.setToolChain(toolChain);
        tasks.getByName("assemble").dependsOn(new Object[]{link});
        Configuration apiElements = (Configuration)configurations.create("cppApiElements");
        apiElements.setCanBeResolved(false);
        apiElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objectFactory.named(Usage.class, "cplusplus-api"));
        apiElements.getOutgoing().artifact((Object)project.file((Object)"src/main/public"));
        Configuration implementation = configurations.getByName("implementation");
        Configuration linkElements = (Configuration)configurations.create("linkElements");
        linkElements.extendsFrom(new Configuration[]{implementation});
        linkElements.setCanBeResolved(false);
        linkElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objectFactory.named(Usage.class, "native-link"));
        linkElements.getOutgoing().artifact((Object)project.file((Object)linkFileName), (Action)new Action<ConfigurablePublishArtifact>(){

            public void execute(ConfigurablePublishArtifact artifact) {
                artifact.builtBy(new Object[]{link});
            }
        });
        Configuration runtimeElements = (Configuration)configurations.create("runtimeElements");
        runtimeElements.extendsFrom(new Configuration[]{implementation});
        runtimeElements.setCanBeResolved(false);
        runtimeElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objectFactory.named(Usage.class, "native-runtime"));
        runtimeElements.getOutgoing().artifact((Object)link.getOutputFile(), (Action)new Action<ConfigurablePublishArtifact>(){

            public void execute(ConfigurablePublishArtifact artifact) {
                artifact.builtBy(new Object[]{link});
            }
        });
    }
}

