/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.build.gradle.internal.CombinedInput;
import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.Reporter;
import com.android.tools.lint.checks.BuiltinIssueRegistry;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;

public class LintOptions
implements com.android.builder.model.LintOptions,
Serializable {
    public static final String STDOUT = "stdout";
    public static final String STDERR = "stderr";
    private static final long serialVersionUID = 1L;
    private Set<String> disable = Sets.newHashSet();
    private Set<String> enable = Sets.newHashSet();
    private Set<String> check = Sets.newHashSet();
    private boolean abortOnError = true;
    private boolean absolutePaths = true;
    private boolean noLines;
    private boolean quiet;
    private boolean checkAllWarnings;
    private boolean ignoreWarnings;
    private boolean warningsAsErrors;
    private boolean showAll;
    private boolean checkReleaseBuilds = true;
    private boolean explainIssues = true;
    private boolean checkTestSources;
    private boolean checkGeneratedSources;
    private boolean checkDependencies;
    private File lintConfig;
    private boolean textReport;
    private File textOutput;
    private boolean htmlReport = true;
    private File htmlOutput;
    private boolean xmlReport = true;
    private File xmlOutput;
    private Map<String, Severity> severities = Maps.newHashMap();
    private File baselineFile;

    public LintOptions() {
    }

    public LintOptions(Set<String> disable, Set<String> enable, Set<String> check, File lintConfig, boolean textReport, File textOutput, boolean htmlReport, File htmlOutput, boolean xmlReport, File xmlOutput, boolean abortOnError, boolean absolutePaths, boolean noLines, boolean quiet, boolean checkAllWarnings, boolean ignoreWarnings, boolean warningsAsErrors, boolean showAll, boolean explainIssues, boolean checkReleaseBuilds, boolean checkTestSources, boolean checkGeneratedSources, boolean checkDependencies, File baselineFile, Map<String, Integer> severityOverrides) {
        this.disable = disable;
        this.enable = enable;
        this.check = check;
        this.lintConfig = lintConfig;
        this.textReport = textReport;
        this.textOutput = textOutput;
        this.htmlReport = htmlReport;
        this.htmlOutput = htmlOutput;
        this.xmlReport = xmlReport;
        this.xmlOutput = xmlOutput;
        this.abortOnError = abortOnError;
        this.absolutePaths = absolutePaths;
        this.noLines = noLines;
        this.quiet = quiet;
        this.checkAllWarnings = checkAllWarnings;
        this.ignoreWarnings = ignoreWarnings;
        this.warningsAsErrors = warningsAsErrors;
        this.showAll = showAll;
        this.explainIssues = explainIssues;
        this.checkReleaseBuilds = checkReleaseBuilds;
        this.checkTestSources = checkTestSources;
        this.checkGeneratedSources = checkGeneratedSources;
        this.checkDependencies = checkDependencies;
        this.baselineFile = baselineFile;
        if (severityOverrides != null) {
            for (Map.Entry<String, Integer> entry : severityOverrides.entrySet()) {
                this.severities.put(entry.getKey(), LintOptions.convert(entry.getValue()));
            }
        }
    }

    public static com.android.builder.model.LintOptions create(com.android.builder.model.LintOptions source) {
        return new LintOptions(source.getDisable(), source.getEnable(), source.getCheck(), source.getLintConfig(), source.getTextReport(), source.getTextOutput(), source.getHtmlReport(), source.getHtmlOutput(), source.getXmlReport(), source.getXmlOutput(), source.isAbortOnError(), source.isAbsolutePaths(), source.isNoLines(), source.isQuiet(), source.isCheckAllWarnings(), source.isIgnoreWarnings(), source.isWarningsAsErrors(), source.isShowAll(), source.isExplainIssues(), source.isCheckReleaseBuilds(), source.isCheckTestSources(), source.isCheckGeneratedSources(), source.isCheckDependencies(), source.getBaselineFile(), source.getSeverityOverrides());
    }

    @Input
    public Set<String> getDisable() {
        return this.disable;
    }

    public void setDisable(Set<String> ids) {
        this.disable.addAll(ids);
    }

    @Input
    public Set<String> getEnable() {
        return this.enable;
    }

    public void setEnable(Set<String> ids) {
        this.enable.addAll(ids);
    }

    @Optional
    @Input
    public Set<String> getCheck() {
        return this.check;
    }

    public void setCheck(Set<String> ids) {
        this.check.addAll(ids);
    }

    @Input
    public boolean isAbortOnError() {
        return this.abortOnError;
    }

    public void setAbortOnError(boolean abortOnError) {
        this.abortOnError = abortOnError;
    }

    @Input
    public boolean isAbsolutePaths() {
        return this.absolutePaths;
    }

    public void setAbsolutePaths(boolean absolutePaths) {
        this.absolutePaths = absolutePaths;
    }

    @Input
    public boolean isNoLines() {
        return this.noLines;
    }

    public void setNoLines(boolean noLines) {
        this.noLines = noLines;
    }

    @Input
    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    @Input
    public boolean isCheckAllWarnings() {
        return this.checkAllWarnings;
    }

    public void setCheckAllWarnings(boolean warnAll) {
        this.checkAllWarnings = warnAll;
    }

    @Input
    public boolean isIgnoreWarnings() {
        return this.ignoreWarnings;
    }

    public void setIgnoreWarnings(boolean noWarnings) {
        this.ignoreWarnings = noWarnings;
    }

    @Input
    public boolean isWarningsAsErrors() {
        return this.warningsAsErrors;
    }

    public void setWarningsAsErrors(boolean allErrors) {
        this.warningsAsErrors = allErrors;
    }

    public boolean isCheckTestSources() {
        return this.checkTestSources;
    }

    public void setCheckTestSources(boolean checkTestSources) {
        this.checkTestSources = checkTestSources;
    }

    public boolean isCheckGeneratedSources() {
        return this.checkGeneratedSources;
    }

    public void setCheckGeneratedSources(boolean checkGeneratedSources) {
        this.checkGeneratedSources = checkGeneratedSources;
    }

    @Input
    public boolean isCheckDependencies() {
        return this.checkDependencies;
    }

    public void setCheckDependencies(boolean checkDependencies) {
        this.checkDependencies = checkDependencies;
    }

    @Input
    public boolean isExplainIssues() {
        return this.explainIssues;
    }

    public void setExplainIssues(boolean explainIssues) {
        this.explainIssues = explainIssues;
    }

    @Input
    public boolean isShowAll() {
        return this.showAll;
    }

    public void setShowAll(boolean showAll) {
        this.showAll = showAll;
    }

    @Input
    public boolean isCheckReleaseBuilds() {
        return this.checkReleaseBuilds;
    }

    public void setCheckReleaseBuilds(boolean checkReleaseBuilds) {
        this.checkReleaseBuilds = checkReleaseBuilds;
    }

    @Optional
    @InputFile
    public File getLintConfig() {
        return this.lintConfig;
    }

    @Input
    public boolean getTextReport() {
        return this.textReport;
    }

    public void setTextReport(boolean textReport) {
        this.textReport = textReport;
    }

    public void setHtmlReport(boolean htmlReport) {
        this.htmlReport = htmlReport;
    }

    public void setHtmlOutput(File htmlOutput) {
        this.htmlOutput = htmlOutput;
    }

    public void setXmlReport(boolean xmlReport) {
        this.xmlReport = xmlReport;
    }

    public void setXmlOutput(File xmlOutput) {
        if (xmlOutput.getName().equals("lint.xml")) {
            throw new GradleException("Don't set the xmlOutput file to \"lint.xml\"; that's a reserved filename used for for lint configuration files, not reports.");
        }
        this.xmlOutput = xmlOutput;
    }

    @Optional
    @Input
    public File getTextOutput() {
        return this.textOutput;
    }

    @Input
    public boolean getHtmlReport() {
        return this.htmlReport;
    }

    @Optional
    @OutputFile
    public File getHtmlOutput() {
        return this.htmlOutput;
    }

    @Input
    public boolean getXmlReport() {
        return this.xmlReport;
    }

    @Optional
    @OutputFile
    public File getXmlOutput() {
        return this.xmlOutput;
    }

    public void setLintConfig(File lintConfig) {
        this.lintConfig = lintConfig;
    }

    public void syncTo(LintCliClient client, LintCliFlags flags, String variantName, Project project, File reportsDir, boolean report) {
        if (this.disable != null) {
            flags.getSuppressedIds().addAll(this.disable);
        }
        if (this.enable != null) {
            flags.getEnabledIds().addAll(this.enable);
        }
        if (this.check != null && !this.check.isEmpty()) {
            flags.setExactCheckedIds(this.check);
        }
        flags.setSetExitCode(this.abortOnError);
        flags.setFullPath(this.absolutePaths);
        flags.setShowSourceLines(!this.noLines);
        flags.setQuiet(this.quiet);
        flags.setCheckAllWarnings(this.checkAllWarnings);
        flags.setIgnoreWarnings(this.ignoreWarnings);
        flags.setWarningsAsErrors(this.warningsAsErrors);
        flags.setCheckTestSources(this.checkTestSources);
        flags.setCheckGeneratedSources(this.checkGeneratedSources);
        flags.setCheckDependencies(this.checkDependencies);
        flags.setShowEverything(this.showAll);
        flags.setDefaultConfiguration(this.lintConfig);
        flags.setSeverityOverrides(this.severities);
        flags.setExplainIssues(this.explainIssues);
        flags.setBaselineFile(this.baselineFile);
        if (report || flags.isFatalOnly() && this.abortOnError) {
            File output;
            if (this.textReport || flags.isFatalOnly()) {
                boolean closeWriter;
                Writer writer;
                output = this.textOutput;
                if (output == null) {
                    output = new File(flags.isFatalOnly() ? STDERR : STDOUT);
                } else if (!(output.isAbsolute() || LintOptions.isStdOut(output) || LintOptions.isStdErr(output))) {
                    output = project.file((Object)output.getPath());
                }
                output = LintOptions.validateOutputFile(output);
                File file = null;
                if (LintOptions.isStdOut(output)) {
                    writer = new PrintWriter(System.out, true);
                    closeWriter = false;
                } else if (LintOptions.isStdErr(output)) {
                    writer = new PrintWriter(System.err, true);
                    closeWriter = false;
                } else {
                    file = output;
                    try {
                        writer = new BufferedWriter(new FileWriter(output));
                    }
                    catch (IOException e) {
                        throw new GradleException("Text invalid argument.", (Throwable)e);
                    }
                    closeWriter = true;
                }
                flags.getReporters().add(Reporter.createTextReporter((LintCliClient)client, (LintCliFlags)flags, (File)file, (Writer)writer, (boolean)closeWriter));
            }
            if (this.htmlReport) {
                output = this.htmlOutput;
                if (output == null || flags.isFatalOnly()) {
                    output = LintOptions.createOutputPath(project, variantName, ".html", reportsDir, flags.isFatalOnly());
                } else if (!output.isAbsolute()) {
                    output = project.file((Object)output.getPath());
                }
                output = LintOptions.validateOutputFile(output);
                try {
                    flags.getReporters().add(Reporter.createHtmlReporter((LintCliClient)client, (File)output, (LintCliFlags)flags, (boolean)false));
                }
                catch (IOException e) {
                    throw new GradleException("HTML invalid argument.", (Throwable)e);
                }
            }
            if (this.xmlReport) {
                output = this.xmlOutput;
                if (output == null || flags.isFatalOnly()) {
                    output = LintOptions.createOutputPath(project, variantName, ".xml", reportsDir, flags.isFatalOnly());
                } else if (!output.isAbsolute()) {
                    output = project.file((Object)output.getPath());
                }
                output = LintOptions.validateOutputFile(output);
                try {
                    flags.getReporters().add(Reporter.createXmlReporter((LintCliClient)client, (File)output, (boolean)false));
                }
                catch (IOException e) {
                    throw new GradleException("XML invalid argument.", (Throwable)e);
                }
            }
        }
    }

    private static boolean isStdOut(File output) {
        return STDOUT.equals(output.getPath());
    }

    private static boolean isStdErr(File output) {
        return STDERR.equals(output.getPath());
    }

    private static File validateOutputFile(File output) {
        boolean delete;
        if (LintOptions.isStdOut(output) || LintOptions.isStdErr(output)) {
            return output;
        }
        File parent = output.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        if ((output = output.getAbsoluteFile()).exists() && !(delete = output.delete())) {
            throw new GradleException("Could not delete old " + output);
        }
        if (output.getParentFile() != null && !output.getParentFile().canWrite()) {
            throw new GradleException("Cannot write output file " + output);
        }
        return output;
    }

    private static File createOutputPath(Project project, String variantName, String extension, File reportsDir, boolean fatalOnly) {
        StringBuilder base = new StringBuilder();
        base.append("lint-results");
        if (!Strings.isNullOrEmpty((String)variantName)) {
            base.append("-");
            base.append(variantName);
        }
        if (fatalOnly) {
            base.append("-fatal");
        }
        base.append(extension);
        if (reportsDir != null) {
            return new File(reportsDir, base.toString());
        }
        if (project == null) {
            return new File(base.toString());
        }
        File buildDir = project.getBuildDir();
        return new File(buildDir, "reports" + File.separator + base.toString());
    }

    public File getBaselineFile() {
        return this.baselineFile;
    }

    public void setBaselineFile(File baselineFile) {
        this.baselineFile = baselineFile;
    }

    public void baseline(String baseline) {
        File file = new File(baseline);
        if (!file.isAbsolute()) {
            file = file.getAbsoluteFile();
        }
        this.baselineFile = file;
    }

    public void baseline(File baselineFile) {
        this.baselineFile = baselineFile;
    }

    public Map<String, Integer> getSeverityOverrides() {
        if (this.severities == null || this.severities.isEmpty()) {
            return null;
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)this.severities.size());
        for (Map.Entry<String, Severity> entry : this.severities.entrySet()) {
            map.put(entry.getKey(), LintOptions.convert(entry.getValue()));
        }
        return map;
    }

    public void check(String id) {
        this.check.add(id);
    }

    public void check(String ... ids) {
        for (String id : ids) {
            this.check(id);
        }
    }

    public void enable(String id) {
        this.enable.add(id);
        Issue issue = new BuiltinIssueRegistry().getIssue(id);
        this.severities.put(id, issue != null ? issue.getDefaultSeverity() : Severity.WARNING);
    }

    public void enable(String ... ids) {
        for (String id : ids) {
            this.enable(id);
        }
    }

    public void disable(String id) {
        this.disable.add(id);
        this.severities.put(id, Severity.IGNORE);
    }

    public void disable(String ... ids) {
        for (String id : ids) {
            this.disable(id);
        }
    }

    public void textOutput(String textOutput) {
        this.textOutput = new File(textOutput);
    }

    public void textOutput(File textOutput) {
        this.textOutput = textOutput;
    }

    public void fatal(String id) {
        this.severities.put(id, Severity.FATAL);
    }

    public void fatal(String ... ids) {
        for (String id : ids) {
            this.fatal(id);
        }
    }

    public void error(String id) {
        this.severities.put(id, Severity.ERROR);
    }

    public void error(String ... ids) {
        for (String id : ids) {
            this.error(id);
        }
    }

    public void warning(String id) {
        this.severities.put(id, Severity.WARNING);
    }

    public void warning(String ... ids) {
        for (String id : ids) {
            this.warning(id);
        }
    }

    public void ignore(String id) {
        this.severities.put(id, Severity.IGNORE);
    }

    public void ignore(String ... ids) {
        for (String id : ids) {
            this.ignore(id);
        }
    }

    public void informational(String id) {
        this.severities.put(id, Severity.INFORMATIONAL);
    }

    public void informational(String ... ids) {
        for (String id : ids) {
            this.informational(id);
        }
    }

    private static int convert(Severity s) {
        switch (s) {
            case FATAL: {
                return 1;
            }
            case ERROR: {
                return 2;
            }
            case WARNING: {
                return 3;
            }
            case INFORMATIONAL: {
                return 4;
            }
        }
        return 5;
    }

    private static Severity convert(int s) {
        switch (s) {
            case 1: {
                return Severity.FATAL;
            }
            case 2: {
                return Severity.ERROR;
            }
            case 3: {
                return Severity.WARNING;
            }
            case 4: {
                return Severity.INFORMATIONAL;
            }
        }
        return Severity.IGNORE;
    }

    @Input
    public String getCombinedInput() {
        return new CombinedInput().add("htmlOutput", this.getHtmlOutput()).add("xmlOutput", this.getXmlOutput()).toString();
    }
}

