/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jacoco.core.instr.Instrumenter;
import org.jacoco.core.runtime.IExecutionDataAccessorGenerator;
import org.jacoco.core.runtime.OfflineInstrumentationAccessGenerator;

public class JacocoTransform
extends Transform {
    private static final Pattern CLASS_PATTERN = Pattern.compile(".*\\.class$");
    private static final Pattern KOTLIN_MODULE_PATTERN = Pattern.compile("^META-INF/.*\\.kotlin_module$");

    public String getName() {
        return "jacoco";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.CONTENT_CLASS;
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return Sets.immutableEnumSet((Enum)QualifiedContent.Scope.PROJECT, (Enum[])new QualifiedContent.Scope[0]);
    }

    public boolean isIncremental() {
        return true;
    }

    public boolean isCacheable() {
        return true;
    }

    public void transform(TransformInvocation invocation) throws IOException, TransformException, InterruptedException {
        for (TransformInput input : invocation.getInputs()) {
            Preconditions.checkState((boolean)input.getJarInputs().isEmpty());
            for (DirectoryInput directoryInput : input.getDirectoryInputs()) {
                File inputDir = directoryInput.getFile();
                File outputDir = invocation.getOutputProvider().getContentLocation(directoryInput.getName(), this.getOutputTypes(), this.getScopes(), Format.DIRECTORY);
                FileUtils.mkdirs((File)outputDir);
                Instrumenter instrumenter = new Instrumenter((IExecutionDataAccessorGenerator)new OfflineInstrumentationAccessGenerator());
                if (invocation.isIncremental()) {
                    JacocoTransform.instrumentFilesIncremental(instrumenter, inputDir, outputDir, directoryInput.getChangedFiles());
                    continue;
                }
                JacocoTransform.instrumentFilesFullRun(instrumenter, inputDir, outputDir);
            }
        }
    }

    private static void instrumentFilesIncremental(Instrumenter instrumenter, File inputDir, File outputDir, Map<File, Status> changedFiles) throws IOException {
        for (Map.Entry<File, Status> changedInput : changedFiles.entrySet()) {
            File inputFile = changedInput.getKey();
            Action fileAction = JacocoTransform.calculateAction(inputFile, inputDir);
            if (fileAction == Action.IGNORE) continue;
            File outputFile = new File(outputDir, FileUtils.relativePossiblyNonExistingPath((File)inputFile, (File)inputDir));
            block0 : switch (changedInput.getValue()) {
                case REMOVED: {
                    FileUtils.delete((File)outputFile);
                    break;
                }
                case ADDED: 
                case CHANGED: {
                    switch (fileAction) {
                        case COPY: {
                            JacocoTransform.copy(inputFile, outputFile);
                            break block0;
                        }
                        case INSTRUMENT: {
                            JacocoTransform.instrumentFile(instrumenter, inputFile, outputFile);
                            break block0;
                        }
                        case IGNORE: {
                            break block0;
                        }
                    }
                    throw new RuntimeException("Unsupported Action: " + fileAction.toString());
                }
            }
        }
    }

    private static void instrumentFilesFullRun(Instrumenter instrumenter, File inputDir, File outputDir) throws IOException {
        FileUtils.cleanOutputDir((File)outputDir);
        FluentIterable files = FileUtils.getAllFiles((File)inputDir);
        block5: for (File inputFile : files) {
            Action fileAction = JacocoTransform.calculateAction(inputFile, inputDir);
            if (fileAction == Action.IGNORE) continue;
            File outputFile = new File(outputDir, FileUtils.relativePath((File)inputFile, (File)inputDir));
            switch (fileAction) {
                case COPY: {
                    JacocoTransform.copy(inputFile, outputFile);
                    continue block5;
                }
                case INSTRUMENT: {
                    JacocoTransform.instrumentFile(instrumenter, inputFile, outputFile);
                    continue block5;
                }
                case IGNORE: {
                    continue block5;
                }
            }
            throw new RuntimeException("Unsupported Action: " + fileAction.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void instrumentFile(Instrumenter instrumenter, File inputFile, File outputFile) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = Files.asByteSource((File)inputFile).openBufferedStream();
            Files.createParentDirs((File)outputFile);
            byte[] instrumented = instrumenter.instrument(inputStream, inputFile.toString());
            Files.write((byte[])instrumented, (File)outputFile);
        }
        finally {
            Closeables.closeQuietly((InputStream)inputStream);
        }
    }

    private static void copy(File inputFile, File outputFile) throws IOException {
        Files.createParentDirs((File)outputFile);
        Files.copy((File)inputFile, (File)outputFile);
    }

    private static Action calculateAction(File inputFile, File inputDir) {
        String inputRelativePath = FileUtils.toSystemIndependentPath((String)FileUtils.relativePossiblyNonExistingPath((File)inputFile, (File)inputDir));
        for (Pattern pattern : Action.COPY.getPatterns()) {
            if (!pattern.matcher(inputRelativePath).matches()) continue;
            return Action.COPY;
        }
        for (Pattern pattern : Action.INSTRUMENT.getPatterns()) {
            if (!pattern.matcher(inputRelativePath).matches()) continue;
            return Action.INSTRUMENT;
        }
        return Action.IGNORE;
    }

    static /* synthetic */ Pattern access$000() {
        return KOTLIN_MODULE_PATTERN;
    }

    static /* synthetic */ Pattern access$100() {
        return CLASS_PATTERN;
    }

    private static enum Action {
        COPY(JacocoTransform.access$000()),
        IGNORE(new Pattern[0]),
        INSTRUMENT(JacocoTransform.access$100());

        private final ImmutableList<Pattern> patterns;

        private Action(Pattern ... patterns) {
            ImmutableList.Builder builder = new ImmutableList.Builder();
            for (Pattern pattern : patterns) {
                Preconditions.checkNotNull((Object)pattern);
                builder.add((Object)pattern);
            }
            this.patterns = builder.build();
        }

        ImmutableList<Pattern> getPatterns() {
            return this.patterns;
        }
    }
}

