/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.tasks.LintBaseTask;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.Variant;
import com.android.utils.StringHelper;
import java.io.IOException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public class LintPerVariantTask
extends LintBaseTask {
    private LintBaseTask.VariantInputs variantInputs;

    @InputFiles
    @Optional
    public FileCollection getVariantInputs() {
        return this.variantInputs.getAllInputs();
    }

    @TaskAction
    public void lint() throws IOException {
        AndroidProject modelProject = this.createAndroidProject(this.getProject());
        for (Variant variant : modelProject.getVariants()) {
            if (!variant.getName().equals(this.getVariantName())) continue;
            this.lintSingleVariant(modelProject, variant);
            break;
        }
    }

    public void lintSingleVariant(AndroidProject modelProject, Variant variant) {
        this.runLint(modelProject, variant, this.variantInputs, true);
    }

    public static class VitalConfigAction
    extends LintBaseTask.BaseConfigAction<LintPerVariantTask> {
        private final VariantScope scope;

        public VitalConfigAction(VariantScope scope) {
            super(scope.getGlobalScope());
            this.scope = scope;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("lintVital");
        }

        @Override
        public Class<LintPerVariantTask> getType() {
            return LintPerVariantTask.class;
        }

        @Override
        public void execute(LintPerVariantTask task) {
            super.execute(task);
            String variantName = this.scope.getVariantData().getVariantConfiguration().getFullName();
            task.setVariantName(variantName);
            task.variantInputs = new LintBaseTask.VariantInputs(this.scope);
            task.setFatalOnly(true);
            task.setDescription("Runs lint on just the fatal issues in the " + variantName + " build.");
        }
    }

    public static class ConfigAction
    extends LintBaseTask.BaseConfigAction<LintPerVariantTask> {
        private final VariantScope scope;

        public ConfigAction(VariantScope scope) {
            super(scope.getGlobalScope());
            this.scope = scope;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("lint");
        }

        @Override
        public Class<LintPerVariantTask> getType() {
            return LintPerVariantTask.class;
        }

        @Override
        public void execute(LintPerVariantTask lint) {
            super.execute(lint);
            lint.setVariantName(this.scope.getVariantConfiguration().getFullName());
            lint.variantInputs = new LintBaseTask.VariantInputs(this.scope);
            lint.setDescription("Runs lint on the " + StringHelper.capitalize((String)this.scope.getVariantConfiguration().getFullName()) + " build.");
        }
    }
}

