/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.res2;

import com.android.ide.common.res2.MergeConsumer;
import com.android.ide.common.res2.MergingException;
import com.android.ide.common.res2.NamespaceAwareTable;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.res2.ResourceMerger;
import com.android.resources.ResourceType;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Tables;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilderFactory;

public final class ResourceTable
extends NamespaceAwareTable<ResourceType, ListMultimap<String, ResourceItem>> {
    public ResourceTable() {
        super(Tables.newCustomTable(new HashMap(), () -> Maps.newEnumMap(ResourceType.class)));
    }

    public void remove(ResourceItem resourceItem) {
        String namespace = resourceItem.getNamespace();
        ResourceType type = resourceItem.getType();
        String name = resourceItem.getName();
        ListMultimap multimap = (ListMultimap)this.get(namespace, type);
        if (multimap != null) {
            multimap.remove((Object)name, (Object)resourceItem);
            if (multimap.isEmpty()) {
                this.remove(namespace, type);
            }
        }
    }

    public ListMultimap<String, ResourceItem> getOrPutEmpty(String namespace, ResourceType resourceType) {
        ListMultimap multimap = (ListMultimap)this.get(namespace, resourceType);
        if (multimap == null) {
            multimap = ArrayListMultimap.create();
            this.put(namespace, resourceType, multimap);
        }
        return multimap;
    }

    public void update(ResourceMerger merger) {
        MergeConsumer<ResourceItem> mergeConsumer = new MergeConsumer<ResourceItem>(){

            @Override
            public void start(DocumentBuilderFactory factory) throws MergeConsumer.ConsumerException {
            }

            @Override
            public void end() throws MergeConsumer.ConsumerException {
            }

            @Override
            public void addItem(ResourceItem item) throws MergeConsumer.ConsumerException {
                ListMultimap<String, ResourceItem> multimap;
                if (item.isTouched() && !(multimap = ResourceTable.this.getOrPutEmpty(item.getNamespace(), item.getType())).containsEntry((Object)item.getName(), (Object)item)) {
                    multimap.put((Object)item.getName(), (Object)item);
                }
            }

            @Override
            public void removeItem(ResourceItem removedItem, ResourceItem replacedBy) throws MergeConsumer.ConsumerException {
                ResourceTable.this.remove(removedItem);
            }

            @Override
            public boolean ignoreItemInMerge(ResourceItem item) {
                return false;
            }
        };
        try {
            merger.mergeData(mergeConsumer, true);
        }
        catch (MergingException e) {
            throw new RuntimeException(e);
        }
    }
}

