/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.ide.common.vectordrawable.GradientStop;
import com.android.ide.common.vectordrawable.PathParser;
import com.android.ide.common.vectordrawable.Svg2Vector;
import com.android.ide.common.vectordrawable.SvgGroupNode;
import com.android.ide.common.vectordrawable.SvgLeafNode;
import com.android.ide.common.vectordrawable.SvgNode;
import com.android.ide.common.vectordrawable.SvgTree;
import com.android.ide.common.vectordrawable.VdNodeRender;
import com.android.ide.common.vectordrawable.VdPath;
import com.google.common.collect.ImmutableMap;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Node;

public class SvgGradientNode
extends SvgNode {
    private static final Logger logger = Logger.getLogger(SvgGroupNode.class.getSimpleName());
    private final ArrayList<GradientStop> myGradientStops = new ArrayList();
    private SvgLeafNode mSvgLeafNode;
    private Rectangle2D boundingBox;
    private GradientUsage mGradientUsage;
    public static final ImmutableMap<String, Integer> vectorCoordinateMap = ImmutableMap.builder().put((Object)"x1", (Object)0).put((Object)"y1", (Object)1).put((Object)"x2", (Object)2).put((Object)"y2", (Object)3).build();

    public SvgGradientNode(SvgTree svgTree, Node node, String nodeName) {
        super(svgTree, node, nodeName);
    }

    @Override
    public SvgGradientNode deepCopy() {
        SvgGradientNode newInstance = new SvgGradientNode(this.getTree(), this.getDocumentNode(), this.getName());
        this.copyTo(newInstance);
        return newInstance;
    }

    @Override
    public boolean isGroupNode() {
        return false;
    }

    protected void copyTo(SvgGradientNode newInstance) {
        super.copyTo(newInstance);
        for (GradientStop g : this.myGradientStops) {
            newInstance.addGradientStop(g.getColor(), g.getOffset(), g.getOpacity());
        }
    }

    @Override
    public void dumpNode(String indent) {
        logger.log(Level.FINE, indent + "current gradient is :" + this.getName());
    }

    @Override
    public void transformIfNeeded(AffineTransform rootTransform) {
        AffineTransform finalTransform = new AffineTransform(rootTransform);
        finalTransform.concatenate(this.mStackedTransform);
    }

    @Override
    public void flatten(AffineTransform transform) {
        this.mStackedTransform.setTransform(transform);
        this.mStackedTransform.concatenate(this.mLocalTransform);
    }

    private double getGradientCoordinate(String x, double defaultValue) {
        if (!this.mVdAttributesMap.containsKey(x)) {
            return defaultValue;
        }
        double val = defaultValue;
        String vdValue = ((String)this.mVdAttributesMap.get(x)).trim();
        if (vdValue.endsWith("%")) {
            try {
                val = Double.parseDouble(vdValue.substring(0, vdValue.length() - 1));
            }
            catch (NumberFormatException e) {
                this.getTree().logErrorLine("Unsupported coordinate percentage value", this.getDocumentNode(), SvgTree.SvgLogLevel.ERROR);
            }
            val /= 100.0;
        } else {
            try {
                val = Double.parseDouble(vdValue);
            }
            catch (NumberFormatException e) {
                this.getTree().logErrorLine("Unsupported coordinate value", this.getDocumentNode(), SvgTree.SvgLogLevel.ERROR);
            }
        }
        return val;
    }

    @Override
    public void writeXML(OutputStreamWriter writer, boolean inClipPath) throws IOException {
        if (this.mGradientUsage == GradientUsage.FILL) {
            writer.write("        <aapt:attr name=\"android:fillColor\">\n");
        } else {
            writer.write("        <aapt:attr name=\"android:strokeColor\">\n");
        }
        writer.write("<gradient \n");
        this.setBoundingBox();
        double height = this.boundingBox.getHeight();
        double width = this.boundingBox.getWidth();
        double startX = this.boundingBox.getX();
        double startY = this.boundingBox.getY();
        if (this.mVdAttributesMap.containsKey("gradientUnits") && ((String)this.mVdAttributesMap.get("gradientUnits")).equals("userSpaceOnUse")) {
            startX = 0.0;
            startY = 0.0;
            height = this.getTree().getHeight();
            width = this.getTree().getWidth();
        }
        if (this.mVdAttributesMap.containsKey("gradientTransform")) {
            String transformValue = (String)this.mVdAttributesMap.get("gradientTransform");
            this.parseLocalTransform(transformValue);
        }
        double[] gradientBounds = new double[4];
        double[] transformedBounds = new double[4];
        for (String s : vectorCoordinateMap.keySet()) {
            int index = (Integer)vectorCoordinateMap.get((Object)s);
            double defaultValue = 0.0;
            if (index == 2) {
                defaultValue = 1.0;
            }
            double value = this.getGradientCoordinate(s, defaultValue);
            value = index % 2 == 0 ? value * width + startX : value * height + startY;
            gradientBounds[index] = value;
            transformedBounds[index] = value;
            if (this.mVdAttributesMap.containsKey(s)) continue;
            this.mVdAttributesMap.put(s, "");
        }
        this.mLocalTransform.concatenate(this.mSvgLeafNode.mStackedTransform);
        this.mLocalTransform.transform(gradientBounds, 0, transformedBounds, 0, 2);
        for (String key : this.mVdAttributesMap.keySet()) {
            String gradientAttr = (String)Svg2Vector.gradientMap.get((Object)key);
            String svgValue = (String)this.mVdAttributesMap.get(key);
            String vdValue = svgValue.trim();
            if (vdValue.startsWith("rgb")) {
                String vdValueRGB = vdValue = vdValue.substring(3, vdValue.length());
                if ((vdValue = SvgLeafNode.convertRGBToHex(vdValue.substring(3, vdValue.length()))) == null) {
                    this.getTree().logErrorLine("Unsupported Color format " + vdValueRGB, this.getDocumentNode(), SvgTree.SvgLogLevel.ERROR);
                }
            } else if (SvgLeafNode.colorMap.containsKey((Object)vdValue.toLowerCase(Locale.ENGLISH))) {
                vdValue = (String)SvgLeafNode.colorMap.get((Object)vdValue.toLowerCase(Locale.ENGLISH));
            } else if (vectorCoordinateMap.containsKey((Object)key)) {
                double x = transformedBounds[(Integer)vectorCoordinateMap.get((Object)key)];
                vdValue = String.valueOf(x);
            } else if (key.equals("spreadMethod")) {
                if (vdValue.equals("pad")) {
                    vdValue = "clamp";
                } else if (vdValue.equals("reflect")) {
                    vdValue = "mirror";
                }
            }
            if (gradientAttr.isEmpty()) continue;
            writer.write("\n        " + gradientAttr + "=\"" + vdValue + "\"");
        }
        writer.write(">\n");
        for (GradientStop g : this.myGradientStops) {
            g.formatStopAttributes();
            String color = g.getColor();
            float opacity = 1.0f;
            try {
                opacity = Float.parseFloat(g.getOpacity());
            }
            catch (NumberFormatException e) {
                this.getTree().logErrorLine("Unsupported opacity value", this.getDocumentNode(), SvgTree.SvgLogLevel.WARNING);
            }
            int color1 = VdPath.applyAlpha(VdPath.calculateColor(color), opacity);
            StringBuilder hex = new StringBuilder(Integer.toHexString(color1).toUpperCase(Locale.ENGLISH));
            while (hex.length() < 8) {
                hex.insert(0, "0");
            }
            color = "#" + hex;
            writer.write("<item android:offset=\"" + g.getOffset() + "\"");
            writer.write(" android:color=\"" + color + "\" />\n");
        }
        writer.write("            </gradient>");
        writer.write("</aapt:attr>");
    }

    public void addGradientStop(String color, String offset, String opacity) {
        GradientStop stop = new GradientStop(color, offset);
        stop.setOpacity(opacity);
        this.myGradientStops.add(stop);
    }

    public void setGradientUsage(GradientUsage gradientUsage) {
        this.mGradientUsage = gradientUsage;
    }

    public void setSvgLeafNode(SvgLeafNode mSvgLeafNode) {
        this.mSvgLeafNode = mSvgLeafNode;
    }

    private void setBoundingBox() {
        Path2D.Double svgPath = new Path2D.Double();
        VdPath.Node[] nodes = PathParser.parsePath(this.mSvgLeafNode.getPathData());
        VdNodeRender.createPath(nodes, svgPath);
        this.boundingBox = svgPath.getBounds2D();
    }

    protected static enum GradientUsage {
        FILL,
        STROKE;

    }
}

