/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira.jql.codeinsight;

import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.tasks.jira.jql.codeinsight.JqlStandardFunction;
import com.intellij.tasks.jira.jql.psi.JqlElementVisitor;
import com.intellij.tasks.jira.jql.psi.JqlEmptyValue;
import com.intellij.tasks.jira.jql.psi.JqlFunctionCall;
import com.intellij.tasks.jira.jql.psi.JqlIdentifier;
import com.intellij.tasks.jira.jql.psi.JqlList;
import com.intellij.tasks.jira.jql.psi.JqlOperand;
import com.intellij.tasks.jira.jql.psi.JqlSimpleClause;
import com.intellij.tasks.jira.jql.psi.JqlTerminalClause;
import org.jetbrains.annotations.NotNull;

public class JqlAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, final @NotNull AnnotationHolder holder) {
        element.accept((PsiElementVisitor)new JqlElementVisitor(){

            @Override
            public void visitEmptyValue(JqlEmptyValue emptyValue) {
                JqlSimpleClause clause = (JqlSimpleClause)PsiTreeUtil.getParentOfType((PsiElement)emptyValue, JqlSimpleClause.class);
                if (clause != null && !JqlAnnotator.isEmptyClause(clause)) {
                    holder.createErrorAnnotation((PsiElement)emptyValue, String.format("Not expecting '%s' here", emptyValue.getText()));
                }
            }

            @Override
            public void visitJqlList(JqlList list) {
                JqlSimpleClause clause = (JqlSimpleClause)PsiTreeUtil.getParentOfType((PsiElement)list, JqlSimpleClause.class);
                if (clause != null && !JqlAnnotator.isListClause(clause)) {
                    holder.createErrorAnnotation((PsiElement)list, String.format("Not expecting list of values here", new Object[0]));
                }
            }

            @Override
            public void visitJqlSimpleClause(JqlSimpleClause clause) {
                boolean hasListOperand;
                JqlOperand operand = clause.getOperand();
                if (operand == null) {
                    return;
                }
                boolean operandIsListLiteral = operand instanceof JqlList;
                boolean operandIsListFunction = false;
                if (operand instanceof JqlFunctionCall) {
                    JqlFunctionCall functionCall = (JqlFunctionCall)operand;
                    JqlStandardFunction standardFunction = JqlStandardFunction.byName(functionCall.getFunctionName().getText());
                    operandIsListFunction = standardFunction != null && standardFunction.hasMultipleResults();
                }
                boolean bl = hasListOperand = operandIsListLiteral || operandIsListFunction;
                if (JqlAnnotator.isListClause(clause) && !hasListOperand) {
                    holder.createErrorAnnotation((PsiElement)operand, "Expecting list of values here");
                }
                boolean hasEmptyOperand = operand instanceof JqlEmptyValue;
                if (JqlAnnotator.isEmptyClause(clause) && !hasEmptyOperand) {
                    holder.createErrorAnnotation((PsiElement)operand, "Expecting 'empty' or 'null' here");
                }
            }

            @Override
            public void visitJqlIdentifier(JqlIdentifier identifier) {
                Annotation annotation = holder.createInfoAnnotation((PsiElement)identifier, null);
                annotation.setEnforcedTextAttributes(DefaultLanguageHighlighterColors.CONSTANT.getDefaultAttributes());
            }
        });
    }

    private static boolean isEmptyClause(JqlTerminalClause clause) {
        JqlTerminalClause.Type clauseType = clause.getType();
        return clauseType == JqlTerminalClause.Type.IS || clauseType == JqlTerminalClause.Type.IS_NOT;
    }

    private static boolean isListClause(JqlTerminalClause clause) {
        JqlTerminalClause.Type clauseType = clause.getType();
        return clauseType != null && clauseType.isListOperator();
    }
}

