/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.Main;
import com.android.tools.lint.MultiProjectHtmlReporter;
import com.android.tools.lint.Reporter;
import com.android.tools.lint.Warning;
import com.android.tools.lint.checks.BuiltinIssueRegistry;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.utils.SdkUtils;
import com.google.common.annotations.Beta;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

@Beta
public class HtmlReporter
extends Reporter {
    public static final boolean INLINE_RESOURCES = !"false".equals(System.getProperty("lint.inline-resources"));
    private static final boolean USE_HOLO_STYLE = true;
    private static final String CSS = "hololike.css";
    private static final int SPLIT_LIMIT = 8;
    private static final int SHOWN_COUNT = 5;
    protected final Writer writer;
    protected final LintCliFlags flags;
    private String fixUrl;

    public HtmlReporter(LintCliClient client, File output, LintCliFlags flags) throws IOException {
        super(client, output);
        this.writer = new BufferedWriter(Files.newWriter((File)output, (Charset)Charsets.UTF_8));
        this.flags = flags;
    }

    @Override
    public void write(Reporter.Stats stats, List<Warning> issues) throws IOException {
        Map<Issue, String> missing = this.computeMissingIssues(issues);
        this.writer.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" /><title>" + this.title + "</title>\n");
        this.writeStyleSheet();
        if (!this.simpleFormat) {
            this.writer.write("<script language=\"javascript\" type=\"text/javascript\"> \n<!--\nfunction reveal(id) {\nif (document.getElementById) {\ndocument.getElementById(id).style.display = 'block';\ndocument.getElementById(id+'Link').style.display = 'none';\n}\n}\n//--> \n</script>\n");
        }
        this.writer.write("</head>\n<body>\n<h1>" + this.title + "</h1>\n<div class=\"titleSeparator\"></div>\n");
        this.writer.write(String.format("Check performed at %1$s.", new Date().toString()));
        this.writer.write("<br/>\n");
        this.writer.write(String.format("%1$s found", LintUtils.describeCounts((int)stats.errorCount, (int)stats.warningCount, (boolean)false, (boolean)true)));
        if (stats.baselineErrorCount > 0 || stats.baselineWarningCount > 0) {
            File baselineFile = this.flags.getBaselineFile();
            assert (baselineFile != null);
            this.writer.write(String.format(" (%1$s filtered by baseline %2$s)", LintUtils.describeCounts((int)stats.baselineErrorCount, (int)stats.baselineWarningCount, (boolean)false, (boolean)true), baselineFile.getName()));
        }
        this.writer.write(":");
        this.writer.write("<br/><br/>\n");
        Issue previousIssue = null;
        if (!issues.isEmpty()) {
            ArrayList<List<Warning>> related = new ArrayList<List<Warning>>();
            ArrayList<Warning> currentList = null;
            for (Warning warning : issues) {
                if (warning.issue != previousIssue) {
                    previousIssue = warning.issue;
                    currentList = new ArrayList<Warning>();
                    related.add(currentList);
                }
                assert (currentList != null);
                currentList.add(warning);
            }
            this.writeOverview(related, missing.size());
            Category previousCategory = null;
            for (List list : related) {
                Warning first = (Warning)list.get(0);
                Issue issue = first.issue;
                if (issue.getCategory() != previousCategory) {
                    previousCategory = issue.getCategory();
                    this.writer.write("\n<a name=\"");
                    this.writer.write(issue.getCategory().getFullName());
                    this.writer.write("\"></a>\n");
                    this.writer.write("<div class=\"category\"><a href=\"#\" title=\"Return to top\">");
                    this.writer.write(issue.getCategory().getFullName());
                    this.writer.write("</a><div class=\"categorySeparator\"></div>\n");
                    this.writer.write("</div>\n");
                }
                this.writer.write("<a name=\"" + issue.getId() + "\"></a>\n");
                this.writer.write("<div class=\"issue\">\n");
                this.writer.write("<div class=\"id\"><a href=\"#\" title=\"Return to top\">");
                this.writer.write(issue.getId());
                this.writer.write(": ");
                this.writer.write(issue.getBriefDescription(TextFormat.HTML));
                this.writer.write("</a><div class=\"issueSeparator\"></div>\n");
                this.writer.write("</div>\n");
                this.writer.write("<div class=\"warningslist\">\n");
                boolean partialHide = !this.simpleFormat && list.size() > 8;
                int count = 0;
                for (Warning warning : list) {
                    if (partialHide && count == 5) {
                        String id = warning.issue.getId() + "Div";
                        this.writer.write("<button id=\"");
                        this.writer.write(id);
                        this.writer.write("Link\" onclick=\"reveal('");
                        this.writer.write(id);
                        this.writer.write("');\" />");
                        this.writer.write(String.format("+ %1$d More Occurrences...", list.size() - 5));
                        this.writer.write("</button>\n");
                        this.writer.write("<div id=\"");
                        this.writer.write(id);
                        this.writer.write("\" style=\"display: none\">\n");
                    }
                    ++count;
                    String url = null;
                    if (warning.path != null) {
                        url = this.writeLocation(warning.file, warning.path, warning.line);
                        this.writer.write(58);
                        this.writer.write(32);
                    }
                    boolean addedImage = false;
                    if (url != null && warning.location != null && warning.location.getSecondary() == null) {
                        addedImage = this.addImage(url, warning.location);
                    }
                    this.writer.write("<span class=\"message\">");
                    this.writer.append(TextFormat.RAW.convertTo(warning.message, TextFormat.HTML));
                    this.writer.write("</span>");
                    if (addedImage) {
                        this.writer.write("<br clear=\"right\"/>");
                    } else {
                        this.writer.write("<br />");
                    }
                    if (warning.line >= 0 && warning.fileContents != null) {
                        this.writer.write("<pre class=\"errorlines\">\n");
                        this.appendCodeBlock(warning.fileContents, warning.line, warning.offset);
                        this.writer.write("\n</pre>");
                    }
                    this.writer.write(10);
                    if (warning.location != null && warning.location.getSecondary() != null) {
                        String path;
                        int line;
                        Position start;
                        Location l;
                        this.writer.write("<ul>");
                        int otherLocations = 0;
                        for (l = warning.location.getSecondary(); l != null; l = l.getSecondary()) {
                            String message = l.getMessage();
                            if (message != null && !message.isEmpty()) {
                                CharSequence s;
                                start = l.getStart();
                                line = start != null ? start.getLine() : -1;
                                path = this.client.getDisplayPath(warning.project, l.getFile());
                                this.writeLocation(l.getFile(), path, line);
                                this.writer.write(58);
                                this.writer.write(32);
                                this.writer.write("<span class=\"message\">");
                                this.writer.append(TextFormat.RAW.convertTo(message, TextFormat.HTML));
                                this.writer.write("</span>");
                                this.writer.write("<br />");
                                String name = l.getFile().getName();
                                if (LintUtils.endsWith((String)name, (String)".png") || LintUtils.endsWith((String)name, (String)".jpg") || (s = this.client.readFile(l.getFile())).length() <= 0) continue;
                                this.writer.write("<pre class=\"errorlines\">\n");
                                int offset = start != null ? start.getOffset() : -1;
                                this.appendCodeBlock(s, line, offset);
                                this.writer.write("\n</pre>");
                                continue;
                            }
                            ++otherLocations;
                        }
                        this.writer.write("</ul>");
                        if (otherLocations > 0) {
                            String id = "Location" + count + "Div";
                            this.writer.write("<button id=\"");
                            this.writer.write(id);
                            this.writer.write("Link\" onclick=\"reveal('");
                            this.writer.write(id);
                            this.writer.write("');\" />");
                            this.writer.write(String.format("+ %1$d Additional Locations...", otherLocations));
                            this.writer.write("</button>\n");
                            this.writer.write("<div id=\"");
                            this.writer.write(id);
                            this.writer.write("\" style=\"display: none\">\n");
                            this.writer.write("Additional locations: ");
                            this.writer.write("<ul>\n");
                            for (l = warning.location.getSecondary(); l != null; l = l.getSecondary()) {
                                start = l.getStart();
                                line = start != null ? start.getLine() : -1;
                                path = this.client.getDisplayPath(warning.project, l.getFile());
                                this.writer.write("<li> ");
                                this.writeLocation(l.getFile(), path, line);
                                this.writer.write("\n");
                            }
                            this.writer.write("</ul>\n");
                            this.writer.write("</div><br/><br/>\n");
                        }
                    }
                    if (!addedImage && url != null && warning.location != null && warning.location.getSecondary() != null) {
                        this.addImage(url, warning.location);
                    }
                    if (!warning.isVariantSpecific()) continue;
                    this.writer.write("\n");
                    this.writer.write("Applies to variants: ");
                    this.writer.write(Joiner.on((String)", ").join(warning.getIncludedVariantNames()));
                    this.writer.write("<br/>\n");
                    this.writer.write("Does <b>not</b> apply to variants: ");
                    this.writer.write(Joiner.on((String)", ").join(warning.getExcludedVariantNames()));
                    this.writer.write("<br/>\n");
                }
                if (partialHide) {
                    this.writer.write("</div>\n");
                }
                this.writer.write("</div>\n");
                this.writeIssueMetadata(issue, first.severity, null);
                this.writer.write("</div>\n");
            }
            if (!this.client.isCheckingSpecificIssues()) {
                this.writeMissingIssues(missing);
            }
            this.writeSuppressInfo();
        } else {
            this.writer.write("Congratulations!");
        }
        this.writer.write("\n</body>\n</html>");
        this.writer.close();
        if (!(this.client.getFlags().isQuiet() || stats.errorCount <= 0 && stats.warningCount <= 0)) {
            String url = SdkUtils.fileToUrlString((File)this.output.getAbsoluteFile());
            System.out.println(String.format("Wrote HTML report to %1$s", url));
        }
    }

    private void writeIssueMetadata(Issue issue, Severity severity, String disabledBy) throws IOException {
        this.writer.write("<div class=\"metadata\">");
        if (this.client.getRegistry() instanceof BuiltinIssueRegistry && HtmlReporter.hasAutoFix(issue)) {
            this.writer.write("Note: This issue has an associated quickfix operation in Android Studio and IntelliJ");
            if (!INLINE_RESOURCES) {
                this.writer.write(HtmlReporter.getFixIcon());
            } else if (this.fixUrl != null) {
                this.writer.write("&nbsp;<img alt=\"Fix\" border=\"0\" align=\"top\" src=\"");
                this.writer.write(this.fixUrl);
                this.writer.write("\" />\n");
            }
            this.writer.write("<br>\n");
        }
        if (disabledBy != null) {
            this.writer.write(String.format("Disabled By: %1$s<br/>\n", disabledBy));
        }
        this.writer.write("Priority: ");
        this.writer.write(String.format("%1$d / 10", issue.getPriority()));
        this.writer.write("<br/>\n");
        this.writer.write("Category: ");
        this.writer.write(issue.getCategory().getFullName());
        this.writer.write("</div>\n");
        this.writer.write("Severity: ");
        if (severity.isError()) {
            this.writer.write("<span class=\"error\">");
        } else if (severity == Severity.WARNING) {
            this.writer.write("<span class=\"warning\">");
        } else {
            this.writer.write("<span>");
        }
        this.appendEscapedText(severity.getDescription());
        this.writer.write("</span>");
        this.writer.write("<div class=\"summary\">\n");
        this.writer.write("Explanation: ");
        String description = issue.getBriefDescription(TextFormat.HTML);
        this.writer.write(description);
        if (!description.isEmpty() && Character.isLetter(description.charAt(description.length() - 1))) {
            this.writer.write(46);
        }
        this.writer.write("</div>\n");
        this.writer.write("<div class=\"explanation\">\n");
        String explanationHtml = issue.getExplanation(TextFormat.HTML);
        this.writer.write(explanationHtml);
        this.writer.write("\n</div>\n");
        List moreInfo = issue.getMoreInfo();
        this.writer.write("<br/>");
        this.writer.write("<div class=\"moreinfo\">");
        this.writer.write("More info: ");
        int count = moreInfo.size();
        if (count > 1) {
            this.writer.write("<ul>");
        }
        for (String uri : moreInfo) {
            if (count > 1) {
                this.writer.write("<li>");
            }
            this.writer.write("<a href=\"");
            this.writer.write(uri);
            this.writer.write("\">");
            this.writer.write(uri);
            this.writer.write("</a>\n");
        }
        if (count > 1) {
            this.writer.write("</ul>");
        }
        this.writer.write("</div>");
        this.writer.write("<br/>");
        this.writer.write(String.format("To suppress this error, use the issue id \"%1$s\" as explained in the %2$sSuppressing Warnings and Errors%3$s section.", issue.getId(), "<a href=\"#SuppressInfo\">", "</a>"));
        this.writer.write("<br/>\n");
    }

    private void writeSuppressInfo() throws IOException {
        this.writer.write("\n<a name=\"SuppressInfo\"></a>\n");
        this.writer.write("<div class=\"category\">");
        this.writer.write("Suppressing Warnings and Errors");
        this.writer.write("<div class=\"categorySeparator\"></div>\n");
        this.writer.write("</div>\n");
        this.writer.write(TextFormat.RAW.convertTo(Main.getSuppressHelp(), TextFormat.HTML));
        this.writer.write(10);
    }

    protected Map<Issue, String> computeMissingIssues(List<Warning> warnings) {
        HashSet<Project> projects = new HashSet<Project>();
        HashSet<Issue> seen = new HashSet<Issue>();
        for (Warning warning : warnings) {
            projects.add(warning.project);
            seen.add(warning.issue);
        }
        Configuration cliConfiguration = this.client.getConfiguration();
        HashMap map = Maps.newHashMap();
        block1: for (Issue issue : this.client.getRegistry().getIssues()) {
            if (seen.contains(issue)) continue;
            if (this.client.isSuppressed(issue)) {
                map.put(issue, "Command line flag");
                continue;
            }
            if (!issue.isEnabledByDefault() && !this.client.isAllEnabled()) {
                map.put(issue, "Default");
                continue;
            }
            if (cliConfiguration != null && !cliConfiguration.isEnabled(issue)) {
                map.put(issue, "Command line supplied --config lint.xml file");
                continue;
            }
            for (Project project : projects) {
                if (project.getConfiguration(null).isEnabled(issue)) continue;
                map.put(issue, "Project lint.xml file");
                continue block1;
            }
        }
        return map;
    }

    private void writeMissingIssues(Map<Issue, String> missing) throws IOException {
        this.writer.write("\n<a name=\"MissingIssues\"></a>\n");
        this.writer.write("<div class=\"category\">");
        this.writer.write("Disabled Checks");
        this.writer.write("<div class=\"categorySeparator\"></div>\n");
        this.writer.write("</div>\n");
        this.writer.write("The following issues were not run by lint, either because the check is not enabled by default, or because it was disabled with a command line flag or via one or more lint.xml configuration files in the project directories.");
        this.writer.write("\n<br/><br/>\n");
        ArrayList<Issue> list = new ArrayList<Issue>(missing.keySet());
        Collections.sort(list);
        for (Issue issue : list) {
            this.writer.write("<a name=\"" + issue.getId() + "\"></a>\n");
            this.writer.write("<div class=\"issue\">\n");
            this.writer.write("<div class=\"id\">");
            this.writer.write(issue.getId());
            this.writer.write("<div class=\"issueSeparator\"></div>\n");
            this.writer.write("</div>\n");
            String disabledBy = missing.get(issue);
            this.writeIssueMetadata(issue, issue.getDefaultSeverity(), disabledBy);
            this.writer.write("</div>\n");
        }
    }

    protected void writeStyleSheet() throws IOException {
        this.writer.write("<link rel=\"stylesheet\" type=\"text/css\" href=\"http://fonts.googleapis.com/css?family=Roboto\" />\n");
        URL cssUrl = HtmlReporter.class.getResource(CSS);
        if (this.simpleFormat || INLINE_RESOURCES) {
            this.writer.write("<style>\n");
            InputStream input = cssUrl.openStream();
            byte[] bytes = ByteStreams.toByteArray((InputStream)input);
            try {
                Closeables.close((Closeable)input, (boolean)true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String css = new String(bytes, Charsets.UTF_8);
            this.writer.write(css);
            this.writer.write("</style>\n");
        } else {
            String ref = this.addLocalResources(cssUrl);
            if (ref != null) {
                this.writer.write("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + ref + "\" />\n");
            }
        }
    }

    private void writeOverview(List<List<Warning>> related, int missingCount) throws IOException {
        this.writer.write("<table class=\"overview\">\n");
        String errorUrl = null;
        String warningUrl = null;
        if (!INLINE_RESOURCES && !this.simpleFormat) {
            errorUrl = this.addLocalResources(HtmlReporter.getErrorIconUrl());
            warningUrl = this.addLocalResources(HtmlReporter.getWarningIconUrl());
            this.fixUrl = this.addLocalResources(HtmlReporter.class.getResource("lint-run.png"));
        }
        Category previousCategory = null;
        for (List<Warning> warnings : related) {
            Issue issue = warnings.get((int)0).issue;
            boolean isError = false;
            for (Warning warning : warnings) {
                if (!warning.severity.isError()) continue;
                isError = true;
                break;
            }
            if (issue.getCategory() != previousCategory) {
                this.writer.write("<tr><td></td><td class=\"categoryColumn\">");
                previousCategory = issue.getCategory();
                String categoryName = issue.getCategory().getFullName();
                this.writer.write("<a href=\"#");
                this.writer.write(categoryName);
                this.writer.write("\">");
                this.writer.write(categoryName);
                this.writer.write("</a>\n");
                this.writer.write("</td></tr>");
                this.writer.write("\n");
            }
            this.writer.write("<tr>\n");
            this.writer.write("<td class=\"countColumn\">");
            this.writer.write(Integer.toString(warnings.size()));
            this.writer.write("</td>");
            this.writer.write("<td class=\"issueColumn\">");
            if (INLINE_RESOURCES) {
                String markup = isError ? HtmlReporter.getErrorIcon() : HtmlReporter.getWarningIcon();
                this.writer.write(markup);
                this.writer.write(10);
            } else {
                String imageUrl;
                String string = imageUrl = isError ? errorUrl : warningUrl;
                if (imageUrl != null) {
                    this.writer.write("<img border=\"0\" align=\"top\" src=\"");
                    this.writer.write(imageUrl);
                    this.writer.write("\" alt=\"");
                    this.writer.write(isError ? "Error" : "Warning");
                    this.writer.write("\" />\n");
                }
            }
            this.writer.write("<a href=\"#");
            this.writer.write(issue.getId());
            this.writer.write("\">");
            this.writer.write(issue.getId());
            this.writer.write(": ");
            this.writer.write(issue.getBriefDescription(TextFormat.HTML));
            this.writer.write("</a>\n");
            this.writer.write("</td></tr>\n");
        }
        if (missingCount > 0 && !this.client.isCheckingSpecificIssues()) {
            this.writer.write("<tr><td></td>");
            this.writer.write("<td class=\"categoryColumn\">");
            this.writer.write("<a href=\"#MissingIssues\">");
            this.writer.write(String.format("Disabled Checks (%1$d)", missingCount));
            this.writer.write("</a>\n");
            this.writer.write("</td></tr>");
        }
        this.writer.write("</table>\n");
        this.writer.write("<br/>");
    }

    private String writeLocation(File file, String path, int line) throws IOException {
        this.writer.write("<span class=\"location\">");
        String url = this.getUrl(file);
        if (url != null) {
            this.writer.write("<a href=\"");
            this.writer.write(url);
            this.writer.write("\">");
        }
        String displayPath = this.stripPath(path);
        if (url != null && url.startsWith("../") && new File(displayPath).isAbsolute()) {
            displayPath = url;
        }
        this.writer.write(displayPath);
        if (url != null) {
            this.writer.write("</a>");
        }
        if (line >= 0) {
            this.writer.write(58);
            this.writer.write(Integer.toString(line + 1));
        }
        this.writer.write("</span>");
        return url;
    }

    private boolean addImage(String url, Location location) throws IOException {
        if (url != null && LintUtils.endsWith((String)url, (String)".png")) {
            if (location.getSecondary() != null) {
                ArrayList<String> urls = new ArrayList<String>();
                while (location != null && location.getFile() != null) {
                    String imageUrl = this.getUrl(location.getFile());
                    if (imageUrl != null && LintUtils.endsWith((String)imageUrl, (String)".png")) {
                        urls.add(imageUrl);
                    }
                    location = location.getSecondary();
                }
                if (!urls.isEmpty()) {
                    Collections.sort(urls, (s1, s2) -> HtmlReporter.getDpiRank(s1) - HtmlReporter.getDpiRank(s2));
                    this.writer.write("<table>");
                    this.writer.write("<tr>");
                    for (String linkedUrl : urls) {
                        this.writer.write("<td>");
                        this.writer.write("<a href=\"");
                        this.writer.write(linkedUrl);
                        this.writer.write("\">");
                        this.writer.write("<img border=\"0\" align=\"top\" src=\"");
                        this.writer.write(linkedUrl);
                        this.writer.write("\" /></a>\n");
                        this.writer.write("</td>");
                    }
                    this.writer.write("</tr>");
                    this.writer.write("<tr>");
                    for (String linkedUrl : urls) {
                        int end;
                        this.writer.write("<th>");
                        int index = linkedUrl.lastIndexOf("drawable-");
                        if (index != -1 && (end = linkedUrl.indexOf(47, index += "drawable-".length())) != -1) {
                            this.writer.write(linkedUrl.substring(index, end));
                        }
                        this.writer.write("</th>");
                    }
                    this.writer.write("</tr>\n");
                    this.writer.write("</table>\n");
                }
            } else {
                this.writer.write("<img class=\"embedimage\" align=\"right\" src=\"");
                this.writer.write(url);
                this.writer.write("\" />");
            }
            return true;
        }
        return false;
    }

    private static int getDpiRank(String url) {
        if (url.contains("-xhdpi")) {
            return 0;
        }
        if (url.contains("-hdpi")) {
            return 1;
        }
        if (url.contains("-mdpi")) {
            return 2;
        }
        if (url.contains("-ldpi")) {
            return 3;
        }
        return 4;
    }

    private void appendCodeBlock(CharSequence contents, int lineno, int offset) throws IOException {
        int min;
        int max = lineno + 3;
        for (int l = min = lineno - 3; l < max; ++l) {
            if (l < 0) continue;
            int lineOffset = LintCliClient.getLineOffset(contents, l);
            if (lineOffset == -1) break;
            this.writer.write(String.format("<span class=\"lineno\">%1$4d</span> ", l + 1));
            String line = LintCliClient.getLineOfOffset(contents, lineOffset);
            if (offset != -1 && lineOffset <= offset && lineOffset + line.length() >= offset) {
                int delta = offset - lineOffset;
                this.appendEscapedText(line.substring(0, delta));
                this.writer.write("<span class=\"errorspan\">");
                this.appendEscapedText(line.substring(delta));
                this.writer.write("</span>");
            } else if (offset == -1 && l == lineno) {
                this.writer.write("<span class=\"errorline\">");
                this.appendEscapedText(line);
                this.writer.write("</span>");
            } else {
                this.appendEscapedText(line);
            }
            if (l >= max - 1) continue;
            this.writer.write("\n");
        }
    }

    @Override
    public void writeProjectList(Reporter.Stats stats, List<MultiProjectHtmlReporter.ProjectEntry> projects) throws IOException {
        String markup;
        this.writer.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>\n<title>" + this.title + "</title>\n");
        this.writeStyleSheet();
        this.writer.write("</head>\n<body>\n<h1>" + this.title + "</h1>\n<div class=\"titleSeparator\"></div>\n");
        this.writer.write(String.format("Check performed at %1$s.", new Date().toString()));
        this.writer.write("<br/>\n");
        this.appendEscapedText(String.format("%1$s found", LintUtils.describeCounts((int)stats.errorCount, (int)stats.warningCount, (boolean)false, (boolean)true)));
        if (stats.baselineErrorCount > 0 || stats.baselineWarningCount > 0) {
            File baselineFile = this.flags.getBaselineFile();
            assert (baselineFile != null);
            this.appendEscapedText(String.format(" (%1$ss filtered by baseline %2$s)", LintUtils.describeCounts((int)stats.baselineErrorCount, (int)stats.baselineWarningCount, (boolean)false, (boolean)true), baselineFile.getName()));
        }
        this.writer.write(":\n<br/><br/>\n");
        if (stats.errorCount == 0 && stats.warningCount == 0) {
            this.writer.write("Congratulations!");
            return;
        }
        String errorUrl = null;
        String warningUrl = null;
        if (!INLINE_RESOURCES && !this.simpleFormat) {
            errorUrl = this.addLocalResources(HtmlReporter.getErrorIconUrl());
            warningUrl = this.addLocalResources(HtmlReporter.getWarningIconUrl());
        }
        this.writer.write("<table class=\"overview\">\n");
        this.writer.write("<tr><th>");
        this.writer.write("Project");
        this.writer.write("</th><th class=\"countColumn\">");
        if (INLINE_RESOURCES) {
            markup = HtmlReporter.getErrorIcon();
            this.writer.write(markup);
            this.writer.write(10);
        } else if (errorUrl != null) {
            this.writer.write("<img border=\"0\" align=\"top\" src=\"");
            this.writer.write(errorUrl);
            this.writer.write("\" alt=\"Error\" />\n");
        }
        this.writer.write("Errors");
        this.writer.write("</th><th class=\"countColumn\">");
        if (INLINE_RESOURCES) {
            markup = HtmlReporter.getWarningIcon();
            this.writer.write(markup);
            this.writer.write(10);
        } else if (warningUrl != null) {
            this.writer.write("<img border=\"0\" align=\"top\" src=\"");
            this.writer.write(warningUrl);
            this.writer.write("\" alt=\"Warning\" />\n");
        }
        this.writer.write("Warnings");
        this.writer.write("</th></tr>\n");
        for (MultiProjectHtmlReporter.ProjectEntry entry : projects) {
            this.writer.write("<tr><td>");
            this.writer.write("<a href=\"");
            this.appendEscapedText(entry.fileName);
            this.writer.write("\">");
            this.writer.write(entry.path);
            this.writer.write("</a></td><td class=\"countColumn\">");
            this.writer.write(Integer.toString(entry.errorCount));
            this.writer.write("</td><td class=\"countColumn\">");
            this.writer.write(Integer.toString(entry.warningCount));
            this.writer.write("</td></tr>\n");
        }
        this.writer.write("</table>\n");
        this.writer.write("</body>\n</html>\n");
    }

    protected void appendEscapedText(String textValue) throws IOException {
        int n = textValue.length();
        for (int i = 0; i < n; ++i) {
            char c = textValue.charAt(i);
            if (c == '<') {
                this.writer.write("&lt;");
                continue;
            }
            if (c == '&') {
                this.writer.write("&amp;");
                continue;
            }
            if (c == '\n') {
                this.writer.write("<br/>\n");
                continue;
            }
            if (c > '\u00ff') {
                this.writer.write("&#");
                this.writer.write(Integer.toString(c));
                this.writer.write(59);
                continue;
            }
            this.writer.write(c);
        }
    }

    static URL getWarningIconUrl() {
        return HtmlReporter.class.getResource("lint-warning.png");
    }

    static URL getErrorIconUrl() {
        return HtmlReporter.class.getResource("lint-error.png");
    }

    static String getErrorIcon() {
        return "<img border=\"0\" align=\"top\" width=\"15\" height=\"15\" alt=\"Error\" src=\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA8AAAAPCAYAAAA71pVKAAAB00lEQVR42nWTS0hbQRiF587MzkUXooi6UHAjhNKNSkGhCDXxkZhUIwWhBLoRsQpi3bXmIboSV2aliI+WKqLUtqsuSxclrhRBUMnVmIpa2oIkQon+zhlr9F7jwOEw/znfLO6dYcy2Arys6AUv6x7klTNh4ViFY485u2+N8Uc8yB1DH0Vt6ki2UkZ20LkS/Eh6CXPk6FnAKVHNJ3nViind9E/6tTKto3TxaU379Qw5euhn4QXxOGzKFjqT7Vmlwx8IC357jh76GvzC64pj4mn6VLbRbf0Nvdcw3J6hr7gS9o3XDxwIN/0RPot+h95pGG7P0AfH1oVz6UR4ya5foXkNw3Pl4Ngub/p6yD1k13FoTsPwXDk4ti89SwnuJrtigYiGY4FhypWDY2aeb0CJ4rzZou9GPc0Y1drtGfrgWLzweUm8uPNsx2ikrHgjHT6LUOrzD/rpDpIlU0JfcaX6d8UfdoW38/20ZbiuxF10MHL1tRNvp2/mSuihn70kZl2/MJ+8Xtkq8NOm4VRqoIUKLy0Hx2mx3PN/5iTk6KFvuaJmyxux3zE8tFPTm9p84KMNdcAGa9COvZqnkaN37wNJvpooSvZFexIvx2b3OkdX4dgne6N3XtUl5wqoyBY2uZQAAAAASUVORK5CYII=\" />";
    }

    static String getWarningIcon() {
        return "<img border=\"0\" align=\"top\" width=\"16\" height=\"15\" alt=\"Warning\" src=\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAPCAQAAABHeoekAAAA3klEQVR42nWPsWoCQRCGVyJiF9tAsNImbcDKR/ABBEurYCsBsfQRQiAPYGPyAAnYWQULS9MErNU2Vsr/ObMX7g6O+xd2/5n5dmY3hFQEBVVpuCsVT/yoUl6u4XotBz4E4qR2YYyH6ugEWY8comR/t+tvPPJtSLPYvhvvTswtbdCmCOwjMHXAzjP9kB/ByB7nejbgy43WVPF3WNG+p9+kzkozdhGAQdZh7BlHdGTL3z98pp6Um7okKdvHNuIzWk+9xN+yINOcHps0OnAfuOOoHJH3pmHghhYP2VJcaXx7BaKz9YB2HVrDAAAAAElFTkSuQmCC\"/>";
    }

    static String getFixIcon() {
        return "<img border=\"0\" align=\"top\" width=\"16\" height=\"16\" alt=\"Fix\" src=\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAA1ElEQVR42s2Szw7BQBCH+wTezAM4u7h7BBKEa3v1AK7iKvoAuDg5uSoaqTR2u90xs9P1J2FLHNjky29mu/Nt09Tz/mb1gxF8wlPBKoG3cAoiCbAVTCQe69bcN8+dgp1k9oTgpL4+bYIXVKCNEqfgIJk4w0RirGmIhklCe07BeBPCEQ9ZOsUwpd17KRiuQ3O4u/DhpMDkfU8kquQNesVQdVIzSX2KQ2l+wykQeKAx4w9GSf05532LU5BpZrD0rzUhLVAiwAtAaYbqXDPKpkvw1a/8s3UBSc/bWGUWa6wAAAAASUVORK5CYII=\"/>";
    }
}

