/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.Dependencies;
import com.android.builder.model.Variant;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Project;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.BaseExternalAnnotationsManager;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class LintExternalAnnotationsManager
extends BaseExternalAnnotationsManager {
    private final List<VirtualFile> roots = Lists.newArrayList();

    public LintExternalAnnotationsManager(com.intellij.openapi.project.Project project, PsiManager psiManager) {
        super(psiManager);
    }

    protected boolean hasAnyAnnotationsRoots() {
        return !this.roots.isEmpty();
    }

    protected List<VirtualFile> getExternalAnnotationsRoots(VirtualFile virtualFile) {
        return this.roots;
    }

    public void updateAnnotationRoots(LintClient client) {
        String path;
        Collection projects = client.getKnownProjects();
        if (Project.isAospBuildEnvironment()) {
            for (Project project : projects) {
                if (!Project.isAospFrameworksProject((File)project.getDir())) continue;
                return;
            }
        }
        HashSet seen = Sets.newHashSet();
        ArrayList files = Lists.newArrayListWithExpectedSize((int)2);
        for (Project project : projects) {
            if (!project.isGradleProject()) continue;
            Variant variant = project.getCurrentVariant();
            AndroidProject model = project.getGradleProjectModel();
            if (model == null || variant == null) continue;
            Dependencies dependencies = variant.getMainArtifact().getDependencies();
            for (AndroidLibrary library : dependencies.getLibraries()) {
                LintExternalAnnotationsManager.addLibraries(files, library, seen);
            }
        }
        File sdkAnnotations = client.findResource("annotations.zip");
        if (sdkAnnotations == null && (path = System.getenv("SDK_ANNOTATIONS")) != null && !(sdkAnnotations = new File(path)).exists()) {
            sdkAnnotations = null;
        }
        if (sdkAnnotations != null) {
            files.add(sdkAnnotations);
        }
        ArrayList newRoots = Lists.newArrayListWithCapacity((int)files.size());
        VirtualFileSystem local = StandardFileSystems.local();
        VirtualFileSystem jar = StandardFileSystems.jar();
        for (File file : files) {
            boolean isZip = file.getName().equals("annotations.zip");
            VirtualFile virtualFile = isZip ? jar.findFileByPath(file.getPath() + "!/") : local.findFileByPath(file.getPath());
            if (virtualFile == null && (virtualFile = isZip ? jar.findFileByPath(file.getAbsolutePath() + "!/") : local.findFileByPath(file.getAbsolutePath())) == null) {
                System.out.println("WTF?");
            }
            if (virtualFile == null) continue;
            newRoots.add(virtualFile);
        }
        if (this.roots.containsAll(newRoots)) {
            return;
        }
        this.roots.addAll(newRoots);
        this.dropCache();
        ((PsiModificationTrackerImpl)this.myPsiManager.getModificationTracker()).incCounter();
    }

    private static void addLibraries(List<File> result, AndroidLibrary library, Set<AndroidLibrary> seen) {
        block5: {
            if (seen.contains(library)) {
                return;
            }
            seen.add(library);
            try {
                File zip = library.getExternalAnnotations();
                if (zip.exists()) {
                    result.add(zip);
                }
            }
            catch (Throwable ignore) {
                File zip = new File(library.getResFolder().getParent(), "annotations.zip");
                if (!zip.exists()) break block5;
                result.add(zip);
            }
        }
        for (AndroidLibrary dependency : library.getLibraryDependencies()) {
            LintExternalAnnotationsManager.addLibraries(result, dependency, seen);
        }
    }
}

