/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.Reporter;
import com.android.tools.lint.Warning;
import com.android.tools.lint.checks.BuiltinIssueRegistry;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.annotations.Beta;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0010H\u0003J\u001e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0017J(\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0003J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u0016H\u0002J\u0016\u0010\u001d\u001a\u00020\u000f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/lint/XmlReporter;", "Lcom/android/tools/lint/Reporter;", "client", "Lcom/android/tools/lint/LintCliClient;", "output", "Ljava/io/File;", "(Lcom/android/tools/lint/LintCliClient;Ljava/io/File;)V", "isIntendedForBaseline", "", "()Z", "setIntendedForBaseline", "(Z)V", "writer", "Ljava/io/Writer;", "indent", "", "", "write", "stats", "Lcom/android/tools/lint/Reporter$Stats;", "issues", "", "Lcom/android/tools/lint/Warning;", "writeAttribute", "name", "", "value", "writeIssue", "warning", "writeIssues", "lint_main"})
@Beta
public final class XmlReporter
extends Reporter {
    private final Writer writer;
    private boolean isIntendedForBaseline;

    public final boolean isIntendedForBaseline() {
        return this.isIntendedForBaseline;
    }

    public final void setIntendedForBaseline(boolean bl) {
        this.isIntendedForBaseline = bl;
    }

    public void write(@NotNull Reporter.Stats stats, @NotNull List<? extends Warning> issues) throws IOException {
        Object object;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)stats, (String)"stats");
        Intrinsics.checkParameterIsNotNull(issues, (String)"issues");
        this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.writer.write("<issues format=\"4\"");
        String revision = this.client.getClientRevision();
        if (revision != null) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            string = " by=\"lint %1$s\"";
            object = new Object[]{revision};
            Writer writer = this.writer;
            String string2 = String.format(string, Arrays.copyOf(object, ((Object[])object).length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String string3 = string2;
            writer.write(string3);
        }
        this.writer.write(">\n");
        if (!issues.isEmpty()) {
            this.writeIssues(issues);
        }
        this.writer.write("\n</issues>\n");
        this.writer.close();
        if (!(this.client.getFlags().isQuiet() || stats.errorCount <= 0 && stats.warningCount <= 0)) {
            String url = SdkUtils.fileToUrlString((File)this.output.getAbsoluteFile());
            string = StringCompanionObject.INSTANCE;
            object = "Wrote XML report to %1$s";
            Object[] objectArray = new Object[]{url};
            String string4 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(format, *args)");
            string = string4;
            System.out.println((Object)string);
        }
    }

    private final void writeIssues(List<? extends Warning> issues) {
        for (Warning warning : issues) {
            this.writeIssue(warning);
        }
    }

    private final void writeIssue(Warning warning) {
        Location location;
        int index2;
        String line;
        int index12;
        Object moreInfo;
        this.writer.write(10);
        this.indent(this.writer, 1);
        this.writer.write("<issue");
        Issue issue = warning.issue;
        String string = issue.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"issue.id");
        this.writeAttribute(this.writer, 2, "id", string);
        if (!this.isIntendedForBaseline) {
            this.writeAttribute(this.writer, 2, "severity", warning.severity.getDescription());
        }
        String string2 = warning.message;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"warning.message");
        this.writeAttribute(this.writer, 2, "message", string2);
        if (!this.isIntendedForBaseline) {
            this.writeAttribute(this.writer, 2, "category", issue.getCategory().getFullName());
            String string3 = Integer.toString(issue.getPriority());
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"Integer.toString(issue.priority)");
            this.writeAttribute(this.writer, 2, "priority", string3);
            String string4 = issue.getBriefDescription(TextFormat.RAW);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"issue.getBriefDescription(RAW)");
            this.writeAttribute(this.writer, 2, "summary", string4);
            String string5 = issue.getExplanation(TextFormat.RAW);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"issue.getExplanation(RAW)");
            this.writeAttribute(this.writer, 2, "explanation", string5);
            moreInfo = issue.getMoreInfo();
            if (!moreInfo.isEmpty()) {
                Object e = moreInfo.get(0);
                Intrinsics.checkExpressionValueIsNotNull(e, (String)"moreInfo[0]");
                this.writeAttribute(this.writer, 2, "url", (String)e);
                String string6 = Joiner.on((char)',').join((Iterable)issue.getMoreInfo());
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"Joiner.on(',').join(issue.moreInfo)");
                this.writeAttribute(this.writer, 2, "urls", string6);
            }
        }
        if (warning.errorLine != null && !((moreInfo = (CharSequence)warning.errorLine).length() == 0) && (index12 = StringsKt.indexOf$default((CharSequence)(line = warning.errorLine), (char)'\n', (int)0, (boolean)false, (int)6, null)) != -1 && (index2 = StringsKt.indexOf$default((CharSequence)line, (char)'\n', (int)(index12 + 1), (boolean)false, (int)4, null)) != -1) {
            String string7 = line;
            int n = 0;
            String string8 = string7;
            if (string8 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string9 = string8.substring(n, index12);
            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String line1 = string9;
            String string10 = line;
            int n2 = index12 + 1;
            String string11 = string10;
            if (string11 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string12 = string11.substring(n2, index2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string12, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String line2 = string12;
            this.writeAttribute(this.writer, 2, "errorLine1", line1);
            this.writeAttribute(this.writer, 2, "errorLine2", line2);
        }
        if (warning.isVariantSpecific()) {
            String string13 = Joiner.on((char)',').join((Iterable)warning.getIncludedVariantNames());
            Intrinsics.checkExpressionValueIsNotNull((Object)string13, (String)"Joiner.on(',').join(warning.includedVariantNames)");
            this.writeAttribute(this.writer, 2, "includedVariants", string13);
            String string14 = Joiner.on((char)',').join((Iterable)warning.getExcludedVariantNames());
            Intrinsics.checkExpressionValueIsNotNull((Object)string14, (String)"Joiner.on(',').join(warning.excludedVariantNames)");
            this.writeAttribute(this.writer, 2, "excludedVariants", string14);
        }
        if (!this.isIntendedForBaseline && this.client.getRegistry() instanceof BuiltinIssueRegistry && Reporter.hasAutoFix(issue)) {
            this.writeAttribute(this.writer, 2, "quickfix", "studio");
        }
        boolean bl = line = warning.file != null == (warning.location != null);
        if (_Assertions.ENABLED && !line) {
            String index12 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)index12));
        }
        if (warning.file != null) {
            boolean bl2 = line = warning.location.getFile() == warning.file;
            if (_Assertions.ENABLED && !line) {
                String index12 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)index12));
            }
        }
        if ((location = warning.location) != null) {
            this.writer.write(">\n");
            while (location != null) {
                String path;
                this.indent(this.writer, 2);
                this.writer.write("<location");
                String string15 = path = LintCliClient.getDisplayPath(warning.project, location.getFile(), this.client.flags.isFullPath() && !this.isIntendedForBaseline);
                Intrinsics.checkExpressionValueIsNotNull((Object)string15, (String)"path");
                this.writeAttribute(this.writer, 3, "file", string15);
                Position start = location.getStart();
                if (start != null) {
                    int line2 = start.getLine();
                    int column = start.getColumn();
                    if (line2 >= 0) {
                        String string16 = Integer.toString(line2 + 1);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string16, (String)"Integer.toString(line + 1)");
                        this.writeAttribute(this.writer, 3, "line", string16);
                        if (column >= 0) {
                            String string17 = Integer.toString(column + 1);
                            Intrinsics.checkExpressionValueIsNotNull((Object)string17, (String)"Integer.toString(column + 1)");
                            this.writeAttribute(this.writer, 3, "column", string17);
                        }
                    }
                }
                this.writer.write("/>\n");
                location = location.getSecondary();
            }
            this.indent(this.writer, 1);
            this.writer.write("</issue>\n");
        } else {
            this.writer.write(10);
            this.indent(this.writer, 1);
            this.writer.write("/>\n");
        }
    }

    private final void writeAttribute(Writer writer, int indent, String name, String value) throws IOException {
        writer.write(10);
        this.indent(writer, indent);
        writer.write(name);
        writer.write(61);
        writer.write(34);
        writer.write(XmlUtils.toXmlAttributeValue((String)value));
        writer.write(34);
    }

    /*
     * WARNING - void declaration
     */
    private final void indent(Writer writer, int indent) throws IOException {
        int n;
        IntRange intRange = RangesKt.until((int)0, (int)indent);
        int n2 = intRange.getFirst();
        if (n2 <= (n = intRange.getLast())) {
            while (true) {
                void level;
                writer.write("    ");
                if (level == n) break;
                ++level;
            }
        }
    }

    public XmlReporter(@NotNull LintCliClient client, @NotNull File output) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)((Object)client), (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        super(client, output);
        this.writer = new BufferedWriter(Files.newWriter((File)output, (Charset)Charsets.UTF_8));
    }
}

