/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.drawing;

import com.glavsoft.drawing.ColorDecoder;
import com.glavsoft.drawing.SoftCursor;
import com.glavsoft.exceptions.TransportException;
import com.glavsoft.rfb.encoding.PixelFormat;
import com.glavsoft.rfb.encoding.decoder.FramebufferUpdateRectangle;
import com.glavsoft.transport.Transport;
import java.util.Arrays;
import java.util.concurrent.locks.ReentrantLock;

public abstract class Renderer {
    protected final ReentrantLock lock = new ReentrantLock();
    protected int width;
    protected int height;
    protected int[] pixels;
    protected SoftCursor cursor;
    protected ColorDecoder colorDecoder;

    public abstract void drawJpegImage(byte[] var1, int var2, int var3, FramebufferUpdateRectangle var4);

    protected void init(int width, int height, PixelFormat pixelFormat) {
        this.width = width;
        this.height = height;
        this.initColorDecoder(pixelFormat);
        this.pixels = new int[width * height];
        Arrays.fill(this.pixels, 0);
    }

    public void initColorDecoder(PixelFormat pixelFormat) {
        this.lock.lock();
        this.colorDecoder = new ColorDecoder(pixelFormat);
        this.lock.unlock();
    }

    public void drawBytes(byte[] bytes, int x, int y, int width, int height) {
        int i = 0;
        for (int ly = y; ly < y + height; ++ly) {
            int end = ly * this.width + x + width;
            for (int pixelsOffset = ly * this.width + x; pixelsOffset < end; ++pixelsOffset) {
                this.pixels[pixelsOffset] = this.getPixelColor(bytes, i);
                i += this.colorDecoder.bytesPerPixel;
            }
        }
    }

    public int drawCompactBytes(byte[] bytes, int offset, int x, int y, int width, int height) {
        int i = offset;
        this.lock.lock();
        for (int ly = y; ly < y + height; ++ly) {
            int end = ly * this.width + x + width;
            for (int pixelsOffset = ly * this.width + x; pixelsOffset < end; ++pixelsOffset) {
                this.pixels[pixelsOffset] = this.getCompactPixelColor(bytes, i);
                i += this.colorDecoder.bytesPerCPixel;
            }
        }
        this.lock.unlock();
        return i - offset;
    }

    public void drawColoredBitmap(int[] colors, int x, int y, int width, int height) {
        int i = 0;
        this.lock.lock();
        for (int ly = y; ly < y + height; ++ly) {
            int end = ly * this.width + x + width;
            for (int pixelsOffset = ly * this.width + x; pixelsOffset < end; ++pixelsOffset) {
                this.pixels[pixelsOffset] = colors[i++];
            }
        }
        this.lock.unlock();
    }

    public int drawTightBytes(byte[] bytes, int offset, int x, int y, int width, int height) {
        int i = offset;
        this.lock.lock();
        for (int ly = y; ly < y + height; ++ly) {
            int end = ly * this.width + x + width;
            for (int pixelsOffset = ly * this.width + x; pixelsOffset < end; ++pixelsOffset) {
                this.pixels[pixelsOffset] = this.colorDecoder.getTightColor(bytes, i);
                i += this.colorDecoder.bytesPerPixelTight;
            }
        }
        this.lock.unlock();
        return i - offset;
    }

    public void drawUncaliberedRGBLine(byte[] bytes, int x, int y, int width) {
        int end = y * this.width + x + width;
        this.lock.lock();
        int i = 3;
        for (int pixelsOffset = y * this.width + x; pixelsOffset < end; ++pixelsOffset) {
            this.pixels[pixelsOffset] = (0xFF & 255 * (this.colorDecoder.redMax & bytes[i++]) / this.colorDecoder.redMax) << 16 | (0xFF & 255 * (this.colorDecoder.greenMax & bytes[i++]) / this.colorDecoder.greenMax) << 8 | 0xFF & 255 * (this.colorDecoder.blueMax & bytes[i++]) / this.colorDecoder.blueMax;
        }
        this.lock.unlock();
    }

    public void drawBytesWithPalette(byte[] buffer, FramebufferUpdateRectangle rect, int[] palette, int paletteSize) {
        this.lock.lock();
        if (2 == paletteSize) {
            int i = rect.y * this.width + rect.x;
            int rowBytes = (rect.width + 7) / 8;
            for (int dy = 0; dy < rect.height; ++dy) {
                int n;
                int dx;
                for (dx = 0; dx < rect.width / 8; ++dx) {
                    byte b = buffer[dy * rowBytes + dx];
                    for (n = 7; n >= 0; --n) {
                        this.pixels[i++] = palette[b >> n & 1];
                    }
                }
                for (n = 7; n >= 8 - rect.width % 8; --n) {
                    this.pixels[i++] = palette[buffer[dy * rowBytes + dx] >> n & 1];
                }
                i += this.width - rect.width;
            }
        } else {
            int i = 0;
            for (int ly = rect.y; ly < rect.y + rect.height; ++ly) {
                for (int lx = rect.x; lx < rect.x + rect.width; ++lx) {
                    int pixelsOffset = ly * this.width + lx;
                    this.pixels[pixelsOffset] = palette[buffer[i++] & 0xFF];
                }
            }
        }
        this.lock.unlock();
    }

    public void copyRect(int srcX, int srcY, FramebufferUpdateRectangle dstRect) {
        int deltaY;
        int dstY;
        int endSrcY;
        int startSrcY;
        if (srcY > dstRect.y) {
            startSrcY = srcY;
            endSrcY = srcY + dstRect.height;
            dstY = dstRect.y;
            deltaY = 1;
        } else {
            startSrcY = srcY + dstRect.height - 1;
            endSrcY = srcY - 1;
            dstY = dstRect.y + dstRect.height - 1;
            deltaY = -1;
        }
        this.lock.lock();
        for (int y = startSrcY; y != endSrcY; y += deltaY) {
            System.arraycopy(this.pixels, y * this.width + srcX, this.pixels, dstY * this.width + dstRect.x, dstRect.width);
            dstY += deltaY;
        }
        this.lock.unlock();
    }

    public void fillRect(int color, FramebufferUpdateRectangle rect) {
        this.fillRect(color, rect.x, rect.y, rect.width, rect.height);
    }

    public void fillRect(int color, int x, int y, int width, int height) {
        this.lock.lock();
        int sy = y * this.width + x;
        int ey = sy + height * this.width;
        for (int i = sy; i < ey; i += this.width) {
            Arrays.fill(this.pixels, i, i + width, color);
        }
        this.lock.unlock();
    }

    public int readPixelColor(Transport transport) throws TransportException {
        return this.colorDecoder.readColor(transport);
    }

    public int readTightPixelColor(Transport transport) throws TransportException {
        return this.colorDecoder.readTightColor(transport);
    }

    public ColorDecoder getColorDecoder() {
        return this.colorDecoder;
    }

    public int getCompactPixelColor(byte[] bytes, int offset) {
        return this.colorDecoder.getCompactColor(bytes, offset);
    }

    public int getPixelColor(byte[] bytes, int offset) {
        return this.colorDecoder.getColor(bytes, offset);
    }

    public int getBytesPerPixel() {
        return this.colorDecoder.bytesPerPixel;
    }

    public int getBytesPerCPixel() {
        return this.colorDecoder.bytesPerCPixel;
    }

    public int getBytesPerPixelTight() {
        return this.colorDecoder.bytesPerPixelTight;
    }

    public void fillColorBitmapWithColor(int[] bitmapData, int decodedOffset, int rlength, int color) {
        while (rlength-- > 0) {
            bitmapData[decodedOffset++] = color;
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createCursor(int[] cursorPixels, FramebufferUpdateRectangle rect) throws TransportException {
        Object object = this.cursor.getLock();
        synchronized (object) {
            this.cursor.createCursor(cursorPixels, rect.x, rect.y, rect.width, rect.height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decodeCursorPosition(FramebufferUpdateRectangle rect) {
        Object object = this.cursor.getLock();
        synchronized (object) {
            this.cursor.updatePosition(rect.x, rect.y);
        }
    }
}

