/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.rfb.encoding.decoder;

import com.glavsoft.drawing.Renderer;
import com.glavsoft.exceptions.TransportException;
import com.glavsoft.rfb.encoding.decoder.ByteBuffer;
import com.glavsoft.rfb.encoding.decoder.Decoder;
import com.glavsoft.rfb.encoding.decoder.FramebufferUpdateRectangle;
import com.glavsoft.transport.Transport;

public class RawDecoder
extends Decoder {
    private static RawDecoder instance = new RawDecoder();

    public static RawDecoder getInstance() {
        return instance;
    }

    private RawDecoder() {
    }

    @Override
    public void decode(Transport transport, Renderer renderer, FramebufferUpdateRectangle rect) throws TransportException {
        this.decode(transport, renderer, rect.x, rect.y, rect.width, rect.height);
    }

    public void decode(Transport transport, Renderer renderer, int x, int y, int width, int height) throws TransportException {
        int length = width * height * renderer.getBytesPerPixel();
        byte[] bytes = ByteBuffer.getInstance().getBuffer(length);
        transport.readBytes(bytes, 0, length);
        renderer.drawBytes(bytes, x, y, width, height);
    }
}

