/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.transport;

public class BaudrateMeter {
    public static final int MIN_BPS = 10000;
    private static final int n = 5;
    private static final double ALPHA = 0.3333333333333333;
    private double ema = 0.0;
    private boolean measure = false;
    private long start;
    private long bytes;

    public void count(int bytes) {
        if (this.measure) {
            this.bytes += (long)bytes;
        }
    }

    public int kBPS() {
        return (int)(this.ema / 1000.0);
    }

    public void startMeasuringCycle() {
        this.measure = true;
        this.start = System.currentTimeMillis();
    }

    public void stopMeasuringCycle() {
        this.measure = false;
        long ms = System.currentTimeMillis() - this.start;
        if (0L == ms || this.bytes < 100L) {
            return;
        }
        double bps = (double)this.bytes * 8.0 / ((double)ms / 1000.0);
        if (bps < 10000.0) {
            bps = 10000.0;
        }
        this.ema = 0.3333333333333333 * bps + 0.6666666666666667 * (0.0 == this.ema ? bps : this.ema);
        this.bytes = 0L;
    }
}

