/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.transport;

import com.glavsoft.exceptions.ClosedConnectionException;
import com.glavsoft.exceptions.TransportException;
import com.glavsoft.transport.BaudrateMeter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.nio.charset.Charset;

public class Transport {
    public static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    public static final Charset UTF8 = Charset.forName("UTF-8");
    DataInputStream is;
    DataOutputStream os;
    InputStream origIs;
    OutputStream origOs;
    private BaudrateMeter baudrateMeter;

    public Transport(Socket socket) throws IOException {
        this(socket.getInputStream(), socket.getOutputStream());
    }

    public Transport(InputStream is) {
        this(is, null);
    }

    public Transport(OutputStream os) {
        this(null, os);
    }

    public Transport(InputStream is, OutputStream os) {
        this.init(is, os);
    }

    void init(InputStream is, OutputStream os) {
        this.origIs = is;
        this.is = is != null ? new DataInputStream(is) : null;
        this.origOs = os;
        this.os = os != null ? new DataOutputStream(os) : null;
    }

    public Transport() {
        this(null, null);
    }

    void release() {
        this.is = null;
        this.origIs = null;
        this.os = null;
        this.origOs = null;
    }

    public byte readByte() throws TransportException {
        try {
            if (this.baudrateMeter != null) {
                this.baudrateMeter.count(1);
            }
            return this.is.readByte();
        }
        catch (EOFException e) {
            throw new ClosedConnectionException(e);
        }
        catch (IOException e) {
            throw new TransportException("Cannot read byte", e);
        }
    }

    public void setBaudrateMeter(BaudrateMeter baudrateMeter) {
        this.baudrateMeter = baudrateMeter;
    }

    public int readUInt8() throws TransportException {
        return this.readByte() & 0xFF;
    }

    public int readUInt16() throws TransportException {
        return this.readInt16() & 0xFFFF;
    }

    public short readInt16() throws TransportException {
        try {
            if (this.baudrateMeter != null) {
                this.baudrateMeter.count(2);
            }
            return this.is.readShort();
        }
        catch (EOFException e) {
            throw new ClosedConnectionException(e);
        }
        catch (IOException e) {
            throw new TransportException("Cannot read int16", e);
        }
    }

    public long readUInt32() throws TransportException {
        return (long)this.readInt32() & 0xFFFFFFFFL;
    }

    public int readInt32() throws TransportException {
        try {
            if (this.baudrateMeter != null) {
                this.baudrateMeter.count(4);
            }
            return this.is.readInt();
        }
        catch (EOFException e) {
            throw new ClosedConnectionException(e);
        }
        catch (IOException e) {
            throw new TransportException("Cannot read int32", e);
        }
    }

    public long readInt64() throws TransportException {
        try {
            if (this.baudrateMeter != null) {
                this.baudrateMeter.count(8);
            }
            return this.is.readLong();
        }
        catch (EOFException e) {
            throw new ClosedConnectionException(e);
        }
        catch (IOException e) {
            throw new TransportException("Cannot read int32", e);
        }
    }

    public String readString(int length) throws TransportException {
        return this.stringWithBytesAndCharset(this.readBytes(length));
    }

    public String readString() throws TransportException {
        int length = this.readInt32() & Integer.MAX_VALUE;
        return this.readString(length);
    }

    public String readUtf8String() throws TransportException {
        int length = this.readInt32() & Integer.MAX_VALUE;
        return new String(this.readBytes(length), UTF8);
    }

    public byte[] readBytes(int length) throws TransportException {
        byte[] b = new byte[length];
        return this.readBytes(b, 0, length);
    }

    public byte[] readBytes(byte[] b, int offset, int length) throws TransportException {
        try {
            this.is.readFully(b, offset, length);
            if (this.baudrateMeter != null) {
                this.baudrateMeter.count(length);
            }
            return b;
        }
        catch (EOFException e) {
            throw new ClosedConnectionException(e);
        }
        catch (IOException e) {
            throw new TransportException(new StringBuilder(35).append("Cannot read ").append(length).append(" bytes array").toString(), e);
        }
    }

    public void skip(int length) throws TransportException {
        try {
            int rest = length;
            while ((rest -= this.is.skipBytes(rest)) > 0) {
            }
            if (this.baudrateMeter != null) {
                this.baudrateMeter.count(length);
            }
        }
        catch (EOFException e) {
            throw new ClosedConnectionException(e);
        }
        catch (IOException e) {
            throw new TransportException(new StringBuilder(29).append("Cannot skip ").append(length).append(" bytes").toString(), e);
        }
    }

    private void checkForOutputInit() throws TransportException {
        if (null == this.os) {
            throw new TransportException("Uninitialized writer");
        }
    }

    public Transport flush() throws TransportException {
        this.checkForOutputInit();
        try {
            this.os.flush();
        }
        catch (IOException e) {
            throw new TransportException("Cannot flush output stream", e);
        }
        return this;
    }

    public Transport writeByte(int b) throws TransportException {
        return this.write((byte)(b & 0xFF));
    }

    public Transport write(byte b) throws TransportException {
        this.checkForOutputInit();
        try {
            this.os.writeByte(b);
        }
        catch (IOException e) {
            throw new TransportException("Cannot write byte", e);
        }
        return this;
    }

    public Transport writeInt16(int sh) throws TransportException {
        return this.write((short)(sh & 0xFFFF));
    }

    public Transport write(short sh) throws TransportException {
        this.checkForOutputInit();
        try {
            this.os.writeShort(sh);
        }
        catch (IOException e) {
            throw new TransportException("Cannot write short", e);
        }
        return this;
    }

    public Transport writeInt32(int i) throws TransportException {
        return this.write(i);
    }

    public Transport writeInt64(long i) throws TransportException {
        this.checkForOutputInit();
        try {
            this.os.writeLong(i);
        }
        catch (IOException e) {
            throw new TransportException("Cannot write long", e);
        }
        return this;
    }

    public Transport write(int i) throws TransportException {
        this.checkForOutputInit();
        try {
            this.os.writeInt(i);
        }
        catch (IOException e) {
            throw new TransportException("Cannot write int", e);
        }
        return this;
    }

    public Transport write(byte[] b) throws TransportException {
        return this.write(b, 0, b.length);
    }

    public Transport write(byte[] b, int length) throws TransportException {
        return this.write(b, 0, length);
    }

    public Transport write(byte[] b, int offset, int length) throws TransportException {
        this.checkForOutputInit();
        try {
            this.os.write(b, offset, length <= b.length ? length : b.length);
        }
        catch (IOException e) {
            throw new TransportException(new StringBuilder(30).append("Cannot write ").append(length).append(" bytes").toString(), e);
        }
        return this;
    }

    public void setOutputStreamTo(OutputStream os) {
        this.os = new DataOutputStream(os);
    }

    public Transport zero(int count) throws TransportException {
        while (count-- > 0) {
            this.writeByte(0);
        }
        return this;
    }

    private String stringWithBytesAndCharset(byte[] bytes) {
        String result;
        try {
            result = new String(bytes, ISO_8859_1);
        }
        catch (NoSuchMethodError error) {
            try {
                result = new String(bytes, ISO_8859_1.name());
            }
            catch (UnsupportedEncodingException e) {
                result = null;
            }
        }
        return result;
    }
}

