/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.utils;

import com.glavsoft.rfb.client.ClientMessageType;
import com.glavsoft.rfb.client.ClientToServerMessage;
import com.glavsoft.rfb.protocol.Protocol;
import com.glavsoft.rfb.protocol.ProtocolSettings;
import com.glavsoft.transport.BaudrateMeter;

public class ViewerControlApi {
    private final Protocol protocol;
    private BaudrateMeter baudrateMeter;

    public ViewerControlApi(Protocol protocol, BaudrateMeter baudrateMeter) {
        this.protocol = protocol;
        this.baudrateMeter = baudrateMeter;
        protocol.setBaudrateMeter(baudrateMeter);
    }

    public void sendMessage(ClientToServerMessage message) {
        this.protocol.sendMessage(message);
    }

    public void sendKeepAlive() {
        this.protocol.sendSupportedEncodingsMessage(this.protocol.getSettings());
    }

    public void setCompressionLevelTo(int compressionLevel) {
        ProtocolSettings settings = this.protocol.getSettings();
        settings.setCompressionLevel(compressionLevel);
        settings.fireListeners();
    }

    public void setJpegQualityTo(int jpegQuality) {
        ProtocolSettings settings = this.protocol.getSettings();
        settings.setJpegQuality(jpegQuality);
        settings.fireListeners();
    }

    public void setViewOnly(boolean isViewOnly) {
        ProtocolSettings settings = this.protocol.getSettings();
        settings.setViewOnly(isViewOnly);
        settings.fireListeners();
    }

    public int getBaudrate() {
        return this.baudrateMeter.kBPS();
    }

    public boolean isSupported(ClientMessageType type) {
        return this.protocol.isSupported(type);
    }
}

