/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer;

import com.glavsoft.rfb.protocol.ProtocolSettings;
import com.glavsoft.utils.LazyLoaded;
import com.glavsoft.utils.Strings;
import com.glavsoft.viewer.ConnectionPresenter;
import com.glavsoft.viewer.UiSettings;
import com.glavsoft.viewer.ViewerEventsListener;
import com.glavsoft.viewer.VncKeepAliveThread;
import com.glavsoft.viewer.cli.Parser;
import com.glavsoft.viewer.mac.MacApplicationWrapper;
import com.glavsoft.viewer.mac.MacUtils;
import com.glavsoft.viewer.mvp.View;
import com.glavsoft.viewer.swing.ConnectionParams;
import com.glavsoft.viewer.swing.MouseEnteredListener;
import com.glavsoft.viewer.swing.ParametersHandler;
import com.glavsoft.viewer.swing.SwingConnectionWorkerFactory;
import com.glavsoft.viewer.swing.SwingViewerWindow;
import com.glavsoft.viewer.swing.SwingViewerWindowFactory;
import com.glavsoft.viewer.swing.WrongParameterException;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class Viewer
extends JApplet
implements Runnable,
MouseListener,
ViewerEventsListener {
    private static final String ATTR_APPLET_GOODBYE_URL = "AppletGoodbyeURL";
    private static final String DEFAULT_APPLET_GOODBYE_URL = "about:blank";
    private final ApplicationSettings applicationSettings;
    private final VncKeepAliveThread myVncKeepAliveThread;
    private final String myConfigurationName;
    private static final Logger logger = Logger.getLogger(Viewer.class.getName());
    private int paramsMask;
    private boolean allowAppletInteractiveConnections;
    private final ConnectionParams connectionParams;
    private String passwordFromParams;
    boolean isSeparateFrame = true;
    boolean isApplet = true;
    private final ProtocolSettings settings;
    private final UiSettings uiSettings;
    private volatile boolean isAppletStopped = false;
    private ConnectionPresenter connectionPresenter;
    private MouseEnteredListener mouseEnteredListener;
    private static LazyLoaded<String> ver = new LazyLoaded<String>(new LazyLoaded.Loader<String>(){

        @Override
        public String load() {
            String version = Viewer.class.getPackage().getImplementationVersion();
            if (version != null) {
                return version;
            }
            try {
                String result;
                Attributes attrs = new Manifest(new FileInputStream("META-INF/MANIFEST.MF")).getMainAttributes();
                String ver = attrs.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                try {
                    result = ver != null ? new String(ver.getBytes("ISO-8859-1"), "ISO-8859-1") : null;
                }
                catch (UnsupportedEncodingException e) {
                    result = null;
                }
                version = result;
            }
            catch (FileNotFoundException e) {
                System.out.println("Manifest file not found");
            }
            catch (IOException e) {
                System.out.println("Cannot read Manifest file");
            }
            return version;
        }
    });

    public static Parser prepareParser(String[] args) {
        if (MacUtils.isMac()) {
            try {
                MacApplicationWrapper application = MacApplicationWrapper.getApplication();
                application.setEnabledAboutMenu(false);
                MacUtils.setName("TightVNC Viewer");
                application.setDockIconImage(MacUtils.getIconImage());
            }
            catch (Exception e) {
                logger.warning(e.getMessage());
            }
        }
        Parser parser = new Parser();
        ParametersHandler.completeParserOptions(parser);
        parser.parse(args);
        if (parser.isSet("help")) {
            Viewer.printUsage(parser.optionsUsage());
            return null;
        }
        return parser;
    }

    public static void printUsage(String additional) {
        String string = String.valueOf("Usage: java -jar (progfilename) [hostname [port_number]] [Options]\n    or\n java -jar (progfilename) [Options]\n    or\n java -jar (progfilename) -help\n    to view this help\n\nWhere Options are:\n");
        System.out.println(new StringBuilder(142 + String.valueOf(string).length() + String.valueOf(additional).length()).append(string).append(additional).append("\nOptions format: -optionName=optionValue. Ex. -host=localhost -port=5900 -viewonly=yes\n").append("Both option name and option value are case insensitive.").toString());
    }

    public Viewer(VncKeepAliveThread vncKeepAliveThread, String configurationName) {
        this.myVncKeepAliveThread = vncKeepAliveThread;
        this.myConfigurationName = configurationName;
        String string = String.valueOf(Viewer.ver());
        logger.info(string.length() != 0 ? "TightVNC Viewer version ".concat(string) : new String("TightVNC Viewer version "));
        this.connectionParams = new ConnectionParams();
        this.settings = ProtocolSettings.getDefaultSettings();
        this.uiSettings = new UiSettings();
        this.applicationSettings = new ApplicationSettings();
    }

    public Viewer(VncKeepAliveThread vncKeepAliveThread, Parser parser, String configurationName) {
        this(vncKeepAliveThread, configurationName);
        this.paramsMask = ParametersHandler.completeSettingsFromCLI(parser, this.connectionParams, this.settings, this.uiSettings, this.applicationSettings);
        this.setLoggingLevel(this.applicationSettings.logLevel);
        this.passwordFromParams = parser.getValueFor("password");
        String string = String.valueOf(Viewer.ver());
        logger.info(string.length() != 0 ? "TightVNC Viewer version ".concat(string) : new String("TightVNC Viewer version "));
        this.isApplet = false;
    }

    private void setLoggingLevel(Level levelToSet) {
        Logger appLogger = Logger.getLogger("com.glavsoft");
        try {
            appLogger.setUseParentHandlers(false);
            appLogger.setLevel(levelToSet);
            for (Handler h : appLogger.getHandlers()) {
                if (h instanceof ConsoleHandler) {
                    appLogger.removeHandler(h);
                    continue;
                }
                h.setLevel(levelToSet);
            }
            ConsoleHandler ch = new ConsoleHandler();
            ch.setLevel(levelToSet);
            appLogger.addHandler(ch);
        }
        catch (SecurityException e) {
            String string = String.valueOf(levelToSet);
            logger.warning(new StringBuilder(29 + String.valueOf(string).length()).append("cannot set logging level to: ").append(string).toString());
        }
    }

    private void closeApp() {
        if (this.connectionPresenter != null) {
            this.connectionPresenter.cancelConnection();
            logger.info("Connection cancelled.");
        }
        if (this.isApplet) {
            logger.severe("Applet is stopped.");
            this.isAppletStopped = true;
            this.repaint();
            this.stop();
            URL goodbyeUrl = null;
            String goodBye = this.getParameter(ATTR_APPLET_GOODBYE_URL);
            if (Strings.isTrimmedEmpty(goodBye)) {
                return;
            }
            try {
                goodbyeUrl = new URL(goodBye);
            }
            catch (MalformedURLException e) {
                String string = String.valueOf(DEFAULT_APPLET_GOODBYE_URL);
                logger.severe(new StringBuilder(27 + String.valueOf(goodBye).length() + String.valueOf(string).length()).append("Malformed URL: '").append(goodBye).append("'. Using '").append(string).append("'").toString());
                try {
                    goodbyeUrl = new URL(DEFAULT_APPLET_GOODBYE_URL);
                }
                catch (MalformedURLException ignore) {
                    // empty catch block
                }
            }
            this.getAppletContext().showDocument(goodbyeUrl);
        }
    }

    public void stopViewer() {
        if (this.connectionPresenter != null) {
            this.connectionPresenter.cancelConnection();
            System.out.println("Viewer stopped!");
        }
    }

    @Override
    public void paint(Graphics g) {
        if (!this.isAppletStopped) {
            super.paint(g);
        } else {
            this.getContentPane().removeAll();
            g.clearRect(0, 0, this.getWidth(), this.getHeight());
            g.drawString("Disconnected", 10, 20);
        }
    }

    @Override
    public void destroy() {
        System.out.println("destroy");
        this.closeApp();
        super.destroy();
    }

    @Override
    public void init() {
        AppletSettings appletSettings = new AppletSettings();
        this.paramsMask = ParametersHandler.completeSettingsFromApplet(this, this.connectionParams, this.settings, this.uiSettings, this.applicationSettings, appletSettings);
        this.setLoggingLevel(this.applicationSettings.logLevel);
        this.isSeparateFrame = appletSettings.isSeparateFrame;
        this.passwordFromParams = this.getParameter("password");
        this.isApplet = true;
        this.allowAppletInteractiveConnections = appletSettings.allowInteractiveConnections;
        this.repaint();
        try {
            SwingUtilities.invokeAndWait(this);
        }
        catch (Exception e) {
            logger.severe(e.getMessage());
        }
    }

    @Override
    public void start() {
        super.start();
    }

    private boolean checkJsch() {
        try {
            Class.forName("com.jcraft.jsch.JSch");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    public void run() {
        boolean hasJsch = this.checkJsch();
        boolean allowInteractive = this.allowAppletInteractiveConnections || !this.isApplet;
        this.connectionPresenter = new ConnectionPresenter(hasJsch, allowInteractive);
        SwingViewerWindowFactory viewerWindowFactory = new SwingViewerWindowFactory(this.isSeparateFrame, this);
        this.connectionPresenter.setConnectionWorkerFactory(new SwingConnectionWorkerFactory(this.passwordFromParams, this.connectionPresenter, viewerWindowFactory));
        this.connectionPresenter.addModel("ConnectionParamsModel", this.connectionParams);
        this.connectionPresenter.startConnection(this.settings, this.uiSettings, this.paramsMask, this.myConfigurationName, this.myVncKeepAliveThread);
        String hostName = this.connectionParams.hostName;
        try {
            this.connectionPresenter.submitConnection(hostName);
        }
        catch (WrongParameterException wpe) {
            if ("HostName".equals(wpe.getPropertyName())) {
                // empty if block
            }
            if ("PortNumber".equals(wpe.getPropertyName())) {
                // empty if block
            }
        }
    }

    public static String ver() {
        return ver.get();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.mouseEnteredListener != null) {
            this.mouseEnteredListener.mouseEnteredEvent(mouseEvent);
        }
    }

    @Override
    public void onViewerComponentClosing() {
        this.closeApp();
    }

    @Override
    public void onViewerComponentContainerBuilt(SwingViewerWindow viewerWindow) {
        if (this.isSeparateFrame) {
            viewerWindow.setVisible();
        }
        viewerWindow.validate();
        this.mouseEnteredListener = viewerWindow;
        viewerWindow.addMouseListener(this);
    }

    private void moveFrameToFrontABitLater(final JFrame frame) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        frame.toFront();
                    }
                });
            }
        }).start();
    }

    public static class ApplicationSettings {
        Level logLevel;
        public String password;

        public void calculateLogLevel(boolean verbose, boolean verboseMore) {
            this.logLevel = verboseMore ? Level.FINER : (verbose ? Level.FINE : Level.INFO);
        }
    }

    public static class AppletSettings {
        public boolean allowInteractiveConnections;
        public boolean isSeparateFrame;
    }

    private class AppletStatusStringView
    implements View {
        private AppletStatusStringView() {
        }

        @Override
        public void showView() {
        }

        @Override
        public void closeView() {
        }

        public void setMessage(String message) {
            Viewer.this.getAppletContext().showStatus(message);
        }
    }
}

