/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer.swing;

import com.glavsoft.drawing.Renderer;
import com.glavsoft.rfb.encoding.PixelFormat;
import com.glavsoft.rfb.encoding.decoder.FramebufferUpdateRectangle;
import com.glavsoft.transport.Transport;
import com.glavsoft.viewer.swing.SoftCursorImpl;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class RendererImpl
extends Renderer
implements ImageObserver {
    CyclicBarrier barrier = new CyclicBarrier(2);
    private final Image offscreenImage;

    public RendererImpl(Transport transport, int width, int height, PixelFormat pixelFormat) {
        if (0 == width) {
            width = 1;
        }
        if (0 == height) {
            height = 1;
        }
        this.init(width, height, pixelFormat);
        DirectColorModel colorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
        SampleModel sampleModel = ((ColorModel)colorModel).createCompatibleSampleModel(width, height);
        DataBufferInt dataBuffer = new DataBufferInt(this.pixels, width * height);
        WritableRaster raster = Raster.createWritableRaster(sampleModel, dataBuffer, null);
        this.offscreenImage = new BufferedImage(colorModel, raster, false, null);
        this.cursor = new SoftCursorImpl(0, 0, 0, 0);
    }

    @Override
    public void drawJpegImage(byte[] bytes, int offset, int jpegBufferLength, FramebufferUpdateRectangle rect) {
        Image jpegImage = Toolkit.getDefaultToolkit().createImage(bytes, offset, jpegBufferLength);
        Toolkit.getDefaultToolkit().prepareImage(jpegImage, -1, -1, this);
        try {
            this.barrier.await(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
        }
        catch (BrokenBarrierException e) {
        }
        catch (TimeoutException e) {
            // empty catch block
        }
        Graphics graphics = this.offscreenImage.getGraphics();
        graphics.drawImage(jpegImage, rect.x, rect.y, rect.width, rect.height, this);
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        boolean isReady;
        boolean bl = isReady = (infoflags & 0xA0) != 0;
        if (isReady) {
            try {
                this.barrier.await();
            }
            catch (InterruptedException e) {
            }
            catch (BrokenBarrierException e) {
                // empty catch block
            }
        }
        return !isReady;
    }

    public Image getOffscreenImage() {
        return this.offscreenImage;
    }

    public void paintImageOn(Graphics g) {
        this.lock.lock();
        try {
            if (this.offscreenImage != null) {
                g.drawImage(this.offscreenImage, 0, 0, null);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintCursorOn(Graphics g, boolean force) {
        Object object = this.cursor.getLock();
        synchronized (object) {
            Image cursorImage = ((SoftCursorImpl)this.cursor).getImage();
            if (cursorImage != null && (force || g.getClipBounds().intersects(this.cursor.rX, this.cursor.rY, this.cursor.width, this.cursor.height))) {
                g.drawImage(cursorImage, this.cursor.rX, this.cursor.rY, null);
            }
        }
    }

    public SoftCursorImpl getCursor() {
        return (SoftCursorImpl)this.cursor;
    }
}

