/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer.swing;

import com.glavsoft.rfb.protocol.Protocol;
import com.glavsoft.rfb.protocol.ProtocolSettings;
import com.glavsoft.viewer.ConnectionPresenter;
import com.glavsoft.viewer.UiSettings;
import com.glavsoft.viewer.ViewerEventsListener;
import com.glavsoft.viewer.VncKeepAliveThread;
import com.glavsoft.viewer.swing.Surface;
import com.glavsoft.viewer.swing.SwingViewerWindow;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;

public class SwingViewerWindowFactory {
    private final boolean isSeparateFrame;
    private boolean isApplet = false;
    private final ViewerEventsListener viewerEventsListener;
    private Container externalContainer;

    public SwingViewerWindowFactory(boolean isSeparateFrame, ViewerEventsListener viewerEventsListener) {
        this.isSeparateFrame = isSeparateFrame;
        this.viewerEventsListener = viewerEventsListener;
    }

    public SwingViewerWindow createViewerWindow(Protocol workingProtocol, ProtocolSettings rfbSettings, UiSettings uiSettings, String connectionString, String configurationName, VncKeepAliveThread vncKeepAliveThread, ConnectionPresenter presenter) {
        Surface surface = new Surface(workingProtocol, uiSettings.getScaleFactor(), uiSettings.getMouseCursorShape());
        SwingViewerWindow viewerWindow = new SwingViewerWindow(workingProtocol, rfbSettings, uiSettings, surface, this.isSeparateFrame, this.isApplet, this.viewerEventsListener, connectionString, configurationName, vncKeepAliveThread, presenter, this.externalContainer);
        surface.setViewerWindow(viewerWindow);
        viewerWindow.setRemoteDesktopName(workingProtocol.getRemoteDesktopName());
        rfbSettings.addListener(viewerWindow);
        uiSettings.addListener(surface);
        viewerWindow.zoomToFit();
        Insets scrollerInsets = viewerWindow.getScroller().getInsets();
        Insets containerInsets = viewerWindow.getFrame().getInsets();
        Dimension framePreferredSize = new Dimension(surface.getWidth() + containerInsets.left + containerInsets.right + scrollerInsets.left + scrollerInsets.right, surface.getHeight() + containerInsets.top + containerInsets.bottom + scrollerInsets.top + scrollerInsets.bottom);
        viewerWindow.getFrame().setPreferredSize(framePreferredSize);
        viewerWindow.getFrame().setSize(framePreferredSize);
        return viewerWindow;
    }

    public void setExternalContainer(Container externalContainer) {
        this.externalContainer = externalContainer;
    }

    public void setIsApplet(boolean isApplet) {
        this.isApplet = isApplet;
    }
}

