/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.List;

public class CommentDetector
extends Detector
implements Detector.JavaPsiScanner {
    private static final String STOPSHIP_COMMENT = "STOPSHIP";
    private static final Implementation IMPLEMENTATION = new Implementation(CommentDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue EASTER_EGG = Issue.create((String)"EasterEgg", (String)"Code contains easter egg", (String)"An \"easter egg\" is code deliberately hidden in the code, both from potential users and even from other developers. This lint check looks for code which looks like it may be hidden from sight.", (Category)Category.SECURITY, (int)6, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION).setEnabledByDefault(false);
    public static final Issue STOP_SHIP = Issue.create((String)"StopShip", (String)"Code contains `STOPSHIP` marker", (String)"Using the comment `// STOPSHIP` can be used to flag code that is incomplete but checked in. This comment marker can be used to indicate that the code should not be shipped until the issue is addressed, and lint will look for these.", (Category)Category.CORRECTNESS, (int)10, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION).setEnabledByDefault(false);
    private static final String ESCAPE_STRING = "\\u002a\\u002f";
    private static final boolean USE_AST = false;

    public List<Class<? extends PsiElement>> getApplicablePsiTypes() {
        return null;
    }

    public JavaElementVisitor createPsiVisitor(JavaContext context) {
        String source = context.getContents();
        if (source == null) {
            return null;
        }
        int n = source.length() - 1;
        for (int i = 0; i < n; ++i) {
            int end;
            int start;
            char c = source.charAt(i);
            if (c == '\\') {
                ++i;
                continue;
            }
            if (c != '/') continue;
            char next = source.charAt(i + 1);
            if (next == '/') {
                start = i + 2;
                end = source.indexOf(10, start);
                if (end == -1) {
                    end = n;
                }
                CommentDetector.checkComment(context, null, source, 0, start, end);
                continue;
            }
            if (next != '*') continue;
            start = i + 2;
            end = source.indexOf("*/", start);
            if (end == -1) {
                end = n;
            }
            CommentDetector.checkComment(context, null, source, 0, start, end);
        }
        return null;
    }

    private static void checkComment(JavaContext context, PsiComment node, String source, int offset, int start, int end) {
        int prev = 0;
        for (int i = start; i < end - 2; ++i) {
            Location location;
            char c = source.charAt(i);
            if (prev == 92) {
                if (c == 'u' || c == 'U') {
                    if (source.regionMatches(true, i - 1, ESCAPE_STRING, 0, ESCAPE_STRING.length())) {
                        location = Location.create((File)context.file, (String)source, (int)(offset + i - 1), (int)(offset + i - 1 + ESCAPE_STRING.length()));
                        context.report(EASTER_EGG, (PsiElement)node, location, "Code might be hidden here; found unicode escape sequence which is interpreted as comment end, compiled code follows");
                    }
                } else {
                    ++i;
                }
            } else if (prev == 83 && c == 'T' && source.regionMatches(i - 1, STOPSHIP_COMMENT, 0, STOPSHIP_COMMENT.length())) {
                location = Location.create((File)context.file, (String)source, (int)(offset + i - 1), (int)(offset + i - 1 + STOPSHIP_COMMENT.length()));
                context.report(STOP_SHIP, (PsiElement)node, location, "`STOPSHIP` comment found; points to code which must be fixed prior to release");
            }
            prev = c;
        }
    }

    private static class CommentChecker
    extends JavaElementVisitor {
        private final JavaContext mContext;

        public CommentChecker(JavaContext context) {
            this.mContext = context;
        }

        public void visitComment(PsiComment comment) {
            String contents = comment.getText();
            CommentDetector.checkComment(this.mContext, comment, contents, comment.getTextRange().getStartOffset(), 0, contents.length());
        }
    }
}

