/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.appengine.admin;

import com.google.api.client.util.Strings;
import com.google.api.services.appengine.v1.model.Location;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class AppEngineLocationSelectorItem {
    @VisibleForTesting
    static final String STANDARD_ENV_AVAILABLE_KEY = "standardEnvironmentAvailable";
    @VisibleForTesting
    static final String FLEXIBLE_ENV_AVAILABLE_KEY = "flexibleEnvironmentAvailable";
    private final Location location;

    public AppEngineLocationSelectorItem(@NotNull Location location) {
        String locationIdLabel;
        this.location = location;
        String string = locationIdLabel = location.getLabels() != null ? (String)location.getLabels().get("cloud.googleapis.com/region") : null;
        if (Strings.isNullOrEmpty((String)location.getLocationId()) && !Strings.isNullOrEmpty((String)locationIdLabel)) {
            location.setLocationId(locationIdLabel);
        }
    }

    public String toString() {
        return this.location.getLocationId();
    }

    public Location getLocation() {
        return this.location;
    }

    public boolean isFlexSupported() {
        return this.parseMetadataBoolean(FLEXIBLE_ENV_AVAILABLE_KEY, this.location.getMetadata());
    }

    public boolean isStandardSupported() {
        return this.parseMetadataBoolean(STANDARD_ENV_AVAILABLE_KEY, this.location.getMetadata());
    }

    private boolean parseMetadataBoolean(String key, Map<String, Object> metadata) {
        if (!metadata.containsKey(key)) {
            return false;
        }
        Object val = metadata.get(key);
        if (val == null || !(val instanceof Boolean)) {
            return false;
        }
        return (Boolean)val;
    }
}

