/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.debugger;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gct.idea.debugger.BreakpointUtil;
import com.google.gct.idea.debugger.CloudBreakpointHandler;
import com.google.gct.idea.debugger.CloudBreakpointListener;
import com.google.gct.idea.debugger.CloudDebugProcessHandler;
import com.google.gct.idea.debugger.CloudDebugProcessState;
import com.google.gct.idea.debugger.CloudDebugProcessStateController;
import com.google.gct.idea.debugger.CloudDebugRunConfiguration;
import com.google.gct.idea.debugger.CloudExecutionStack;
import com.google.gct.idea.debugger.CloudLineBreakpointType;
import com.google.gct.idea.debugger.JavaUtil;
import com.google.gct.idea.debugger.ProjectRepositoryValidator;
import com.google.gct.idea.debugger.ui.CloudDebugHistoricalSnapshots;
import com.google.gct.idea.util.GctBundle;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.LayoutAttractionPolicy;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithActions;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.content.Content;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.ui.XDebugTabLayouter;
import icons.GoogleCloudToolsIcons;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.JavaDebuggerEditorsProvider;

public class CloudDebugProcess
extends XDebugProcess
implements CloudBreakpointListener {
    private static final Logger LOG = Logger.getInstance(CloudDebugProcess.class);
    private volatile com.google.api.services.debugger.model.Breakpoint myCurrentSnapshot;
    private CloudDebugProcessState myProcessState;
    private ProjectRepositoryValidator myRepoValidator;
    private CloudDebugProcessStateController myStateController;
    private XBreakpointHandler<?>[] myXBreakpointHandlers;

    CloudDebugProcess(@NotNull XDebugSession session) {
        super(session);
    }

    public void addListener(@NotNull CloudBreakpointListener listener) {
        this.getStateController().addListener(listener);
    }

    public boolean checkCanPerformCommands() {
        Messages.showErrorDialog((String)"The Cloud Debugger does not pause execution.  Therefore, this feature is unavailable.", (String)"Not Supported");
        return false;
    }

    @NotNull
    public XDebugTabLayouter createTabLayouter() {
        final CloudDebugProcessHandler handler = (CloudDebugProcessHandler)this.getProcessHandler();
        return new XDebugTabLayouter(){

            public void registerAdditionalContent(@NotNull RunnerLayoutUi layout) {
                layout.removeContent(layout.findContent("WatchesContent"), false);
                Content content = layout.findContent("FrameContent");
                if (content != null) {
                    layout.removeContent(content, false);
                    layout.addContent(content, 0, PlaceInGrid.center, false);
                }
                if ((content = layout.findContent("VariablesContent")) != null) {
                    layout.removeContent(content, false);
                    layout.addContent(content, 0, PlaceInGrid.right, false);
                }
                CloudDebugHistoricalSnapshots timeline = new CloudDebugHistoricalSnapshots(handler);
                Content snapshots = layout.createContent(timeline.getTabTitle(), (ComponentWithActions)timeline, timeline.getTabTitle(), GoogleCloudToolsIcons.CLOUD, null);
                layout.addContent(snapshots, 0, PlaceInGrid.left, false);
                layout.getDefaults().initFocusContent("FrameContent", "startup", (LayoutAttractionPolicy)new LayoutAttractionPolicy.FocusOnce(false));
            }
        };
    }

    @Nullable
    protected ProcessHandler doGetProcessHandler() {
        return new CloudDebugProcessHandler(this);
    }

    public void fireBreakpointsChanged() {
        this.getStateController().fireBreakpointsChanged();
    }

    @NotNull
    public CloudBreakpointHandler getBreakpointHandler() {
        return (CloudBreakpointHandler)this.getBreakpointHandlers()[0];
    }

    @NotNull
    public XBreakpointHandler<?>[] getBreakpointHandlers() {
        if (this.myXBreakpointHandlers == null) {
            this.myXBreakpointHandlers = new XBreakpointHandler[]{new CloudBreakpointHandler(this)};
        }
        return this.myXBreakpointHandlers;
    }

    public List<com.google.api.services.debugger.model.Breakpoint> getCurrentBreakpointList() {
        return this.getProcessState().getCurrentServerBreakpointList();
    }

    public com.google.api.services.debugger.model.Breakpoint getCurrentSnapshot() {
        return this.myCurrentSnapshot;
    }

    @NotNull
    public XDebuggerEditorsProvider getEditorsProvider() {
        return new JavaDebuggerEditorsProvider();
    }

    public CloudDebugProcessState getProcessState() {
        return this.myProcessState;
    }

    protected ProjectRepositoryValidator getRepositoryValidator() {
        if (this.myRepoValidator == null) {
            this.myRepoValidator = new ProjectRepositoryValidator(this.getProcessState());
        }
        return this.myRepoValidator;
    }

    public CloudDebugProcessStateController getStateController() {
        if (this.myStateController == null) {
            this.myStateController = new CloudDebugProcessStateController();
        }
        return this.myStateController;
    }

    public XDebugSession getXDebugSession() {
        return this.getSession();
    }

    public void initialize(@NotNull CloudDebugProcessState processState) {
        this.myProcessState = processState;
        this.myCurrentSnapshot = null;
        new Task.Modal(this.getXDebugSession().getProject(), GctBundle.getString("clouddebug.attachingtext", new Object[0]), false){

            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setIndeterminate(true);
                CloudDebugProcess.this.getStateController().initialize(CloudDebugProcess.this.myProcessState);
                CloudDebugProcess.this.getRepositoryValidator().hardRefresh();
            }
        }.queue();
        JavaUtil.initializeLocations(this.getXDebugSession().getProject(), true);
        this.getStateController().addListener(this);
        this.getStateController().startBackgroundListening();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CloudDebugProcess.this.getBreakpointHandler().createIdeRepresentationsIfNecessary(CloudDebugProcess.this.getCurrentBreakpointList());
            }
        });
    }

    public void navigateToSnapshot(@NotNull String id) {
        ListenableFuture<com.google.api.services.debugger.model.Breakpoint> future = this.getStateController().resolveBreakpoint(id);
        if (future != null) {
            Futures.addCallback(future, (FutureCallback)new FutureCallback<com.google.api.services.debugger.model.Breakpoint>(){

                public void onSuccess(final com.google.api.services.debugger.model.Breakpoint result) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (result.getIsFinalState() != Boolean.TRUE || result.getStackFrames() == null) {
                                CloudDebugProcess.this.getBreakpointHandler().navigateTo(result);
                                return;
                            }
                            if (CloudDebugProcess.this.myCurrentSnapshot == null || !CloudDebugProcess.this.myCurrentSnapshot.getId().equals(result.getId())) {
                                Date brokenTime = new Date(result.getFinalTime().getSeconds() * 1000L);
                                DateFormat df = DateFormat.getDateTimeInstance(3, 3);
                                CloudDebugProcess.this.myCurrentSnapshot = result;
                                if (!CloudDebugProcess.this.getXDebugSession().isStopped()) {
                                    CloudDebugProcess.this.getXDebugSession().positionReached((XSuspendContext)new MySuspendContext(new CloudExecutionStack(CloudDebugProcess.this.getXDebugSession().getProject(), GctBundle.getString("clouddebug.stackat", df.format(brokenTime)), result.getStackFrames(), result.getVariableTable(), result.getEvaluatedExpressions())));
                                }
                            }
                        }
                    });
                }

                public void onFailure(@NotNull Throwable t) {
                    LOG.warn("Could not navigate to breakpoint:", t);
                }
            });
        }
    }

    @Override
    public void onBreakpointListChanged(CloudDebugProcessState state) {
        final List<com.google.api.services.debugger.model.Breakpoint> currentList = this.getCurrentBreakpointList();
        if (currentList != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CloudDebugProcess.this.getBreakpointHandler().createIdeRepresentationsIfNecessary(currentList);
                }
            });
            for (com.google.api.services.debugger.model.Breakpoint breakpoint : currentList) {
                XBreakpoint breakpointHit = this.getBreakpointHandler().getEnabledXBreakpoint(breakpoint);
                if (breakpointHit == null) continue;
                if (breakpoint.getIsFinalState() == Boolean.TRUE && (breakpoint.getStatus() == null || breakpoint.getStatus().getIsError() != Boolean.TRUE)) {
                    ListenableFuture<com.google.api.services.debugger.model.Breakpoint> future;
                    if (this.myCurrentSnapshot == null && (future = this.getStateController().resolveBreakpoint(breakpoint.getId())) != null) {
                        Futures.addCallback(future, (FutureCallback)new FutureCallback<com.google.api.services.debugger.model.Breakpoint>(){

                            public void onSuccess(final com.google.api.services.debugger.model.Breakpoint result) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        Date brokenTime = new Date(result.getFinalTime().getSeconds() * 1000L);
                                        DateFormat df = DateFormat.getDateTimeInstance(3, 3);
                                        CloudDebugProcess.this.myCurrentSnapshot = result;
                                        if (!CloudDebugProcess.this.getXDebugSession().isStopped()) {
                                            CloudDebugProcess.this.getXDebugSession().positionReached((XSuspendContext)new MySuspendContext(new CloudExecutionStack(CloudDebugProcess.this.getXDebugSession().getProject(), GctBundle.getString("clouddebug.stackat", df.format(brokenTime)), result.getStackFrames(), result.getVariableTable(), result.getEvaluatedExpressions())));
                                        }
                                    }
                                });
                            }

                            public void onFailure(@NotNull Throwable t) {
                                LOG.warn("was unable to hydrate breakpoint on ListChanged", t);
                            }
                        });
                    }
                    if (this.getXDebugSession().isStopped()) continue;
                    this.getBreakpointHandler().setStateToDisabled(breakpoint);
                    continue;
                }
                if (breakpoint.getIsFinalState() != Boolean.TRUE) continue;
                Breakpoint cloudBreakpoint = BreakpointManager.getJavaBreakpoint((XBreakpoint)breakpointHit);
                if (breakpoint.getStatus() == null || breakpoint.getStatus().getIsError() != Boolean.TRUE || !(cloudBreakpoint instanceof CloudLineBreakpointType.CloudLineBreakpoint)) continue;
                ((CloudLineBreakpointType.CloudLineBreakpoint)cloudBreakpoint).setErrorMessage(BreakpointUtil.getUserErrorMessage(breakpoint.getStatus()));
                cloudBreakpoint.updateUI();
            }
        }
    }

    public void registerAdditionalActions(@NotNull DefaultActionGroup leftToolbar, @NotNull DefaultActionGroup topToolbar, @NotNull DefaultActionGroup settings) {
        ActionManager manager = ActionManager.getInstance();
        leftToolbar.add((AnAction)new SaveAndExitAction(), new Constraints(Anchor.AFTER, "Stop"));
        leftToolbar.remove(manager.getAction("Rerun"));
        leftToolbar.remove(manager.getAction("Stop"));
        leftToolbar.remove(manager.getAction("Resume"));
        leftToolbar.remove(manager.getAction("Pause"));
        leftToolbar.remove(manager.getAction("XDebugger.MuteBreakpoints"));
        topToolbar.remove(manager.getAction("StepOver"));
        topToolbar.remove(manager.getAction("StepInto"));
        topToolbar.remove(manager.getAction("ForceStepInto"));
        topToolbar.remove(manager.getAction("StepOut"));
        topToolbar.remove(manager.getAction("RunToCursor"));
        topToolbar.remove(manager.getAction("EvaluateExpression"));
    }

    public void removeListener(@NotNull CloudBreakpointListener listener) {
        this.getStateController().removeListener(listener);
    }

    public void resume() {
    }

    public void runToPosition(@NotNull XSourcePosition position) {
    }

    public void startStepInto() {
    }

    public void startStepOut() {
    }

    public void startStepOver() {
    }

    public void stop() {
        this.getStateController().stopBackgroundListening();
        RunProfile profile = this.getXDebugSession().getRunProfile();
        if (profile instanceof CloudDebugRunConfiguration) {
            ((CloudDebugRunConfiguration)profile).setProcessState(this.myProcessState);
        }
        this.getRepositoryValidator().restoreToOriginalState(this.getXDebugSession().getProject());
        XBreakpointManager breakpointManager = XDebuggerManager.getInstance((Project)this.getXDebugSession().getProject()).getBreakpointManager();
        for (XBreakpoint bp : breakpointManager.getAllBreakpoints()) {
            Breakpoint cloudBreakpoint = BreakpointManager.getJavaBreakpoint((XBreakpoint)bp);
            if (!(cloudBreakpoint instanceof CloudLineBreakpointType.CloudLineBreakpoint)) continue;
            CloudLineBreakpointType.CloudLineBreakpoint cloudLineBreakpoint = (CloudLineBreakpointType.CloudLineBreakpoint)cloudBreakpoint;
            cloudLineBreakpoint.setVerified(false);
            cloudLineBreakpoint.setErrorMessage(null);
            cloudLineBreakpoint.updateUI();
        }
    }

    private class SaveAndExitAction
    extends AnAction {
        public SaveAndExitAction() {
            super(GctBundle.getString("clouddebug.stopandcontinue", new Object[0]), GctBundle.getString("clouddebug.exitdebug", new Object[0]), GoogleCloudToolsIcons.CLOUD_DEBUG_SAVE_EXIT);
        }

        public void actionPerformed(AnActionEvent e) {
            ActionManager.getInstance().getAction("Stop").actionPerformed(e);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(!CloudDebugProcess.this.getXDebugSession().isStopped());
        }
    }

    private static class MySuspendContext
    extends XSuspendContext {
        private final XExecutionStack myStack;

        public MySuspendContext(@NotNull XExecutionStack stack) {
            this.myStack = stack;
        }

        public XExecutionStack getActiveExecutionStack() {
            return this.myStack;
        }

        public XExecutionStack[] getExecutionStacks() {
            return new XExecutionStack[]{this.getActiveExecutionStack(), this.getSourceStack()};
        }

        @NotNull
        public XExecutionStack getSourceStack() {
            return this.myStack;
        }
    }

    static interface XDebuggerActions {
        @NonNls
        public static final String EVALUATE_EXPRESSION = "EvaluateExpression";
        @NonNls
        public static final String FORCE_STEP_INTO = "ForceStepInto";
        @NonNls
        public static final String MUTE_BREAKPOINTS = "XDebugger.MuteBreakpoints";
        @NonNls
        public static final String PAUSE = "Pause";
        @NonNls
        public static final String RESUME = "Resume";
        @NonNls
        public static final String RUN_TO_CURSOR = "RunToCursor";
        @NonNls
        public static final String STEP_INTO = "StepInto";
        @NonNls
        public static final String STEP_OUT = "StepOut";
        @NonNls
        public static final String STEP_OVER = "StepOver";
    }
}

