/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.debugger;

import com.google.gct.idea.debugger.CloudDebugProcess;
import com.google.gct.idea.debugger.CloudDebugProcessState;
import com.google.gct.idea.debugger.CloudDebugRunConfiguration;
import com.google.gct.idea.debugger.ProjectRepositoryState;
import com.google.gct.idea.debugger.ProjectRepositoryValidator;
import com.google.gct.idea.debugger.ui.CloudAttachDialog;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.DefaultProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import git4idea.DialogManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloudDebuggerRunner
extends DefaultProgramRunner {
    private static final String EXECUTOR_TARGET = "Debug";
    @NonNls
    private static final String ID = "CloudDebuggerRunner";

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        return profile instanceof CloudDebugRunConfiguration && EXECUTOR_TARGET.equals(executorId);
    }

    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment env) throws ExecutionException {
        CloudDebugProcessState cloudState = null;
        if (state instanceof CloudDebugProcessState) {
            cloudState = (CloudDebugProcessState)state;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        state.execute(env.getExecutor(), (ProgramRunner)this);
        return CloudDebuggerRunner.createContentDescriptor(cloudState, env);
    }

    @NotNull
    public String getRunnerId() {
        return ID;
    }

    private static RunContentDescriptor createContentDescriptor(final @Nullable CloudDebugProcessState processState, final @NotNull ExecutionEnvironment environment) throws ExecutionException {
        XDebugSession debugSession = XDebuggerManager.getInstance((Project)environment.getProject()).startSession(environment, new XDebugProcessStarter(){

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) throws ExecutionException {
                if (processState != null) {
                    ProjectRepositoryState.fromProcessState(processState).clearForNextSession();
                }
                CloudDebugProcessState state = processState;
                CloudAttachDialog attachDialog = new CloudAttachDialog(session.getProject());
                attachDialog.setInputState(state);
                DialogManager.show((DialogWrapper)attachDialog);
                state = attachDialog.getResultState();
                ProjectRepositoryValidator validator = null;
                if (state != null) {
                    validator = new ProjectRepositoryValidator(state);
                }
                if (!attachDialog.isOK() || state == null || !validator.isValidDebuggee()) {
                    throw new RunCanceledByUserException();
                }
                if (environment.getRunnerAndConfigurationSettings() != null && environment.getRunnerAndConfigurationSettings().getConfiguration() instanceof CloudDebugRunConfiguration) {
                    CloudDebugRunConfiguration config = (CloudDebugRunConfiguration)environment.getRunnerAndConfigurationSettings().getConfiguration();
                    config.setProcessState(null);
                }
                CloudDebugProcess process = new CloudDebugProcess(session);
                process.initialize(state);
                return process;
            }
        });
        return debugSession.getRunContentDescriptor();
    }
}

