/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.debugger;

import com.google.api.services.debugger.model.StackFrame;
import com.google.api.services.debugger.model.Variable;
import com.google.gct.idea.debugger.CloudStackFrame;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloudExecutionStack
extends XExecutionStack {
    private final List<XStackFrame> myFrames = new ArrayList<XStackFrame>();

    public CloudExecutionStack(@NotNull Project project, @NotNull String name, @NotNull List<StackFrame> frames, @NotNull List<Variable> variableTable, @Nullable List<Variable> evaluatedExpressions) {
        super(name);
        for (StackFrame nativeFrame : frames) {
            this.myFrames.add(new CloudStackFrame(project, nativeFrame, variableTable, evaluatedExpressions));
            evaluatedExpressions = null;
        }
    }

    public void computeStackFrames(int firstFrameIndex, XExecutionStack.XStackFrameContainer container) {
        if (firstFrameIndex <= this.myFrames.size()) {
            container.addStackFrames(this.myFrames.subList(firstFrameIndex, this.myFrames.size()), true);
        } else {
            container.addStackFrames(Collections.emptyList(), true);
        }
    }

    public XStackFrame getTopFrame() {
        return !this.myFrames.isEmpty() ? this.myFrames.get(0) : null;
    }
}

