/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.git;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.source.Source;
import com.google.api.services.source.SourceRequest;
import com.google.api.services.source.model.ListReposResponse;
import com.google.gct.login.CredentialedUser;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;

public class CloudRepositoryService {
    private static final String CLOUD_SOURCE_API_ROOT_URL = "https://source.googleapis.com/";
    private static final String CLOUD_SOURCE_API_LIST_URL = "v1/projects/{projectId}/repos";
    private static int LIST_TIMEOUT_MS = 5000;
    private static final String USER_AGENT = "gcloud-intellij-cloud-tools-plugin";

    @NotNull
    public ListReposResponse list(CredentialedUser user, String cloudProject) throws CloudRepositoryServiceException {
        try {
            Credential credential = user.getCredential();
            HttpRequestInitializer initializer = httpRequest -> {
                HttpHeaders headers = new HttpHeaders();
                httpRequest.setConnectTimeout(LIST_TIMEOUT_MS);
                httpRequest.setReadTimeout(LIST_TIMEOUT_MS);
                httpRequest.setHeaders(headers);
                credential.initialize(httpRequest);
            };
            NetHttpTransport httpTransport = GoogleNetHttpTransport.newTrustedTransport();
            Source source = new Source.Builder((HttpTransport)httpTransport, (JsonFactory)JacksonFactory.getDefaultInstance(), initializer).setRootUrl(CLOUD_SOURCE_API_ROOT_URL).setServicePath("").setApplicationName(USER_AGENT).build();
            return (ListReposResponse)new CustomUrlSourceRequest(source, cloudProject).execute();
        }
        catch (IOException | GeneralSecurityException ex) {
            throw new CloudRepositoryServiceException();
        }
    }

    public CompletableFuture<ListReposResponse> listAsync(CredentialedUser user, String cloudProject) {
        return CompletableFuture.supplyAsync(() -> this.list(user, cloudProject));
    }

    public static class CloudRepositoryServiceException
    extends RuntimeException {
    }

    public static class CustomUrlSourceRequest
    extends SourceRequest<ListReposResponse> {
        @Key
        private String projectId;

        CustomUrlSourceRequest(Source client, String projectId) {
            super(client, "GET", CloudRepositoryService.CLOUD_SOURCE_API_LIST_URL, null, ListReposResponse.class);
            this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
        }
    }
}

