/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.rmi;

import com.intellij.execution.rmi.RemoteDeadHand;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ExportException;
import java.rmi.server.UnicastRemoteObject;
import java.security.Security;
import java.util.Hashtable;
import java.util.Random;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteServer {
    public static final String DOMAIN_AUTH_LIBRARY_PATH = "domain.auth.library";
    public static final String DOMAIN_AUTH_MISSING_FILES = "Missing native authentication library: ";
    private static Remote ourRemote;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void start(Remote remote) throws Exception {
        Registry registry;
        int port;
        RemoteServer.setupRMI();
        RemoteServer.banJNDI();
        RemoteServer.setupSSL();
        RemoteServer.setupDomainAuth();
        if (ourRemote != null) {
            throw new AssertionError((Object)"Already started");
        }
        ourRemote = remote;
        Random random = new Random();
        while (true) {
            if ((port = random.nextInt(65535)) < 4000) {
                continue;
            }
            try {
                registry = LocateRegistry.createRegistry(port);
            }
            catch (ExportException exportException) {
                continue;
            }
            break;
        }
        try {
            Remote stub = UnicastRemoteObject.exportObject(ourRemote, 0);
            String name = remote.getClass().getSimpleName() + Integer.toHexString(stub.hashCode());
            registry.bind(name, stub);
            String id = port + "/" + name;
            System.out.println("Port/ID: " + id);
            long waitTime = 20000L;
            Object lock = new Object();
            while (true) {
                Object object = lock;
                synchronized (object) {
                    lock.wait(waitTime);
                }
                RemoteDeadHand deadHand = (RemoteDeadHand)registry.lookup("_DEAD_HAND_");
                waitTime = deadHand.ping(id);
            }
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            System.exit(1);
            return;
        }
    }

    public static void setupRMI() {
        System.setProperty("java.rmi.server.hostname", "localhost");
        System.setProperty("java.rmi.server.disableHttp", "true");
    }

    private static void banJNDI() {
        if (System.getProperty("java.naming.factory.initial") == null) {
            System.setProperty("java.naming.factory.initial", "com.intellij.execution.rmi.RemoteServer$Jndi");
        }
    }

    private static void setupSSL() {
        boolean clientKey;
        boolean caCert = System.getProperty("sslCaCertPath") != null;
        boolean clientCert = System.getProperty("sslClientCertPath") != null;
        boolean bl = clientKey = System.getProperty("sslClientKeyPath") != null;
        if (caCert || clientCert && clientKey) {
            Security.setProperty("ssl.SocketFactory.provider", "com.intellij.execution.rmi.ssl.SslSocketFactory");
        }
    }

    private static void setupDomainAuth() {
        String property = System.getProperty(DOMAIN_AUTH_LIBRARY_PATH);
        if (property != null) {
            try {
                File extracted = RemoteServer.extractLibraryFromJar(property);
                RemoteServer.setLibraryPath(extracted.getParentFile().getAbsolutePath());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static File extractLibraryFromJar(@NotNull String path) throws Exception {
        String filename;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/execution/rmi/RemoteServer", "extractLibraryFromJar"));
        }
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("The path to be absolute (start with '/').");
        }
        String[] parts = path.split("/");
        String string = filename = parts.length > 1 ? parts[parts.length - 1] : null;
        if (filename == null) {
            throw new IllegalArgumentException("The filename extracted from the path: '" + path + "' is null");
        }
        File auth = FileUtilRt.createTempDirectory("win_auth", null, true);
        File temp = new File(auth, filename);
        temp.deleteOnExit();
        if (!temp.createNewFile() || !temp.exists()) {
            throw new FileNotFoundException("File " + temp.getAbsolutePath() + " does not exist.");
        }
        byte[] buffer = new byte[5120];
        InputStream is = RemoteServer.class.getResourceAsStream(path);
        if (is == null) {
            throw new FileNotFoundException(DOMAIN_AUTH_MISSING_FILES + path);
        }
        FileOutputStream os = new FileOutputStream(temp);
        try {
            int readBytes;
            while ((readBytes = is.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, readBytes);
            }
        }
        finally {
            ((OutputStream)os).close();
            is.close();
        }
        File file = temp;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/rmi/RemoteServer", "extractLibraryFromJar"));
        }
        return file;
    }

    private static void setLibraryPath(@NotNull String path) throws NoSuchFieldException, IllegalAccessException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/execution/rmi/RemoteServer", "setLibraryPath"));
        }
        System.setProperty("java.library.path", path);
        Field fieldSysPath = ClassLoader.class.getDeclaredField("sys_paths");
        fieldSysPath.setAccessible(true);
        fieldSysPath.set(null, null);
    }

    static {
        System.setProperty("apple.awt.UIElement", "true");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Jndi
    implements InitialContextFactory,
    InvocationHandler {
        @Override
        @NotNull
        public Context getInitialContext(Hashtable<?, ?> environment) throws NamingException {
            Context context = (Context)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Context.class}, (InvocationHandler)this);
            if (context == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/rmi/RemoteServer$Jndi", "getInitialContext"));
            }
            return context;
        }

        @Override
        @Nullable
        public Object invoke(Object proxy, @NotNull Method method, Object[] args) throws Throwable {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/execution/rmi/RemoteServer$Jndi", "invoke"));
            }
            if (Object.class.equals(method.getDeclaringClass())) {
                return method.invoke((Object)this, args);
            }
            throw new NamingException("JNDI service is disabled");
        }
    }
}

