/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.extapi.psi;

import com.intellij.extapi.psi.ASTDelegatePsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.SubstrateRef;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayFactory;
import java.lang.reflect.Array;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StubBasedPsiElementBase<T extends StubElement>
extends ASTDelegatePsiElement {
    public static final Key<String> CREATION_TRACE = Key.create("CREATION_TRACE");
    public static final boolean ourTraceStubAstBinding = "true".equals(System.getProperty("trace.stub.ast.binding", "false"));
    private volatile SubstrateRef mySubstrateRef;
    private volatile int myStubIndex;
    private final IElementType myElementType;

    public StubBasedPsiElementBase(@NotNull T stub, @NotNull IStubElementType nodeType) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/extapi/psi/StubBasedPsiElementBase", "<init>"));
        }
        if (nodeType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeType", "com/intellij/extapi/psi/StubBasedPsiElementBase", "<init>"));
        }
        this.myStubIndex = -1;
        this.mySubstrateRef = new SubstrateRef.StubRef((StubElement)stub);
        this.myElementType = nodeType;
    }

    public StubBasedPsiElementBase(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/extapi/psi/StubBasedPsiElementBase", "<init>"));
        }
        this.myStubIndex = -1;
        this.mySubstrateRef = SubstrateRef.createAstStrongRef(node);
        this.myElementType = node.getElementType();
    }

    public StubBasedPsiElementBase(T stub, IElementType nodeType, ASTNode node) {
        this.myStubIndex = -1;
        if (stub != null) {
            if (nodeType == null) {
                throw new IllegalArgumentException("null cannot be passed to 'nodeType' when 'stub' is non-null");
            }
            if (node != null) {
                throw new IllegalArgumentException("null must be passed to 'node' parameter when 'stub' is non-null");
            }
            this.mySubstrateRef = new SubstrateRef.StubRef((StubElement)stub);
            this.myElementType = nodeType;
        } else {
            if (node == null) {
                throw new IllegalArgumentException("'stub' and 'node' parameters cannot be null both");
            }
            if (nodeType != null) {
                throw new IllegalArgumentException("null must be passed to 'nodeType' parameter when 'node' is non-null");
            }
            this.mySubstrateRef = SubstrateRef.createAstStrongRef(node);
            this.myElementType = node.getElementType();
        }
    }

    @Override
    @NotNull
    public ASTNode getNode() {
        if (this.mySubstrateRef instanceof SubstrateRef.StubRef) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            PsiFileImpl file = (PsiFileImpl)this.getContainingFile();
            if (!file.isValid()) {
                throw new PsiInvalidElementAccessException(this);
            }
            FileElement treeElement = file.getTreeElement();
            if (treeElement != null && this.mySubstrateRef instanceof SubstrateRef.StubRef) {
                ASTNode aSTNode = this.notBoundInExistingAst(file, treeElement);
                if (aSTNode == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/extapi/psi/StubBasedPsiElementBase", "getNode"));
                }
                return aSTNode;
            }
            treeElement = file.calcTreeElement();
            if (this.mySubstrateRef instanceof SubstrateRef.StubRef) {
                ASTNode aSTNode = this.failedToBindStubToAst(file, treeElement);
                if (aSTNode == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/extapi/psi/StubBasedPsiElementBase", "getNode"));
                }
                return aSTNode;
            }
        }
        ASTNode aSTNode = this.mySubstrateRef.getNode();
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/extapi/psi/StubBasedPsiElementBase", "getNode"));
        }
        return aSTNode;
    }

    private ASTNode failedToBindStubToAst(@NotNull PsiFileImpl file, @NotNull FileElement fileElement) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/extapi/psi/StubBasedPsiElementBase", "failedToBindStubToAst"));
        }
        if (fileElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileElement", "com/intellij/extapi/psi/StubBasedPsiElementBase", "failedToBindStubToAst"));
        }
        VirtualFile vFile = file.getVirtualFile();
        StubTree stubTree = file.getStubTree();
        String stubString = stubTree != null ? ((PsiFileStubImpl)stubTree.getRoot()).printTree() : null;
        String astString = RecursionManager.doPreventingRecursion("failedToBindStubToAst", true, () -> {
            if (fileElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileElement", "com/intellij/extapi/psi/StubBasedPsiElementBase", "lambda$failedToBindStubToAst$0"));
            }
            return DebugUtil.treeToString(fileElement, true);
        });
        String message = "Failed to bind stub to AST for element " + this.getClass() + " in " + (vFile == null ? "<unknown file>" : vFile.getPath()) + "\nFile:\n" + file + "@" + System.identityHashCode(file);
        String creationTraces = ourTraceStubAstBinding ? this.dumpCreationTraces(fileElement) : null;
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        if (stubString != null) {
            attachments.add(new Attachment("stubTree.txt", stubString));
        }
        if (astString != null) {
            attachments.add(new Attachment("ast.txt", astString));
        }
        if (creationTraces != null) {
            attachments.add(new Attachment("creationTraces.txt", creationTraces));
        }
        throw new RuntimeExceptionWithAttachments(message, attachments.toArray(Attachment.EMPTY_ARRAY));
    }

    @NotNull
    private String dumpCreationTraces(@NotNull FileElement fileElement) {
        if (fileElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileElement", "com/intellij/extapi/psi/StubBasedPsiElementBase", "dumpCreationTraces"));
        }
        final StringBuilder traces = new StringBuilder("\nNow " + Thread.currentThread() + "\n");
        traces.append("My creation trace:\n").append(this.getUserData(CREATION_TRACE));
        traces.append("AST creation traces:\n");
        fileElement.acceptTree(new RecursiveTreeElementWalkingVisitor(false){

            @Override
            public void visitComposite(CompositeElement composite) {
                PsiElement psi = composite.getPsi();
                if (psi != null) {
                    traces.append(psi).append("@").append(System.identityHashCode(psi)).append("\n");
                    String trace = psi.getUserData(CREATION_TRACE);
                    if (trace != null) {
                        traces.append(trace).append("\n");
                    }
                }
                super.visitComposite(composite);
            }
        });
        String string = traces.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/extapi/psi/StubBasedPsiElementBase", "dumpCreationTraces"));
        }
        return string;
    }

    private ASTNode notBoundInExistingAst(@NotNull PsiFileImpl file, @NotNull FileElement treeElement) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/extapi/psi/StubBasedPsiElementBase", "notBoundInExistingAst"));
        }
        if (treeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeElement", "com/intellij/extapi/psi/StubBasedPsiElementBase", "notBoundInExistingAst"));
        }
        String message = "file=" + file + "; tree=" + treeElement;
        for (PsiElement each = this; each != null; each = each.getParentByStub()) {
            message = message + "\n each of class " + each.getClass() + "; valid=" + each.isValid();
            if (each instanceof StubBasedPsiElementBase) {
                message = message + "; ref=" + each.mySubstrateRef;
                continue;
            }
            if (!(each instanceof PsiFile)) break;
            message = message + "; same file=" + (each == file) + "; current tree= " + file.getTreeElement() + "; stubTree=" + file.getStubTree() + "; physical=" + file.isPhysical();
            break;
        }
        for (Object eachStub = this.getStub(); eachStub != null; eachStub = eachStub.getParentStub()) {
            message = message + "\n each stub " + (eachStub instanceof PsiFileStubImpl ? ((PsiFileStubImpl)eachStub).getDiagnostics() : eachStub);
        }
        if (ourTraceStubAstBinding) {
            message = message + this.dumpCreationTraces(treeElement);
        }
        throw new AssertionError((Object)message);
    }

    public final void setNode(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/extapi/psi/StubBasedPsiElementBase", "setNode"));
        }
        this.mySubstrateRef = SubstrateRef.createAstStrongRef(node);
    }

    public final void setSubstrateRef(@NotNull SubstrateRef substrateRef) {
        if (substrateRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substrateRef", "com/intellij/extapi/psi/StubBasedPsiElementBase", "setSubstrateRef"));
        }
        this.mySubstrateRef = substrateRef;
        this.myStubIndex = -1;
    }

    public final void setStubIndex(int stubIndex) {
        this.myStubIndex = stubIndex;
    }

    public int getStubIndex() {
        return this.myStubIndex;
    }

    @NotNull
    public final SubstrateRef getSubstrateRef() {
        SubstrateRef substrateRef = this.mySubstrateRef;
        if (substrateRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/extapi/psi/StubBasedPsiElementBase", "getSubstrateRef"));
        }
        return substrateRef;
    }

    @Override
    @NotNull
    public Language getLanguage() {
        Language language = this.myElementType.getLanguage();
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/extapi/psi/StubBasedPsiElementBase", "getLanguage"));
        }
        return language;
    }

    @Override
    @NotNull
    public PsiFile getContainingFile() {
        PsiFile psiFile;
        try {
            psiFile = this.mySubstrateRef.getContainingFile();
        }
        catch (PsiInvalidElementAccessException e) {
            if (PsiInvalidElementAccessException.getInvalidationTrace(this) != null) {
                throw new PsiInvalidElementAccessException((PsiElement)this, (Throwable)e);
            }
            throw e;
        }
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/extapi/psi/StubBasedPsiElementBase", "getContainingFile"));
        }
        return psiFile;
    }

    @Override
    public boolean isWritable() {
        return this.getContainingFile().isWritable();
    }

    @Override
    public boolean isValid() {
        return this.mySubstrateRef.isValid();
    }

    @Override
    public PsiManagerEx getManager() {
        Project project = ProjectCoreUtil.theOnlyOpenProject();
        if (project != null) {
            return PsiManagerEx.getInstanceEx(project);
        }
        return (PsiManagerEx)this.getContainingFile().getManager();
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = ProjectCoreUtil.theOnlyOpenProject();
        if (project != null) {
            Project project2 = project;
            if (project2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/extapi/psi/StubBasedPsiElementBase", "getProject"));
            }
            return project2;
        }
        Project project3 = this.getContainingFile().getProject();
        if (project3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/extapi/psi/StubBasedPsiElementBase", "getProject"));
        }
        return project3;
    }

    @Override
    public boolean isPhysical() {
        return this.getContainingFile().isPhysical();
    }

    @Override
    public PsiElement getContext() {
        T stub = this.getStub();
        if (stub != null && !(stub instanceof PsiFileStub)) {
            return stub.getParentStub().getPsi();
        }
        return super.getContext();
    }

    protected final PsiElement getParentByStub() {
        T stub = this.getStub();
        if (stub != null) {
            return stub.getParentStub().getPsi();
        }
        return SharedImplUtil.getParent(this.getNode());
    }

    @Deprecated
    protected final PsiElement getParentByTree() {
        return SharedImplUtil.getParent(this.getNode());
    }

    @Override
    public PsiElement getParent() {
        T stub = this.getGreenStub();
        if (stub != null && !((ObjectStubBase)stub).isDangling()) {
            return stub.getParentStub().getPsi();
        }
        return SharedImplUtil.getParent(this.getNode());
    }

    @NotNull
    public IStubElementType getElementType() {
        if (!(this.myElementType instanceof IStubElementType)) {
            throw new ClassCastException("Not a stub type: " + this.myElementType + " in " + this.getClass());
        }
        IStubElementType iStubElementType = (IStubElementType)this.myElementType;
        if (iStubElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/extapi/psi/StubBasedPsiElementBase", "getElementType"));
        }
        return iStubElementType;
    }

    @Nullable
    public T getStub() {
        ProgressIndicatorProvider.checkCanceled();
        return (T)((StubElement)this.mySubstrateRef.getStub(this.myStubIndex));
    }

    @Nullable
    public final T getGreenStub() {
        ProgressIndicatorProvider.checkCanceled();
        return (T)((StubElement)this.mySubstrateRef.getGreenStub(this.myStubIndex));
    }

    @Nullable
    public <Psi extends PsiElement> Psi getStubOrPsiChild(@NotNull IStubElementType<? extends StubElement, Psi> elementType) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/extapi/psi/StubBasedPsiElementBase", "getStubOrPsiChild"));
        }
        T stub = this.getGreenStub();
        if (stub != null) {
            StubElement<Psi> element = stub.findChildStubByType(elementType);
            if (element != null) {
                return element.getPsi();
            }
        } else {
            ASTNode childNode = this.getNode().findChildByType(elementType);
            if (childNode != null) {
                return (Psi)childNode.getPsi();
            }
        }
        return null;
    }

    @NotNull
    public <S extends StubElement, Psi extends PsiElement> Psi getRequiredStubOrPsiChild(@NotNull IStubElementType<S, Psi> elementType) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/extapi/psi/StubBasedPsiElementBase", "getRequiredStubOrPsiChild"));
        }
        Psi result = this.getStubOrPsiChild(elementType);
        assert (result != null) : "Missing required child of type " + elementType + "; tree: " + DebugUtil.psiToString(this, false);
        Psi Psi = result;
        if (Psi == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/extapi/psi/StubBasedPsiElementBase", "getRequiredStubOrPsiChild"));
        }
        return Psi;
    }

    @NotNull
    public <S extends StubElement, Psi extends PsiElement> Psi[] getStubOrPsiChildren(@NotNull IStubElementType<S, ? extends Psi> elementType, @NotNull Psi[] array) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/extapi/psi/StubBasedPsiElementBase", "getStubOrPsiChildren"));
        }
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/extapi/psi/StubBasedPsiElementBase", "getStubOrPsiChildren"));
        }
        T stub = this.getGreenStub();
        if (stub != null) {
            PsiElement[] psiElementArray = stub.getChildrenByType(elementType, array);
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/extapi/psi/StubBasedPsiElementBase", "getStubOrPsiChildren"));
            }
            return psiElementArray;
        }
        ASTNode[] nodes = SharedImplUtil.getChildrenOfType(this.getNode(), elementType);
        PsiElement[] psiElements = (PsiElement[])Array.newInstance(array.getClass().getComponentType(), nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            psiElements[i] = nodes[i].getPsi();
        }
        if (psiElements == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/extapi/psi/StubBasedPsiElementBase", "getStubOrPsiChildren"));
        }
        return psiElements;
    }

    @NotNull
    public <S extends StubElement, Psi extends PsiElement> Psi[] getStubOrPsiChildren(@NotNull IStubElementType<S, ? extends Psi> elementType, @NotNull ArrayFactory<Psi> f) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/extapi/psi/StubBasedPsiElementBase", "getStubOrPsiChildren"));
        }
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/extapi/psi/StubBasedPsiElementBase", "getStubOrPsiChildren"));
        }
        T stub = this.getGreenStub();
        if (stub != null) {
            PsiElement[] psiElementArray = stub.getChildrenByType(elementType, f);
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/extapi/psi/StubBasedPsiElementBase", "getStubOrPsiChildren"));
            }
            return psiElementArray;
        }
        ASTNode[] nodes = SharedImplUtil.getChildrenOfType(this.getNode(), elementType);
        PsiElement[] psiElements = (PsiElement[])f.create(nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            psiElements[i] = nodes[i].getPsi();
        }
        if (psiElements == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/extapi/psi/StubBasedPsiElementBase", "getStubOrPsiChildren"));
        }
        return psiElements;
    }

    @NotNull
    public <Psi extends PsiElement> Psi[] getStubOrPsiChildren(@NotNull TokenSet filter, @NotNull Psi[] array) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/extapi/psi/StubBasedPsiElementBase", "getStubOrPsiChildren"));
        }
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/extapi/psi/StubBasedPsiElementBase", "getStubOrPsiChildren"));
        }
        T stub = this.getGreenStub();
        if (stub != null) {
            PsiElement[] psiElementArray = stub.getChildrenByType(filter, array);
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/extapi/psi/StubBasedPsiElementBase", "getStubOrPsiChildren"));
            }
            return psiElementArray;
        }
        ASTNode[] nodes = this.getNode().getChildren(filter);
        PsiElement[] psiElements = (PsiElement[])Array.newInstance(array.getClass().getComponentType(), nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            psiElements[i] = nodes[i].getPsi();
        }
        if (psiElements == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/extapi/psi/StubBasedPsiElementBase", "getStubOrPsiChildren"));
        }
        return psiElements;
    }

    @NotNull
    public <Psi extends PsiElement> Psi[] getStubOrPsiChildren(@NotNull TokenSet filter, @NotNull ArrayFactory<Psi> f) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/extapi/psi/StubBasedPsiElementBase", "getStubOrPsiChildren"));
        }
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/extapi/psi/StubBasedPsiElementBase", "getStubOrPsiChildren"));
        }
        T stub = this.getGreenStub();
        if (stub != null) {
            PsiElement[] psiElementArray = stub.getChildrenByType(filter, f);
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/extapi/psi/StubBasedPsiElementBase", "getStubOrPsiChildren"));
            }
            return psiElementArray;
        }
        ASTNode[] nodes = this.getNode().getChildren(filter);
        PsiElement[] psiElements = (PsiElement[])f.create(nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            psiElements[i] = nodes[i].getPsi();
        }
        if (psiElements == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/extapi/psi/StubBasedPsiElementBase", "getStubOrPsiChildren"));
        }
        return psiElements;
    }

    @Nullable
    protected <E extends PsiElement> E getStubOrPsiParentOfType(@NotNull Class<E> parentClass) {
        if (parentClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentClass", "com/intellij/extapi/psi/StubBasedPsiElementBase", "getStubOrPsiParentOfType"));
        }
        T stub = this.getStub();
        if (stub != null) {
            return stub.getParentStubOfType(parentClass);
        }
        return PsiTreeUtil.getParentOfType((PsiElement)this, parentClass);
    }

    @Override
    protected Object clone() {
        StubBasedPsiElementBase copy = (StubBasedPsiElementBase)super.clone();
        copy.mySubstrateRef = SubstrateRef.createAstStrongRef(this.getNode());
        return copy;
    }
}

