/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeFoldingBuilder
extends FoldingBuilderEx
implements PossiblyDumbAware {
    public static final Key<FoldingBuilder> FOLDING_BUILDER = new Key("FOLDING_BUILDER");
    private final List<FoldingBuilder> myBuilders;

    CompositeFoldingBuilder(List<FoldingBuilder> builders) {
        this.myBuilders = builders;
    }

    @NotNull
    public List<FoldingBuilder> getAllBuilders() {
        List<FoldingBuilder> list = Collections.unmodifiableList(this.myBuilders);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/folding/CompositeFoldingBuilder", "getAllBuilders"));
        }
        return list;
    }

    @Override
    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/lang/folding/CompositeFoldingBuilder", "buildFoldRegions"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/folding/CompositeFoldingBuilder", "buildFoldRegions"));
        }
        ArrayList<FoldingDescriptor> descriptors = new ArrayList<FoldingDescriptor>();
        HashSet rangesCoveredByDescriptors = ContainerUtil.newHashSet();
        for (FoldingBuilder builder : DumbService.getInstance(root.getProject()).filterByDumbAwareness(this.myBuilders)) {
            for (FoldingDescriptor descriptor : LanguageFolding.buildFoldingDescriptors(builder, root, document, quick)) {
                if (!rangesCoveredByDescriptors.add(descriptor.getRange())) continue;
                descriptor.getElement().putUserData(FOLDING_BUILDER, builder);
                descriptors.add(descriptor);
            }
        }
        FoldingDescriptor[] foldingDescriptorArray = descriptors.toArray(new FoldingDescriptor[descriptors.size()]);
        if (foldingDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/folding/CompositeFoldingBuilder", "buildFoldRegions"));
        }
        return foldingDescriptorArray;
    }

    @Override
    public String getPlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/folding/CompositeFoldingBuilder", "getPlaceholderText"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/lang/folding/CompositeFoldingBuilder", "getPlaceholderText"));
        }
        FoldingBuilder builder = node.getUserData(FOLDING_BUILDER);
        return !CompositeFoldingBuilder.mayUseBuilder(node, builder) ? node.getText() : (builder instanceof FoldingBuilderEx ? ((FoldingBuilderEx)builder).getPlaceholderText(node, range) : builder.getPlaceholderText(node));
    }

    @Override
    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/folding/CompositeFoldingBuilder", "getPlaceholderText"));
        }
        FoldingBuilder builder = node.getUserData(FOLDING_BUILDER);
        return !CompositeFoldingBuilder.mayUseBuilder(node, builder) ? node.getText() : builder.getPlaceholderText(node);
    }

    @Override
    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/folding/CompositeFoldingBuilder", "isCollapsedByDefault"));
        }
        FoldingBuilder builder = node.getUserData(FOLDING_BUILDER);
        return CompositeFoldingBuilder.mayUseBuilder(node, builder) && builder.isCollapsedByDefault(node);
    }

    private static boolean mayUseBuilder(@NotNull ASTNode node, @Nullable FoldingBuilder builder) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/folding/CompositeFoldingBuilder", "mayUseBuilder"));
        }
        if (builder == null) {
            return false;
        }
        if (DumbService.isDumbAware(builder)) {
            return true;
        }
        Project project = CompositeFoldingBuilder.getProjectByNode(node);
        return project == null || !DumbService.isDumb(project);
    }

    @Nullable
    private static Project getProjectByNode(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/folding/CompositeFoldingBuilder", "getProjectByNode"));
        }
        PsiElement psi = node.getPsi();
        if (psi == null) {
            ASTNode parent = node.getTreeParent();
            psi = parent == null ? null : parent.getPsi();
        }
        return psi == null ? null : psi.getProject();
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.myBuilders;
    }

    @Override
    public boolean isDumbAware() {
        for (FoldingBuilder builder : this.myBuilders) {
            if (!DumbService.isDumbAware(builder)) continue;
            return true;
        }
        return false;
    }
}

