/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.util.TypesDistinctProver;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericsUtil {
    private static final Logger LOG = Logger.getInstance("#" + GenericsUtil.class.getName());

    private GenericsUtil() {
    }

    public static PsiType getGreatestLowerBound(@Nullable PsiType type1, @Nullable PsiType type2) {
        if (type1 == null || type2 == null) {
            return null;
        }
        return PsiIntersectionType.createIntersection(type1, type2);
    }

    @Nullable
    public static PsiType getLeastUpperBound(PsiType type1, PsiType type2, PsiManager manager) {
        if (TypeConversionUtil.isPrimitiveAndNotNull(type1) || TypeConversionUtil.isPrimitiveAndNotNull(type2)) {
            return null;
        }
        if (TypeConversionUtil.isNullType(type1)) {
            return type2;
        }
        if (TypeConversionUtil.isNullType(type2)) {
            return type1;
        }
        if (Comparing.equal(type1, type2)) {
            return type1;
        }
        return GenericsUtil.getLeastUpperBound(type1, type2, new LinkedHashSet<Couple<PsiType>>(), manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static PsiType getLeastUpperBound(PsiType type1, PsiType type2, Set<Couple<PsiType>> compared, PsiManager manager) {
        if (type1 instanceof PsiCapturedWildcardType) {
            PsiType psiType = GenericsUtil.getLeastUpperBound(((PsiCapturedWildcardType)type1).getUpperBound(), type2, compared, manager);
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/GenericsUtil", "getLeastUpperBound"));
            }
            return psiType;
        }
        if (type2 instanceof PsiCapturedWildcardType) {
            PsiType psiType = GenericsUtil.getLeastUpperBound(type1, ((PsiCapturedWildcardType)type2).getUpperBound(), compared, manager);
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/GenericsUtil", "getLeastUpperBound"));
            }
            return psiType;
        }
        if (type1 instanceof PsiWildcardType) {
            PsiType psiType = GenericsUtil.getLeastUpperBound(((PsiWildcardType)type1).getExtendsBound(), type2, compared, manager);
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/GenericsUtil", "getLeastUpperBound"));
            }
            return psiType;
        }
        if (type2 instanceof PsiWildcardType) {
            PsiType psiType = GenericsUtil.getLeastUpperBound(type1, ((PsiWildcardType)type2).getExtendsBound(), compared, manager);
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/GenericsUtil", "getLeastUpperBound"));
            }
            return psiType;
        }
        if (type1 instanceof PsiArrayType && type2 instanceof PsiArrayType) {
            PsiType componentType1 = ((PsiArrayType)type1).getComponentType();
            PsiType componentType2 = ((PsiArrayType)type2).getComponentType();
            PsiType componentType = GenericsUtil.getLeastUpperBound(componentType1, componentType2, compared, manager);
            if (componentType1 instanceof PsiPrimitiveType && componentType2 instanceof PsiPrimitiveType && componentType.equalsToText("java.lang.Object")) {
                PsiElementFactory factory = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory();
                GlobalSearchScope resolveScope = GlobalSearchScope.allScope(manager.getProject());
                PsiClassType cloneable = factory.createTypeByFQClassName("java.lang.Cloneable", resolveScope);
                PsiClassType serializable = factory.createTypeByFQClassName("java.io.Serializable", resolveScope);
                PsiType psiType = PsiIntersectionType.createIntersection(componentType, cloneable, serializable);
                if (psiType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/GenericsUtil", "getLeastUpperBound"));
                }
                return psiType;
            }
            PsiArrayType psiArrayType = componentType.createArrayType();
            if (psiArrayType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/GenericsUtil", "getLeastUpperBound"));
            }
            return psiArrayType;
        }
        if (type1 instanceof PsiIntersectionType) {
            PsiType[] conjuncts;
            LinkedHashSet<PsiType> newConjuncts = new LinkedHashSet<PsiType>();
            for (PsiType type : conjuncts = ((PsiIntersectionType)type1).getConjuncts()) {
                newConjuncts.add(GenericsUtil.getLeastUpperBound(type, type2, compared, manager));
            }
            PsiType psiType = PsiIntersectionType.createIntersection(newConjuncts.toArray(PsiType.createArray(newConjuncts.size())));
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/GenericsUtil", "getLeastUpperBound"));
            }
            return psiType;
        }
        if (type2 instanceof PsiIntersectionType) {
            PsiType psiType = GenericsUtil.getLeastUpperBound(type2, type1, compared, manager);
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/GenericsUtil", "getLeastUpperBound"));
            }
            return psiType;
        }
        if (type1 instanceof PsiClassType && type2 instanceof PsiClassType) {
            PsiClassType.ClassResolveResult classResolveResult1 = ((PsiClassType)type1).resolveGenerics();
            PsiClassType.ClassResolveResult classResolveResult2 = ((PsiClassType)type2).resolveGenerics();
            PsiClass aClass = classResolveResult1.getElement();
            PsiClass bClass = classResolveResult2.getElement();
            if (aClass == null || bClass == null) {
                PsiClassType psiClassType = PsiType.getJavaLangObject(manager, GlobalSearchScope.allScope(manager.getProject()));
                if (psiClassType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/GenericsUtil", "getLeastUpperBound"));
                }
                return psiClassType;
            }
            PsiClass[] supers = GenericsUtil.getLeastUpperClasses(aClass, bClass);
            if (supers.length == 0) {
                PsiClassType psiClassType = PsiType.getJavaLangObject(manager, aClass.getResolveScope());
                if (psiClassType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/GenericsUtil", "getLeastUpperBound"));
                }
                return psiClassType;
            }
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory();
            PsiType[] conjuncts = new PsiClassType[supers.length];
            for (int i = 0; i < supers.length; ++i) {
                PsiClass aSuper = supers[i];
                PsiSubstitutor subst1 = TypeConversionUtil.getSuperClassSubstitutor(aSuper, aClass, classResolveResult1.getSubstitutor());
                PsiSubstitutor subst2 = TypeConversionUtil.getSuperClassSubstitutor(aSuper, bClass, classResolveResult2.getSubstitutor());
                PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
                Couple<PsiClassType> types = Couple.of(elementFactory.createType(aSuper, subst1), elementFactory.createType(aSuper, subst2));
                for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(aSuper)) {
                    PsiType mapping1 = subst1.substitute(parameter);
                    PsiType mapping2 = subst2.substitute(parameter);
                    if (mapping1 != null && mapping2 != null) {
                        if (compared.contains(types)) {
                            substitutor = substitutor.put(parameter, PsiWildcardType.createUnbounded(manager));
                            continue;
                        }
                        compared.add(types);
                        try {
                            substitutor = substitutor.put(parameter, GenericsUtil.getLeastContainingTypeArgument(mapping1, mapping2, compared, manager));
                            continue;
                        }
                        finally {
                            compared.remove(types);
                            continue;
                        }
                    }
                    substitutor = substitutor.put(parameter, null);
                }
                conjuncts[i] = elementFactory.createType(aSuper, substitutor);
            }
            PsiType psiType = PsiIntersectionType.createIntersection(conjuncts);
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/GenericsUtil", "getLeastUpperBound"));
            }
            return psiType;
        }
        if (type2 instanceof PsiArrayType && !(type1 instanceof PsiArrayType)) {
            PsiType psiType = GenericsUtil.getLeastUpperBound(type2, type1, compared, manager);
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/GenericsUtil", "getLeastUpperBound"));
            }
            return psiType;
        }
        if (type1 instanceof PsiArrayType) {
            PsiElementFactory factory = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory();
            GlobalSearchScope all = GlobalSearchScope.allScope(manager.getProject());
            PsiClassType serializable = factory.createTypeByFQClassName("java.io.Serializable", all);
            PsiClassType cloneable = factory.createTypeByFQClassName("java.lang.Cloneable", all);
            PsiType arraySupers = PsiIntersectionType.createIntersection(serializable, cloneable);
            PsiType psiType = GenericsUtil.getLeastUpperBound(arraySupers, type2, compared, manager);
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/GenericsUtil", "getLeastUpperBound"));
            }
            return psiType;
        }
        PsiClassType psiClassType = PsiType.getJavaLangObject(manager, GlobalSearchScope.allScope(manager.getProject()));
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/GenericsUtil", "getLeastUpperBound"));
        }
        return psiClassType;
    }

    private static PsiType getLeastContainingTypeArgument(PsiType type1, PsiType type2, Set<Couple<PsiType>> compared, PsiManager manager) {
        if (type1 instanceof PsiWildcardType) {
            PsiWildcardType wild1 = (PsiWildcardType)type1;
            PsiType bound1 = wild1.getBound();
            if (bound1 == null) {
                return type1;
            }
            if (type2 instanceof PsiWildcardType) {
                PsiWildcardType wild2 = (PsiWildcardType)type2;
                PsiType bound2 = wild2.getBound();
                if (bound2 == null) {
                    return type2;
                }
                if (wild1.isExtends() == wild2.isExtends()) {
                    return wild1.isExtends() ? PsiWildcardType.createExtends(manager, GenericsUtil.getLeastUpperBound(bound1, bound2, compared, manager)) : PsiWildcardType.createSuper(manager, GenericsUtil.getGreatestLowerBound(bound1, bound2));
                }
                return bound1.equals(bound2) ? bound1 : PsiWildcardType.createUnbounded(manager);
            }
            return wild1.isExtends() ? PsiWildcardType.createExtends(manager, GenericsUtil.getLeastUpperBound(bound1, type2, compared, manager)) : (wild1.isSuper() ? PsiWildcardType.createSuper(manager, GenericsUtil.getGreatestLowerBound(bound1, type2)) : wild1);
        }
        if (type2 instanceof PsiWildcardType) {
            return GenericsUtil.getLeastContainingTypeArgument(type2, type1, compared, manager);
        }
        if (type1.equals(type2)) {
            return type1;
        }
        return PsiWildcardType.createExtends(manager, GenericsUtil.getLeastUpperBound(type1, type2, compared, manager));
    }

    @NotNull
    public static PsiClass[] getLeastUpperClasses(PsiClass aClass, PsiClass bClass) {
        if (InheritanceUtil.isInheritorOrSelf(aClass, bClass, true)) {
            PsiClass[] psiClassArray = new PsiClass[]{bClass};
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/GenericsUtil", "getLeastUpperClasses"));
            }
            return psiClassArray;
        }
        LinkedHashSet<PsiClass> supers = new LinkedHashSet<PsiClass>();
        HashSet<PsiClass> visited = new HashSet<PsiClass>();
        GenericsUtil.getLeastUpperClassesInner(aClass, bClass, supers, visited);
        PsiClass[] psiClassArray = supers.toArray(new PsiClass[supers.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/GenericsUtil", "getLeastUpperClasses"));
        }
        return psiClassArray;
    }

    private static void getLeastUpperClassesInner(PsiClass aClass, PsiClass bClass, Set<PsiClass> supers, Set<PsiClass> visited) {
        if (bClass.isInheritor(aClass, true)) {
            GenericsUtil.addSuper(supers, aClass);
        } else {
            PsiClass[] aSupers;
            for (PsiClass aSuper : aSupers = aClass.getSupers()) {
                if (!visited.add(aSuper)) continue;
                GenericsUtil.getLeastUpperClassesInner(aSuper, bClass, supers, visited);
            }
        }
    }

    private static void addSuper(Set<PsiClass> supers, PsiClass classToAdd) {
        Iterator<PsiClass> iterator = supers.iterator();
        while (iterator.hasNext()) {
            PsiClass superClass = iterator.next();
            if (InheritanceUtil.isInheritorOrSelf(superClass, classToAdd, true)) {
                return;
            }
            if (!classToAdd.isInheritor(superClass, true)) continue;
            iterator.remove();
        }
        supers.add(classToAdd);
    }

    public static boolean isTypeArgumentsApplicable(PsiTypeParameter[] typeParams, PsiSubstitutor substitutor, PsiElement context) {
        return GenericsUtil.isTypeArgumentsApplicable(typeParams, substitutor, context, true);
    }

    public static boolean isTypeArgumentsApplicable(PsiTypeParameter[] typeParams, PsiSubstitutor substitutor, PsiElement context, boolean allowUncheckedConversion) {
        return GenericsUtil.findTypeParameterWithBoundError(typeParams, substitutor, context, allowUncheckedConversion) == null;
    }

    public static Pair<PsiTypeParameter, PsiType> findTypeParameterWithBoundError(PsiTypeParameter[] typeParams, PsiSubstitutor substitutor, PsiElement context, boolean allowUncheckedConversion) {
        for (PsiTypeParameter typeParameter : typeParams) {
            PsiType boundError = GenericsUtil.findTypeParameterBoundError(typeParameter, typeParameter.getExtendsListTypes(), substitutor, context, allowUncheckedConversion);
            if (boundError == null) continue;
            return Pair.create(typeParameter, boundError);
        }
        return null;
    }

    public static PsiType findTypeParameterBoundError(PsiTypeParameter typeParameter, PsiType[] extendsTypes, PsiSubstitutor substitutor, PsiElement context, boolean allowUncheckedConversion) {
        PsiType substituted = substitutor.substitute(typeParameter);
        if (substituted == null) {
            return null;
        }
        if (context != null) {
            substituted = PsiUtil.captureToplevelWildcards(substituted, context);
        }
        if (substituted instanceof PsiWildcardType && ((PsiWildcardType)substituted).isSuper()) {
            return null;
        }
        for (PsiType type : extendsTypes) {
            PsiType extendsType = substitutor.substitute(type);
            if (extendsType == null || TypeConversionUtil.isAssignable(extendsType, substituted, allowUncheckedConversion)) continue;
            return extendsType;
        }
        return null;
    }

    public static boolean isFromExternalTypeLanguage(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/GenericsUtil", "isFromExternalTypeLanguage"));
        }
        return type.getInternalCanonicalText().equals(type.getCanonicalText());
    }

    @Contract(value="null -> null")
    public static PsiType getVariableTypeByExpressionType(@Nullable PsiType type) {
        return GenericsUtil.getVariableTypeByExpressionType(type, true);
    }

    @Contract(value="null, _ -> null")
    public static PsiType getVariableTypeByExpressionType(@Nullable PsiType type, final boolean openCaptured) {
        PsiType transformed;
        PsiType componentType;
        if (type == null) {
            return null;
        }
        if (type instanceof PsiCapturedWildcardType) {
            type = ((PsiCapturedWildcardType)type).getUpperBound();
        }
        PsiType psiType = componentType = (transformed = type.accept(new PsiTypeVisitor<PsiType>(){

            @Override
            public PsiType visitArrayType(PsiArrayType arrayType) {
                PsiType componentType = arrayType.getComponentType();
                PsiType type = componentType.accept(this);
                if (type == componentType) {
                    return arrayType;
                }
                if (type instanceof PsiWildcardType) {
                    type = ((PsiWildcardType)type).getBound();
                }
                return type != null ? type.createArrayType() : arrayType;
            }

            @Override
            public PsiType visitType(PsiType type) {
                return type;
            }

            @Override
            public PsiType visitWildcardType(PsiWildcardType wildcardType) {
                PsiType bound = wildcardType.getBound();
                PsiManager manager = wildcardType.getManager();
                if (bound != null) {
                    if (wildcardType.isSuper() && bound instanceof PsiIntersectionType) {
                        return PsiWildcardType.createUnbounded(manager);
                    }
                    PsiType acceptedBound = bound.accept(this);
                    if (acceptedBound instanceof PsiWildcardType) {
                        if (((PsiWildcardType)acceptedBound).isExtends() != wildcardType.isExtends()) {
                            return PsiWildcardType.createUnbounded(manager);
                        }
                        return acceptedBound;
                    }
                    if (wildcardType.isExtends() && acceptedBound.equalsToText("java.lang.Object")) {
                        return PsiWildcardType.createUnbounded(manager);
                    }
                    if (acceptedBound.equals(bound)) {
                        return wildcardType;
                    }
                    return wildcardType.isExtends() ? PsiWildcardType.createExtends(manager, acceptedBound) : PsiWildcardType.createSuper(manager, acceptedBound);
                }
                return wildcardType;
            }

            @Override
            public PsiType visitCapturedWildcardType(PsiCapturedWildcardType capturedWildcardType) {
                return openCaptured ? capturedWildcardType.getWildcard().accept(this) : capturedWildcardType;
            }

            @Override
            public PsiType visitClassType(PsiClassType classType) {
                PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
                PsiClass aClass = resolveResult.getElement();
                if (aClass == null) {
                    return classType;
                }
                boolean toExtend = false;
                PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
                for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(aClass)) {
                    PsiType toPut;
                    PsiType typeArgument = resolveResult.getSubstitutor().substitute(typeParameter);
                    if (typeArgument instanceof PsiCapturedWildcardType) {
                        toExtend = true;
                    }
                    if (typeArgument instanceof PsiWildcardType && ((PsiWildcardType)typeArgument).getBound() instanceof PsiIntersectionType) {
                        toExtend = true;
                    }
                    if (typeArgument == null) {
                        toPut = null;
                    } else {
                        PsiType accepted = typeArgument.accept(this);
                        toPut = typeArgument instanceof PsiIntersectionType && !(accepted instanceof PsiWildcardType) ? PsiWildcardType.createExtends(typeParameter.getManager(), accepted) : accepted;
                    }
                    LOG.assertTrue(toPut == null || toPut.isValid(), toPut);
                    substitutor = substitutor.put(typeParameter, toPut);
                }
                PsiAnnotation[] applicableAnnotations = classType.getApplicableAnnotations();
                if (substitutor == PsiSubstitutor.EMPTY && !toExtend && applicableAnnotations.length == 0 && !(aClass instanceof PsiTypeParameter)) {
                    return classType;
                }
                PsiManager manager = aClass.getManager();
                PsiType result = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory().createType(aClass, substitutor, PsiUtil.getLanguageLevel(aClass)).annotate(TypeAnnotationProvider.Static.create(applicableAnnotations));
                if (toExtend) {
                    result = PsiWildcardType.createExtends(manager, result);
                }
                return result;
            }
        })) != null ? transformed.getDeepComponentType() : null;
        if (componentType instanceof PsiWildcardType) {
            componentType = ((PsiWildcardType)componentType).getExtendsBound();
            int dims = transformed.getArrayDimensions();
            for (int i = 0; i < dims; ++i) {
                componentType = componentType.createArrayType();
            }
            return componentType;
        }
        return transformed;
    }

    public static PsiSubstitutor substituteByParameterName(PsiClass psiClass, PsiSubstitutor parentSubstitutor) {
        Map<PsiTypeParameter, PsiType> substitutionMap = parentSubstitutor.getSubstitutionMap();
        ArrayList<PsiType> result = new ArrayList<PsiType>(substitutionMap.size());
        for (PsiTypeParameter typeParameter : psiClass.getTypeParameters()) {
            String name = typeParameter.getName();
            PsiTypeParameter key = (PsiTypeParameter)((Object)ContainerUtil.find(substitutionMap.keySet(), psiTypeParameter -> name.equals(psiTypeParameter.getName())));
            if (key == null) continue;
            result.add(substitutionMap.get(key));
        }
        return PsiSubstitutor.EMPTY.putAll(psiClass, result.toArray(PsiType.createArray(result.size())));
    }

    public static PsiType eliminateWildcards(PsiType type) {
        return GenericsUtil.eliminateWildcards(type, true);
    }

    public static PsiType eliminateWildcards(PsiType type, boolean eliminateInTypeArguments) {
        return GenericsUtil.eliminateWildcards(type, eliminateInTypeArguments, !eliminateInTypeArguments);
    }

    public static PsiType eliminateWildcards(PsiType type, boolean eliminateInTypeArguments, boolean eliminateCapturedWildcards) {
        if (eliminateInTypeArguments && type instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)type;
            PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
            PsiClass aClass = (PsiClass)resolveResult.getElement();
            if (aClass != null) {
                PsiManager manager = aClass.getManager();
                PsiTypeParameter[] typeParams = aClass.getTypeParameters();
                HashMap<PsiTypeParameter, PsiType> map = new HashMap<PsiTypeParameter, PsiType>();
                for (PsiTypeParameter typeParam : typeParams) {
                    PsiType substituted = resolveResult.getSubstitutor().substitute(typeParam);
                    if (substituted instanceof PsiWildcardType) {
                        if ((substituted = ((PsiWildcardType)substituted).getBound()) instanceof PsiCapturedWildcardType) {
                            substituted = ((PsiCapturedWildcardType)substituted).getWildcard().getBound();
                        }
                        if (substituted == null) {
                            substituted = TypeConversionUtil.typeParameterErasure(typeParam);
                        }
                    }
                    map.put(typeParam, substituted);
                }
                PsiElementFactory factory = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory();
                PsiSubstitutor substitutor = factory.createSubstitutor(map);
                type = factory.createType(aClass, substitutor);
            }
        } else {
            if (type instanceof PsiArrayType) {
                return GenericsUtil.eliminateWildcards(((PsiArrayType)type).getComponentType(), false).createArrayType();
            }
            if (type instanceof PsiWildcardType) {
                PsiType bound = ((PsiWildcardType)type).getBound();
                return GenericsUtil.eliminateWildcards(bound != null ? bound : ((PsiWildcardType)type).getExtendsBound(), false);
            }
            if (type instanceof PsiCapturedWildcardType && eliminateCapturedWildcards) {
                return GenericsUtil.eliminateWildcards(((PsiCapturedWildcardType)type).getUpperBound(), false);
            }
        }
        return type;
    }

    public static boolean checkNotInBounds(PsiType type, PsiType bound, PsiReferenceParameterList referenceParameterList) {
        return GenericsUtil.checkNotInBounds(type, bound, PsiTreeUtil.getParentOfType((PsiElement)referenceParameterList, PsiCallExpression.class) != null);
    }

    public static boolean checkNotInBounds(PsiType type, PsiType bound, boolean uncheckedConversionByDefault) {
        if (type instanceof PsiClassType) {
            return GenericsUtil.checkNotAssignable(bound, type, uncheckedConversionByDefault);
        }
        if (type instanceof PsiWildcardType) {
            if (((PsiWildcardType)type).isExtends()) {
                return GenericsUtil.checkExtendsWildcardCaptureFailure((PsiWildcardType)type, bound);
            }
            if (((PsiWildcardType)type).isSuper()) {
                PsiType superBound = ((PsiWildcardType)type).getSuperBound();
                if (PsiUtil.resolveClassInType(superBound) instanceof PsiTypeParameter) {
                    return TypesDistinctProver.provablyDistinct(type, bound);
                }
                return GenericsUtil.checkNotAssignable(bound, superBound, false);
            }
        } else {
            if (type instanceof PsiArrayType) {
                return GenericsUtil.checkNotAssignable(bound, type, true);
            }
            if (type instanceof PsiIntersectionType) {
                for (PsiType psiType : ((PsiIntersectionType)type).getConjuncts()) {
                    if (GenericsUtil.checkNotInBounds(psiType, bound, uncheckedConversionByDefault)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private static boolean checkExtendsWildcardCaptureFailure(PsiWildcardType type, PsiType bound) {
        LOG.assertTrue(type.isExtends());
        PsiType extendsBound = type.getExtendsBound();
        PsiType boundBound = bound;
        if (bound instanceof PsiWildcardType) {
            if (((PsiWildcardType)bound).isBounded()) {
                boundBound = ((PsiWildcardType)bound).isSuper() ? ((PsiWildcardType)bound).getSuperBound() : ((PsiWildcardType)bound).getExtendsBound();
            } else {
                return false;
            }
        }
        PsiClass extendsBoundClass = PsiUtil.resolveClassInClassTypeOnly(extendsBound);
        PsiClass boundBoundClass = PsiUtil.resolveClassInClassTypeOnly(boundBound);
        if (boundBoundClass != null && extendsBoundClass != null && !boundBoundClass.isInterface() && !extendsBoundClass.isInterface()) {
            return !InheritanceUtil.isInheritorOrSelf(boundBoundClass, extendsBoundClass, true) && !InheritanceUtil.isInheritorOrSelf(extendsBoundClass, boundBoundClass, true);
        }
        return !TypeConversionUtil.areTypesConvertible(boundBound, extendsBound) && !TypeConversionUtil.areTypesConvertible(extendsBound, boundBound);
    }

    private static boolean checkNotAssignable(PsiType bound, PsiType type, boolean allowUncheckedConversion) {
        if (bound instanceof PsiWildcardType) {
            if (((PsiWildcardType)bound).isBounded()) {
                PsiType boundBound = ((PsiWildcardType)bound).isExtends() ? ((PsiWildcardType)bound).getExtendsBound() : ((PsiWildcardType)bound).getSuperBound();
                return !TypeConversionUtil.isAssignable(boundBound, type, allowUncheckedConversion);
            }
            return true;
        }
        return !TypeConversionUtil.isAssignable(bound, type, allowUncheckedConversion);
    }
}

