/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.LowMemoryWatcherManager;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.AppDelayQueue;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.concurrency.SchedulingWrapper;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class AppScheduledExecutorService
extends SchedulingWrapper {
    private static final Logger LOG = Logger.getInstance("#org.jetbrains.ide.PooledThreadExecutor");
    static final String POOLED_THREAD_PREFIX = "ApplicationImpl pooled thread ";
    @NotNull
    private final String myName;
    private final LowMemoryWatcherManager myLowMemoryWatcherManager;
    private Consumer<Thread> newThreadListener;
    private final AtomicInteger counter;

    @NotNull
    static ScheduledExecutorService getInstance() {
        AppScheduledExecutorService appScheduledExecutorService = Holder.INSTANCE;
        if (appScheduledExecutorService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/AppScheduledExecutorService", "getInstance"));
        }
        return appScheduledExecutorService;
    }

    AppScheduledExecutorService(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/concurrency/AppScheduledExecutorService", "<init>"));
        }
        super(new BackendThreadPoolExecutor(), new AppDelayQueue());
        this.counter = new AtomicInteger();
        this.myName = name;
        ((BackendThreadPoolExecutor)this.backendExecutorService).doSetThreadFactory(new ThreadFactory(){

            @Override
            @NotNull
            public Thread newThread(@NotNull Runnable r) {
                if (r == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/util/concurrency/AppScheduledExecutorService$1", "newThread"));
                }
                Thread thread = new Thread(r, AppScheduledExecutorService.POOLED_THREAD_PREFIX + AppScheduledExecutorService.this.counter.incrementAndGet());
                thread.setPriority(4);
                Consumer listener = AppScheduledExecutorService.this.newThreadListener;
                if (listener != null) {
                    listener.consume(thread);
                }
                Thread thread2 = thread;
                if (thread2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/AppScheduledExecutorService$1", "newThread"));
                }
                return thread2;
            }
        });
        this.myLowMemoryWatcherManager = new LowMemoryWatcherManager(this);
    }

    public void setNewThreadListener(@NotNull Consumer<Thread> threadListener) {
        if (threadListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadListener", "com/intellij/util/concurrency/AppScheduledExecutorService", "setNewThreadListener"));
        }
        if (this.newThreadListener != null) {
            throw new IllegalStateException("Listener was already set: " + this.newThreadListener);
        }
        this.newThreadListener = threadListener;
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        List<Runnable> list = AppScheduledExecutorService.error();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/AppScheduledExecutorService", "shutdownNow"));
        }
        return list;
    }

    @Override
    public void shutdown() {
        AppScheduledExecutorService.error();
    }

    static List<Runnable> error() {
        throw new IncorrectOperationException("You must not call this method on the global app pool");
    }

    @Override
    void doShutdown() {
        super.doShutdown();
        ((BackendThreadPoolExecutor)this.backendExecutorService).doShutdown();
    }

    @Override
    @NotNull
    List<Runnable> doShutdownNow() {
        List<Runnable> list = ContainerUtil.concat(super.doShutdownNow(), ((BackendThreadPoolExecutor)this.backendExecutorService).doShutdownNow());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/AppScheduledExecutorService", "doShutdownNow"));
        }
        return list;
    }

    public void shutdownAppScheduledExecutorService() {
        Disposer.dispose(this.myLowMemoryWatcherManager);
        this.delayQueue.shutdown();
        this.doShutdown();
    }

    @NotNull
    public String statistics() {
        String string = this.myName + " threads created counter = " + this.counter;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/AppScheduledExecutorService", "statistics"));
        }
        return string;
    }

    public int getBackendPoolExecutorSize() {
        return ((BackendThreadPoolExecutor)this.backendExecutorService).getPoolSize();
    }

    void setBackendPoolCorePoolSize(int size) {
        ((BackendThreadPoolExecutor)this.backendExecutorService).doSetCorePoolSize(size);
    }

    int getBackendPoolCorePoolSize() {
        return ((BackendThreadPoolExecutor)this.backendExecutorService).getCorePoolSize();
    }

    private static class BackendThreadPoolExecutor
    extends ThreadPoolExecutor {
        BackendThreadPoolExecutor() {
            super(1, Integer.MAX_VALUE, 1L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>());
        }

        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("beforeExecute " + BoundedTaskExecutor.info(r) + " in " + t);
            }
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("afterExecute  " + BoundedTaskExecutor.info(r) + " in " + Thread.currentThread());
            }
            if (t != null) {
                LOG.error("Worker exited due to exception", t);
            }
        }

        private void doShutdown() {
            super.shutdown();
        }

        @NotNull
        private List<Runnable> doShutdownNow() {
            List<Runnable> list = super.shutdownNow();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/AppScheduledExecutorService$BackendThreadPoolExecutor", "doShutdownNow"));
            }
            return list;
        }

        private void doSetThreadFactory(@NotNull ThreadFactory threadFactory) {
            if (threadFactory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadFactory", "com/intellij/util/concurrency/AppScheduledExecutorService$BackendThreadPoolExecutor", "doSetThreadFactory"));
            }
            super.setThreadFactory(threadFactory);
        }

        @Override
        public void shutdown() {
            AppScheduledExecutorService.error();
        }

        @Override
        @NotNull
        public List<Runnable> shutdownNow() {
            List<Runnable> list = AppScheduledExecutorService.error();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/AppScheduledExecutorService$BackendThreadPoolExecutor", "shutdownNow"));
            }
            return list;
        }

        @Override
        public void setCorePoolSize(int corePoolSize) {
            AppScheduledExecutorService.error();
        }

        private void doSetCorePoolSize(int corePoolSize) {
            super.setCorePoolSize(corePoolSize);
        }

        @Override
        public void allowCoreThreadTimeOut(boolean value) {
            AppScheduledExecutorService.error();
        }

        @Override
        public void setMaximumPoolSize(int maximumPoolSize) {
            AppScheduledExecutorService.error();
        }

        @Override
        public void setKeepAliveTime(long time, TimeUnit unit) {
            AppScheduledExecutorService.error();
        }

        @Override
        public void setThreadFactory(ThreadFactory threadFactory) {
            AppScheduledExecutorService.error();
        }
    }

    private static class Holder {
        private static final AppScheduledExecutorService INSTANCE = new AppScheduledExecutorService("Global instance");

        private Holder() {
        }
    }
}

