/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.profiling;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayDeque;
import java.util.Deque;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ResolveProfiler {
    @NonNls
    private static final String PATH = "../../resolve_info/";
    private static final boolean DISABLED = true;
    private static final ThreadLocal<ThreadInfo> threadMap = new ThreadLocal();
    private static volatile int fileCount;

    public static void start() {
    }

    public static long finish() {
        return -1L;
    }

    public static void write(String prefix, @NotNull PsiElement expression, long time) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/util/profiling/ResolveProfiler", "write"));
        }
        ResolveProfiler.write(ResolveProfiler.getInfo(prefix, expression, time));
    }

    public static void write(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/util/profiling/ResolveProfiler", "write"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private static ThreadInfo getThreadInfo() {
        ThreadInfo info = threadMap.get();
        if (info == null) {
            Class<ResolveProfiler> clazz = ResolveProfiler.class;
            // MONITORENTER : com.intellij.util.profiling.ResolveProfiler.class
            info = new ThreadInfo("../../resolve_info/out" + fileCount + ".txt");
            ++fileCount;
            // MONITOREXIT : clazz
            threadMap.set(info);
        }
        ThreadInfo threadInfo = info;
        if (threadInfo != null) return threadInfo;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/profiling/ResolveProfiler", "getThreadInfo"));
    }

    public static String getInfo(String prefix, @NotNull PsiElement expression, long time) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/util/profiling/ResolveProfiler", "getInfo"));
        }
        PsiFile file = expression.getContainingFile();
        String text = expression.getText();
        String textInfo = text != null ? StringUtil.escapeLineBreak(text) : "<null>";
        return prefix + " :: " + (file != null ? file.getName() : "<no file>") + " :: " + textInfo + " :: " + expression.hashCode() + " :: " + time;
    }

    private static class ThreadInfo {
        private final String myFileName;
        private final Deque<Long> myTimeStack;
        private String myPrefix;

        private ThreadInfo(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/profiling/ResolveProfiler$ThreadInfo", "<init>"));
            }
            this.myTimeStack = new ArrayDeque<Long>();
            this.myPrefix = "";
            this.myFileName = name;
        }

        @NotNull
        public String getName() {
            String string = this.myFileName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/profiling/ResolveProfiler$ThreadInfo", "getName"));
            }
            return string;
        }

        public void start() {
            this.myTimeStack.push(System.nanoTime());
            this.myPrefix = this.myPrefix + "  ";
        }

        public long finish() {
            this.myPrefix = this.myPrefix.substring(2);
            Long time = this.myTimeStack.pop();
            return (System.nanoTime() - time) / 1000L;
        }

        private String getPrefix() {
            return this.myPrefix;
        }

        static /* synthetic */ String access$000(ThreadInfo x0) {
            return x0.getPrefix();
        }
    }
}

