/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac.ast.api;

import com.intellij.util.containers.SLRUCache;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import org.jetbrains.annotations.NotNull;

public class JavacNameTable {
    private final SLRUCache<Name, String> myParsedNameCache = new SLRUCache<Name, String>(1000, 1000){

        @NotNull
        public String createValue(Name key) {
            return key.toString();
        }
    };
    private final Elements myElements;
    private Name myAsterisk;

    public JavacNameTable(Elements elements) {
        this.myElements = elements;
    }

    @NotNull
    public String parseName(Name name) {
        return (String)this.myParsedNameCache.get((Object)name);
    }

    @NotNull
    public String parseBinaryName(Element element) {
        return this.parseName(this.myElements.getBinaryName((TypeElement)element));
    }

    @NotNull
    public Name getAsterisk() {
        if (this.myAsterisk == null) {
            this.myAsterisk = this.myElements.getName("*");
        }
        return this.myAsterisk;
    }
}

