/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac.ast.api;

import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.javac.ast.api.JavacNameTable;

public interface JavacRef {
    public static final JavacRef[] EMPTY_ARRAY = new JavacRef[0];

    @NotNull
    public String getName();

    public Set<Modifier> getModifiers();

    @NotNull
    public String getOwnerName();

    public static class JavacElementFieldImpl
    extends JavacElementRefBase
    implements JavacField {
        public JavacElementFieldImpl(@NotNull Element element, JavacNameTable nameTableCache) {
            super(element, nameTableCache);
        }
    }

    public static class JavacElementMethodImpl
    extends JavacElementRefBase
    implements JavacMethod {
        public JavacElementMethodImpl(@NotNull Element element, JavacNameTable nameTableCache) {
            super(element, nameTableCache);
        }

        @Override
        public byte getParamCount() {
            return (byte)((ExecutableElement)this.myOriginalElement).getParameters().size();
        }
    }

    public static class JavacElementClassImpl
    extends JavacElementRefBase
    implements JavacClass {
        public JavacElementClassImpl(@NotNull Element element, JavacNameTable nameTableCache) {
            super(element, nameTableCache);
        }

        @Override
        @NotNull
        public String getName() {
            return this.myNameTableCache.parseBinaryName(this.myOriginalElement);
        }

        @Override
        public boolean isAnonymous() {
            return this.myNameTableCache.parseName(this.myOriginalElement.getSimpleName()).isEmpty();
        }
    }

    public static abstract class JavacElementRefBase
    implements JavacRef {
        @NotNull
        protected final Element myOriginalElement;
        protected final JavacNameTable myNameTableCache;

        protected JavacElementRefBase(@NotNull Element element, JavacNameTable nameTableCache) {
            this.myOriginalElement = element;
            this.myNameTableCache = nameTableCache;
        }

        @NotNull
        public Element getOriginalElement() {
            return this.myOriginalElement;
        }

        @Override
        @NotNull
        public String getName() {
            return this.myNameTableCache.parseName(this.myOriginalElement.getSimpleName());
        }

        @Override
        public Set<Modifier> getModifiers() {
            return this.myOriginalElement.getModifiers();
        }

        @Override
        @NotNull
        public String getOwnerName() {
            return this.myNameTableCache.parseBinaryName(this.myOriginalElement.getEnclosingElement());
        }

        @Nullable
        public static JavacElementRefBase fromElement(Element element, JavacNameTable nameTableCache) {
            if (element instanceof TypeElement) {
                return new JavacElementClassImpl(element, nameTableCache);
            }
            if (element instanceof VariableElement) {
                return new JavacElementFieldImpl(element, nameTableCache);
            }
            if (element instanceof ExecutableElement) {
                return new JavacElementMethodImpl(element, nameTableCache);
            }
            if (element == null || element.getKind() == ElementKind.OTHER) {
                return null;
            }
            throw new AssertionError((Object)("unexpected element: " + element + " class: " + element.getClass()));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JavacElementRefBase base = (JavacElementRefBase)o;
            return this.myOriginalElement == base.myOriginalElement;
        }

        public int hashCode() {
            return this.myOriginalElement.hashCode();
        }
    }

    public static class JavacFieldImpl
    extends JavacRefBase
    implements JavacField {
        private final String myOwnerName;

        public JavacFieldImpl(String ownerName, Set<Modifier> modifiers, String name) {
            super(name, modifiers);
            this.myOwnerName = ownerName;
        }

        @Override
        @NotNull
        public String getOwnerName() {
            return this.myOwnerName;
        }
    }

    public static class JavacMethodImpl
    extends JavacRefBase
    implements JavacMethod {
        private final String myOwnerName;
        private final byte myParamCount;

        public JavacMethodImpl(String ownerName, byte paramCount, Set<Modifier> modifiers, String name) {
            super(name, modifiers);
            this.myOwnerName = ownerName;
            this.myParamCount = paramCount;
        }

        @Override
        public byte getParamCount() {
            return this.myParamCount;
        }

        @Override
        @NotNull
        public String getOwnerName() {
            return this.myOwnerName;
        }
    }

    public static class JavacClassImpl
    extends JavacRefBase
    implements JavacClass {
        private boolean myAnonymous;

        public JavacClassImpl(boolean anonymous, Set<Modifier> modifiers, String name) {
            super(name, modifiers);
            this.myAnonymous = anonymous;
        }

        @Override
        @NotNull
        public String getOwnerName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isAnonymous() {
            return this.myAnonymous;
        }
    }

    public static abstract class JavacRefBase
    implements JavacRef {
        private final String myName;
        private final Set<Modifier> myModifiers;

        protected JavacRefBase(String name, Set<Modifier> modifiers) {
            this.myName = name;
            this.myModifiers = modifiers;
        }

        @Override
        @NotNull
        public final String getName() {
            return this.myName;
        }

        @Override
        public final Set<Modifier> getModifiers() {
            return this.myModifiers;
        }
    }

    public static interface JavacField
    extends JavacRef {
    }

    public static interface JavacMethod
    extends JavacRef {
        public byte getParamCount();
    }

    public static interface JavacClass
    extends JavacRef {
        public boolean isAnonymous();
    }
}

