/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.DefaultExternalPlugin;
import org.jetbrains.plugins.gradle.model.DefaultExternalSourceSet;
import org.jetbrains.plugins.gradle.model.DefaultExternalTask;
import org.jetbrains.plugins.gradle.model.ExternalPlugin;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalProjectPreview;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.model.ExternalTask;

public class DefaultExternalProject
implements ExternalProject,
ExternalProjectPreview {
    private static final long serialVersionUID = 1L;
    @NotNull
    private String myId;
    @NotNull
    private String myName;
    @NotNull
    private String myQName;
    @Nullable
    private String myDescription;
    @NotNull
    private String myGroup;
    @NotNull
    private String myVersion;
    @NotNull
    private Map<String, ExternalProject> myChildProjects = new HashMap<String, ExternalProject>();
    @NotNull
    private File myProjectDir;
    @NotNull
    private File myBuildDir;
    @Nullable
    private File myBuildFile;
    @NotNull
    private Map<String, ExternalTask> myTasks = new HashMap<String, ExternalTask>();
    @NotNull
    private Map<String, ?> myProperties = new HashMap();
    @NotNull
    private Map<String, ExternalSourceSet> mySourceSets = new HashMap<String, ExternalSourceSet>();
    @NotNull
    private String myExternalSystemId;
    @NotNull
    private Map<String, ExternalPlugin> myPlugins = new HashMap<String, ExternalPlugin>();
    @NotNull
    private List<File> myArtifacts = new ArrayList<File>();
    @NotNull
    private Map<String, Set<File>> myArtifactsByConfiguration = new HashMap<String, Set<File>>();

    public DefaultExternalProject() {
    }

    public DefaultExternalProject(@NotNull ExternalProject externalProject) {
        this();
        this.myId = externalProject.getId();
        this.myName = externalProject.getName();
        this.myQName = externalProject.getQName();
        this.myVersion = externalProject.getVersion();
        this.myGroup = externalProject.getGroup();
        this.myDescription = externalProject.getDescription();
        this.myProjectDir = externalProject.getProjectDir();
        this.myBuildDir = externalProject.getBuildDir();
        this.myBuildFile = externalProject.getBuildFile();
        this.myExternalSystemId = externalProject.getExternalSystemId();
        for (Map.Entry entry : externalProject.getChildProjects().entrySet()) {
            this.myChildProjects.put((String)entry.getKey(), new DefaultExternalProject((ExternalProject)entry.getValue()));
        }
        for (Map.Entry entry : externalProject.getTasks().entrySet()) {
            this.myTasks.put((String)entry.getKey(), new DefaultExternalTask((ExternalTask)entry.getValue()));
        }
        for (Map.Entry entry : externalProject.getSourceSets().entrySet()) {
            this.mySourceSets.put((String)entry.getKey(), new DefaultExternalSourceSet((ExternalSourceSet)entry.getValue()));
        }
        for (Map.Entry entry : externalProject.getPlugins().entrySet()) {
            this.myPlugins.put((String)entry.getKey(), new DefaultExternalPlugin((ExternalPlugin)entry.getValue()));
        }
        this.myArtifacts.addAll(externalProject.getArtifacts());
        this.myArtifactsByConfiguration.putAll(externalProject.getArtifactsByConfiguration());
    }

    @NotNull
    public String getExternalSystemId() {
        return this.myExternalSystemId;
    }

    @NotNull
    public String getId() {
        return this.myId;
    }

    public void setId(@NotNull String id) {
        this.myId = id;
    }

    public void setExternalSystemId(@NotNull String externalSystemId) {
        this.myExternalSystemId = externalSystemId;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    public void setName(@NotNull String name) {
        this.myName = name;
    }

    @NotNull
    public String getQName() {
        return this.myQName;
    }

    public void setQName(@NotNull String QName) {
        this.myQName = QName;
    }

    @Nullable
    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(@Nullable String description) {
        this.myDescription = description;
    }

    @NotNull
    public String getGroup() {
        return this.myGroup;
    }

    public void setGroup(@NotNull String group) {
        this.myGroup = group;
    }

    @NotNull
    public String getVersion() {
        return this.myVersion;
    }

    public void setVersion(@NotNull String version) {
        this.myVersion = version;
    }

    @NotNull
    public Map<String, ExternalProject> getChildProjects() {
        return this.myChildProjects;
    }

    public void setChildProjects(@NotNull Map<String, ExternalProject> childProjects) {
        this.myChildProjects = childProjects;
    }

    @NotNull
    public File getProjectDir() {
        return this.myProjectDir;
    }

    public void setProjectDir(@NotNull File projectDir) {
        this.myProjectDir = projectDir;
    }

    @NotNull
    public File getBuildDir() {
        return this.myBuildDir;
    }

    public void setBuildDir(@NotNull File buildDir) {
        this.myBuildDir = buildDir;
    }

    @Nullable
    public File getBuildFile() {
        return this.myBuildFile;
    }

    public void setBuildFile(@Nullable File buildFile) {
        this.myBuildFile = buildFile;
    }

    @NotNull
    public Map<String, ExternalTask> getTasks() {
        return this.myTasks;
    }

    public void setTasks(@NotNull Map<String, ExternalTask> tasks) {
        this.myTasks = tasks;
    }

    @NotNull
    public Map<String, ExternalPlugin> getPlugins() {
        return this.myPlugins;
    }

    public void setPlugins(@NotNull Map<String, ExternalPlugin> plugins) {
        this.myPlugins = plugins;
    }

    @NotNull
    public Map<String, ?> getProperties() {
        return this.myProperties;
    }

    public void setProperties(@NotNull Map<String, ?> properties) {
        this.myProperties = properties;
    }

    @Nullable
    public Object getProperty(String name) {
        return this.myProperties.get(name);
    }

    @NotNull
    public Map<String, ExternalSourceSet> getSourceSets() {
        return this.mySourceSets;
    }

    public void setSourceSets(@NotNull Map<String, ExternalSourceSet> sourceSets) {
        this.mySourceSets = sourceSets;
    }

    @NotNull
    public List<File> getArtifacts() {
        return this.myArtifacts;
    }

    public void setArtifacts(@NotNull List<File> artifacts) {
        this.myArtifacts = artifacts;
    }

    public void setArtifactsByConfiguration(@NotNull Map<String, Set<File>> artifactsByConfiguration) {
        this.myArtifactsByConfiguration = artifactsByConfiguration;
    }

    @NotNull
    public Map<String, Set<File>> getArtifactsByConfiguration() {
        return this.myArtifactsByConfiguration;
    }

    public String toString() {
        return "project '" + this.myId + "'";
    }
}

