/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.util.Set;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.composite.internal.CompositeProjectComponentArtifactMetadata;
import org.gradle.composite.internal.IncludedBuildTaskGraph;
import org.gradle.internal.component.model.ComponentArtifactMetadata;

class IncludedBuildArtifactBuilder {
    private final IncludedBuildTaskGraph includedBuildTaskGraph;

    IncludedBuildArtifactBuilder(IncludedBuildTaskGraph includedBuildTaskGraph) {
        this.includedBuildTaskGraph = includedBuildTaskGraph;
    }

    public void build(BuildIdentifier requestingBuild, ComponentArtifactMetadata artifact) {
        if (artifact instanceof CompositeProjectComponentArtifactMetadata) {
            CompositeProjectComponentArtifactMetadata compositeBuildArtifact = (CompositeProjectComponentArtifactMetadata)artifact;
            BuildIdentifier targetBuild = this.getBuildIdentifier(compositeBuildArtifact);
            Set<String> tasks = compositeBuildArtifact.getTasks();
            for (String taskName : tasks) {
                this.includedBuildTaskGraph.addTask(requestingBuild, targetBuild, taskName);
            }
            for (String taskName : tasks) {
                this.includedBuildTaskGraph.awaitCompletion(targetBuild, taskName);
            }
        }
    }

    private BuildIdentifier getBuildIdentifier(CompositeProjectComponentArtifactMetadata artifact) {
        return artifact.getComponentId().getBuild();
    }
}

