/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USuperExpression;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u00012\u00020\u0002:\u0002\u0013\u0014B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010\u0018\u00010\u000fH\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/lint/checks/CallSuperDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/Detector$UastScanner;", "()V", "callsSuper", "", "method", "Lorg/jetbrains/uast/UMethod;", "superMethod", "Lcom/intellij/psi/PsiMethod;", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "getRequiredSuperMethod", "Issues", "SuperCallVisitor", "lint-checks_main"})
public final class CallSuperDetector
extends Detector
implements Detector.UastScanner {
    private static final Implementation IMPLEMENTATION;
    @JvmField
    public static final Issue ISSUE;
    private static final String CALL_SUPER_ANNOTATION = "android.support.annotation.CallSuper";
    private static final String ON_DETACHED_FROM_WINDOW = "onDetachedFromWindow";
    private static final String ON_VISIBILITY_CHANGED = "onVisibilityChanged";
    public static final Issues Issues;

    @Nullable
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return CollectionsKt.listOf(UMethod.class);
    }

    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new UElementHandler(this, context){
            final /* synthetic */ CallSuperDetector this$0;
            final /* synthetic */ JavaContext $context;

            public void visitMethod(@NotNull UMethod method) {
                Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
                PsiMethod psiMethod = CallSuperDetector.access$getRequiredSuperMethod(this.this$0, this.$context, method);
                if (psiMethod == null) {
                    return;
                }
                PsiMethod superMethod = psiMethod;
                if (!CallSuperDetector.access$callsSuper(this.this$0, method, superMethod)) {
                    String message = "Overriding method should call `super." + method.getName() + "`";
                    Location location = this.$context.getNameLocation(method);
                    Issue issue = CallSuperDetector.ISSUE;
                    Intrinsics.checkExpressionValueIsNotNull((Object)issue, (String)"ISSUE");
                    this.$context.report(issue, method, location, message);
                }
            }
            {
                this.this$0 = $outer;
                this.$context = $captured_local_variable$1;
            }
        };
    }

    private final PsiMethod getRequiredSuperMethod(JavaContext context, UMethod method) {
        JavaEvaluator evaluator = context.getEvaluator();
        PsiMethod psiMethod = evaluator.getSuperMethod((PsiMethod)method);
        if (psiMethod == null) {
            return null;
        }
        PsiMethod directSuper = psiMethod;
        String name = method.getName();
        if (Intrinsics.areEqual((Object)ON_DETACHED_FROM_WINDOW, (Object)name)) {
            if (!evaluator.isMemberInSubClassOf((PsiMember)method, "android.view.View", false)) {
                return null;
            }
            return directSuper;
        }
        if (Intrinsics.areEqual((Object)ON_VISIBILITY_CHANGED, (Object)name)) {
            if (!evaluator.isMemberInSubClassOf((PsiMember)method, "android.support.wearable.watchface.WatchFaceService.Engine", false)) {
                return null;
            }
            return directSuper;
        }
        PsiAnnotation[] annotations = evaluator.getAllAnnotations((PsiModifierListOwner)directSuper, true);
        for (int i = 0; i < annotations.length; ++i) {
            PsiAnnotation annotation = annotations[i];
            String signature = annotation.getQualifiedName();
            if (!Intrinsics.areEqual((Object)CALL_SUPER_ANNOTATION, (Object)signature) && (signature == null || !StringsKt.endsWith$default((String)signature, (String)".OverrideMustInvoke", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)signature, (String)".OverridingMethodsMustInvokeSuper", (boolean)false, (int)2, null))) continue;
            return directSuper;
        }
        return null;
    }

    private final boolean callsSuper(UMethod method, PsiMethod superMethod) {
        SuperCallVisitor visitor = new SuperCallVisitor(superMethod);
        method.accept((UastVisitor)visitor);
        return visitor.getCallsSuper();
    }

    static {
        Issues = new Issues(null);
        IMPLEMENTATION = new Implementation(CallSuperDetector.class, Scope.JAVA_FILE_SCOPE);
        ISSUE = Issue.create((String)"MissingSuperCall", (String)"Missing Super Call", (String)"\nSome methods, such as `View#onDetachedFromWindow`, require that you also call the super\nimplementation as part of your method.\n", (Category)Category.CORRECTNESS, (int)9, (Severity)Severity.ERROR, (Implementation)CallSuperDetector.Issues.getIMPLEMENTATION());
    }

    @Nullable
    public static final /* synthetic */ PsiMethod access$getRequiredSuperMethod(CallSuperDetector $this, @NotNull JavaContext context, @NotNull UMethod method) {
        return $this.getRequiredSuperMethod(context, method);
    }

    public static final /* synthetic */ boolean access$callsSuper(CallSuperDetector $this, @NotNull UMethod method, @NotNull PsiMethod superMethod) {
        return $this.callsSuper(method, superMethod);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/checks/CallSuperDetector$SuperCallVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "targetMethod", "Lcom/intellij/psi/PsiMethod;", "(Lcom/intellij/psi/PsiMethod;)V", "callsSuper", "", "getCallsSuper", "()Z", "setCallsSuper", "(Z)V", "visitSuperExpression", "node", "Lorg/jetbrains/uast/USuperExpression;", "lint-checks_main"})
    private static final class SuperCallVisitor
    extends AbstractUastVisitor {
        private boolean callsSuper;
        private final PsiMethod targetMethod;

        public final boolean getCallsSuper() {
            return this.callsSuper;
        }

        public final void setCallsSuper(boolean bl) {
            this.callsSuper = bl;
        }

        public boolean visitSuperExpression(@NotNull USuperExpression node) {
            PsiElement resolved;
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            UElement parent = LintUtils.skipParentheses((UElement)node.getUastParent());
            if (parent instanceof UReferenceExpression && Intrinsics.areEqual((Object)this.targetMethod, (Object)(resolved = ((UReferenceExpression)parent).resolve()))) {
                this.callsSuper = true;
            }
            return super.visitSuperExpression(node);
        }

        public SuperCallVisitor(@NotNull PsiMethod targetMethod) {
            Intrinsics.checkParameterIsNotNull((Object)targetMethod, (String)"targetMethod");
            this.targetMethod = targetMethod;
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/checks/CallSuperDetector$Issues;", "", "()V", "CALL_SUPER_ANNOTATION", "", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "getIMPLEMENTATION", "()Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "kotlin.jvm.PlatformType", "ON_DETACHED_FROM_WINDOW", "ON_VISIBILITY_CHANGED", "lint-checks_main"})
    public static final class Issues {
        private final Implementation getIMPLEMENTATION() {
            return IMPLEMENTATION;
        }

        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

