/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore;

import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;

public class DataStoreDatabase {
    private final Connection myConnection;

    private static Logger getLogger() {
        return Logger.getInstance(DataStoreDatabase.class);
    }

    public DataStoreDatabase(@NotNull String dbPath, @NotNull Characteristic characteristic) {
        Connection connection = null;
        try {
            Class.forName("org.sqlite.JDBC");
            switch (characteristic) {
                case PERFORMANT: {
                    connection = DriverManager.getConnection("jdbc:sqlite::memory:");
                    break;
                }
                case DURABLE: {
                    File dbFile = new File(dbPath);
                    File parent = dbFile.getParentFile();
                    if (parent != null && !parent.mkdirs() && !parent.exists()) {
                        DataStoreDatabase.getLogger().error("Unable to create parent directory");
                    }
                    connection = DriverManager.getConnection(String.format("jdbc:sqlite:%s", dbFile.getPath()));
                    break;
                }
                default: {
                    throw new RuntimeException("Characteristic not handled!");
                }
            }
            connection.setAutoCommit(false);
        }
        catch (ClassNotFoundException | SQLException e) {
            DataStoreDatabase.getLogger().error((Throwable)e);
        }
        this.myConnection = connection;
    }

    public void disconnect() {
        try {
            this.myConnection.commit();
        }
        catch (SQLException e) {
            DataStoreDatabase.getLogger().error((Throwable)e);
        }
        finally {
            try {
                if (!this.myConnection.isClosed()) {
                    this.myConnection.close();
                }
            }
            catch (SQLException e) {
                DataStoreDatabase.getLogger().error((Throwable)e);
            }
        }
    }

    public Connection getConnection() {
        return this.myConnection;
    }

    public static enum Characteristic {
        DURABLE,
        PERFORMANT;

    }
}

