/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.datastore.DataStoreDatabase;
import com.android.tools.datastore.ServicePassThrough;
import com.android.tools.datastore.service.CpuService;
import com.android.tools.datastore.service.EventService;
import com.android.tools.datastore.service.MemoryService;
import com.android.tools.datastore.service.NetworkService;
import com.android.tools.datastore.service.ProfilerService;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.CpuServiceGrpc;
import com.android.tools.profiler.proto.EventServiceGrpc;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import com.android.tools.profiler.proto.NetworkServiceGrpc;
import com.android.tools.profiler.proto.ProfilerServiceGrpc;
import com.google.wireless.android.sdk.stats.AndroidProfilerDbStats;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.diagnostic.Logger;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import io.grpc.inprocess.InProcessServerBuilder;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class DataStoreService {
    private static final long REPORT_INITIAL_DELAY = TimeUnit.MINUTES.toMillis(15L);
    private static final long REPORT_PERIOD = TimeUnit.HOURS.toMillis(1L);
    private static final Logger LOG = Logger.getInstance((String)DataStoreService.class.getCanonicalName());
    private final String myDatastoreDirectory;
    private final Map<BackingNamespace, DataStoreDatabase> myDatabases = new HashMap<BackingNamespace, DataStoreDatabase>();
    private final HashMap<Common.Session, Long> mySessionIdLookup = new HashMap();
    private final ServerBuilder myServerBuilder;
    private final Server myServer;
    private final List<ServicePassThrough> myServices = new ArrayList<ServicePassThrough>();
    private final Consumer<Runnable> myFetchExecutor;
    private ProfilerService myProfilerService;
    private final ServerInterceptor myInterceptor;
    private final Map<Common.Session, DataStoreClient> myConnectedClients = new HashMap<Common.Session, DataStoreClient>();
    private final Timer myReportTimer;

    public DataStoreService(@NotNull String serviceName, @NotNull String datastoreDirectory, Consumer<Runnable> fetchExecutor) {
        this(serviceName, datastoreDirectory, fetchExecutor, null);
    }

    public DataStoreService(@NotNull String serviceName, @NotNull String datastoreDirectory, @NotNull Consumer<Runnable> fetchExecutor, ServerInterceptor interceptor) {
        this.myFetchExecutor = fetchExecutor;
        this.myInterceptor = interceptor;
        this.myDatastoreDirectory = datastoreDirectory;
        this.myServerBuilder = InProcessServerBuilder.forName((String)serviceName).directExecutor();
        this.createPollers();
        this.myServer = this.myServerBuilder.build();
        try {
            this.myServer.start();
        }
        catch (IOException ex) {
            LOG.error(ex.getMessage());
        }
        this.myReportTimer = new Timer("DataStoreReportTimer");
        this.myReportTimer.schedule((TimerTask)new ReportTimerTask(), REPORT_INITIAL_DELAY, REPORT_PERIOD);
    }

    public void createPollers() {
        this.myProfilerService = new ProfilerService(this, this.myFetchExecutor, this.mySessionIdLookup);
        this.registerService(this.myProfilerService);
        this.registerService(new EventService(this, this.myFetchExecutor, this.mySessionIdLookup));
        this.registerService(new CpuService(this, this.myFetchExecutor, this.mySessionIdLookup));
        this.registerService(new MemoryService(this, this.myFetchExecutor, this.mySessionIdLookup));
        this.registerService(new NetworkService(this, this.myFetchExecutor, this.mySessionIdLookup));
    }

    @NotNull
    DataStoreDatabase createDatabase(@NotNull String dbPath, @NotNull DataStoreDatabase.Characteristic characteristic) {
        return new DataStoreDatabase(dbPath, characteristic);
    }

    void registerService(@NotNull ServicePassThrough service) {
        this.myServices.add(service);
        List<BackingNamespace> namespaces = service.getBackingNamespaces();
        namespaces.forEach(namespace -> {
            assert (!namespace.myNamespace.isEmpty());
            DataStoreDatabase db = this.myDatabases.computeIfAbsent((BackingNamespace)namespace, backingNamespace -> this.createDatabase(this.myDatastoreDirectory + backingNamespace.myNamespace, backingNamespace.myCharacteristic));
            service.setBackingStore((BackingNamespace)namespace, db.getConnection());
        });
        if (this.myInterceptor != null) {
            this.myServerBuilder.addService(ServerInterceptors.intercept((ServerServiceDefinition)service.bindService(), (ServerInterceptor[])new ServerInterceptor[]{this.myInterceptor}));
        } else {
            this.myServerBuilder.addService(service.bindService());
        }
    }

    public void connect(@NotNull ManagedChannel channel) {
        this.myProfilerService.startMonitoring((Channel)channel);
    }

    public void disconnect(@NotNull Common.Session session) {
        if (this.myConnectedClients.containsKey(session)) {
            DataStoreClient client = this.myConnectedClients.remove(session);
            client.shutdownNow();
            this.myProfilerService.stopMonitoring(client.getChannel());
        }
    }

    public void shutdown() {
        this.myReportTimer.cancel();
        this.myServer.shutdownNow();
        for (DataStoreClient client : this.myConnectedClients.values()) {
            client.shutdownNow();
        }
        this.myConnectedClients.clear();
        this.myDatabases.forEach((name, db) -> db.disconnect());
    }

    List<ServicePassThrough> getRegisteredServices() {
        return this.myServices;
    }

    public void setConnectedClients(Common.Session session, Channel channel) {
        if (!this.myConnectedClients.containsKey(session)) {
            this.myConnectedClients.put(session, new DataStoreClient(channel));
        }
    }

    public CpuServiceGrpc.CpuServiceBlockingStub getCpuClient(Common.Session session) {
        return this.myConnectedClients.containsKey(session) ? this.myConnectedClients.get(session).getCpuClient() : null;
    }

    public EventServiceGrpc.EventServiceBlockingStub getEventClient(Common.Session session) {
        return this.myConnectedClients.containsKey(session) ? this.myConnectedClients.get(session).getEventClient() : null;
    }

    public NetworkServiceGrpc.NetworkServiceBlockingStub getNetworkClient(Common.Session session) {
        return this.myConnectedClients.containsKey(session) ? this.myConnectedClients.get(session).getNetworkClient() : null;
    }

    public MemoryServiceGrpc.MemoryServiceBlockingStub getMemoryClient(Common.Session session) {
        return this.myConnectedClients.containsKey(session) ? this.myConnectedClients.get(session).getMemoryClient() : null;
    }

    public ProfilerServiceGrpc.ProfilerServiceBlockingStub getProfilerClient(Common.Session session) {
        return this.myConnectedClients.containsKey(session) ? this.myConnectedClients.get(session).getProfilerClient() : null;
    }

    private final class ReportTimerTask
    extends TimerTask {
        private long myStartTime = System.nanoTime();

        private ReportTimerTask() {
        }

        @Override
        public void run() {
            AndroidProfilerDbStats.Builder dbStats = AndroidProfilerDbStats.newBuilder();
            dbStats.setAgeSec((int)TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - this.myStartTime));
            this.collectReport(dbStats);
            AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.ANDROID_PROFILER_DB_STATS).setAndroidProfilerDbStats(dbStats);
            UsageTracker.getInstance().log(event);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void collectReport(AndroidProfilerDbStats.Builder dbStats) {
            try {
                File dbFile = new File(DataStoreService.this.myDatastoreDirectory, BackingNamespace.DEFAULT_SHARED_NAMESPACE.myNamespace);
                dbStats.setTotalDiskMb((int)(dbFile.length() / 1024L / 1024L));
                Iterator iterator = DataStoreService.this.myDatabases.values().iterator();
                block37: while (iterator.hasNext()) {
                    DataStoreDatabase db = (DataStoreDatabase)iterator.next();
                    Statement tableStatement = db.getConnection().createStatement();
                    Throwable throwable = null;
                    try {
                        ResultSet tableResults = tableStatement.executeQuery("SELECT name FROM sqlite_master WHERE type='table'");
                        Throwable throwable2 = null;
                        try {
                            while (true) {
                                Statement sizeStatement;
                                block46: {
                                    if (!tableResults.next()) continue block37;
                                    String tableName = tableResults.getString(1);
                                    sizeStatement = db.getConnection().createStatement();
                                    Throwable throwable3 = null;
                                    try {
                                        try (ResultSet sizeResult = sizeStatement.executeQuery(String.format("SELECT COUNT(*) FROM %s", tableName));){
                                            int tableSize = sizeResult.getInt(1);
                                            dbStats.addTablesBuilder().setName(tableName).setNumRecords(tableSize).build();
                                        }
                                        if (sizeStatement == null) continue;
                                        if (throwable3 == null) break block46;
                                    }
                                    catch (Throwable throwable4) {
                                        try {
                                            throwable3 = throwable4;
                                            throw throwable4;
                                        }
                                        catch (Throwable throwable5) {
                                            if (sizeStatement == null) throw throwable5;
                                            if (throwable3 != null) {
                                                try {
                                                    sizeStatement.close();
                                                    throw throwable5;
                                                }
                                                catch (Throwable throwable6) {
                                                    throwable3.addSuppressed(throwable6);
                                                    throw throwable5;
                                                }
                                            }
                                            sizeStatement.close();
                                            throw throwable5;
                                        }
                                    }
                                    try {
                                        sizeStatement.close();
                                    }
                                    catch (Throwable throwable7) {
                                        throwable3.addSuppressed(throwable7);
                                    }
                                    continue;
                                }
                                sizeStatement.close();
                            }
                        }
                        catch (Throwable throwable8) {
                            throwable2 = throwable8;
                            throw throwable8;
                        }
                        finally {
                            if (tableResults == null) continue;
                            if (throwable2 != null) {
                                try {
                                    tableResults.close();
                                }
                                catch (Throwable throwable9) {
                                    throwable2.addSuppressed(throwable9);
                                }
                                continue;
                            }
                            tableResults.close();
                        }
                    }
                    catch (Throwable throwable10) {
                        throwable = throwable10;
                        throw throwable10;
                    }
                    finally {
                        if (tableStatement == null) continue;
                        if (throwable != null) {
                            try {
                                tableStatement.close();
                            }
                            catch (Throwable throwable11) {
                                throwable.addSuppressed(throwable11);
                            }
                            continue;
                        }
                        tableStatement.close();
                    }
                }
                return;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static class DataStoreClient {
        @NotNull
        private final Channel myChannel;
        @NotNull
        private final ProfilerServiceGrpc.ProfilerServiceBlockingStub myProfilerClient;
        @NotNull
        private final MemoryServiceGrpc.MemoryServiceBlockingStub myMemoryClient;
        @NotNull
        private final CpuServiceGrpc.CpuServiceBlockingStub myCpuClient;
        @NotNull
        private final NetworkServiceGrpc.NetworkServiceBlockingStub myNetworkClient;
        @NotNull
        private final EventServiceGrpc.EventServiceBlockingStub myEventClient;

        public DataStoreClient(@NotNull Channel channel) {
            this.myChannel = channel;
            this.myProfilerClient = ProfilerServiceGrpc.newBlockingStub((Channel)channel);
            this.myMemoryClient = MemoryServiceGrpc.newBlockingStub((Channel)channel);
            this.myCpuClient = CpuServiceGrpc.newBlockingStub((Channel)channel);
            this.myNetworkClient = NetworkServiceGrpc.newBlockingStub((Channel)channel);
            this.myEventClient = EventServiceGrpc.newBlockingStub((Channel)channel);
        }

        @NotNull
        public Channel getChannel() {
            return this.myChannel;
        }

        @NotNull
        public ProfilerServiceGrpc.ProfilerServiceBlockingStub getProfilerClient() {
            return this.myProfilerClient;
        }

        @NotNull
        public MemoryServiceGrpc.MemoryServiceBlockingStub getMemoryClient() {
            return this.myMemoryClient;
        }

        @NotNull
        public CpuServiceGrpc.CpuServiceBlockingStub getCpuClient() {
            return this.myCpuClient;
        }

        @NotNull
        public NetworkServiceGrpc.NetworkServiceBlockingStub getNetworkClient() {
            return this.myNetworkClient;
        }

        @NotNull
        public EventServiceGrpc.EventServiceBlockingStub getEventClient() {
            return this.myEventClient;
        }

        public void shutdownNow() {
            if (this.myChannel instanceof ManagedChannel) {
                ((ManagedChannel)this.myChannel).shutdownNow();
            }
        }
    }

    public static class BackingNamespace {
        public static final BackingNamespace DEFAULT_SHARED_NAMESPACE = new BackingNamespace("default.sql", DataStoreDatabase.Characteristic.DURABLE);
        @NotNull
        public final String myNamespace;
        @NotNull
        public final DataStoreDatabase.Characteristic myCharacteristic;

        public BackingNamespace(@NotNull String namespace, @NotNull DataStoreDatabase.Characteristic characteristic) {
            this.myNamespace = namespace;
            this.myCharacteristic = characteristic;
        }

        public int hashCode() {
            return Arrays.hashCode(new Object[]{this.myNamespace, this.myCharacteristic});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BackingNamespace)) {
                return false;
            }
            BackingNamespace other = (BackingNamespace)obj;
            return this.myNamespace.equals(other.myNamespace) && this.myCharacteristic == other.myCharacteristic;
        }
    }
}

