/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.database;

import com.android.tools.datastore.database.DataStoreTable;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.CpuProfiler;
import com.google.protobuf3jarjar.ByteString;
import com.google.protobuf3jarjar.InvalidProtocolBufferException;
import com.intellij.openapi.diagnostic.Logger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class CpuTable
extends DataStoreTable<CpuStatements> {
    private static final int DATA_COLUMN = 1;
    private static final int PROFILER_TYPE_COLUMN_TRACE_DATA = 2;

    private static Logger getLogger() {
        return Logger.getInstance(CpuTable.class);
    }

    public CpuTable(@NotNull Map<Common.Session, Long> sesstionIdLookup) {
        super(sesstionIdLookup);
    }

    @Override
    public void initialize(@NotNull Connection connection) {
        super.initialize(connection);
        try {
            this.createTable("Cpu_Data", "AppId INTEGER NOT NULL", "Timestamp INTEGER NOT NULL", "Session INTEGER NOT NULL", "Data BLOB");
            this.createTable("Thread_Activities", "AppId INTEGER NOT NULL", "Session INTEGER NOT NULL", "ThreadId INTEGER NOT NULL", "Timestamp INTEGER", "State TEXT, Name TEXT");
            this.createTable("Cpu_Trace", "AppId INTEGER NOT NULL", "TraceId INTEGER NOT NULL", "Session INTEGER NOT NULL", "ProfilerType TEXT", "Data BLOB");
            this.createTable("Cpu_Trace_Info", "AppId INTEGER NOT NULL", "Session INTEGER NOT NULL", "StartTime INTEGER", "EndTime INTEGER", "TraceInfo BLOB");
            this.createUniqueIndex("Cpu_Data", "AppId", "Timestamp", "Session");
            this.createUniqueIndex("Cpu_Trace", "AppId", "TraceId", "Session");
            this.createUniqueIndex("Thread_Activities", "AppId", "Session", "ThreadId", "Timestamp");
        }
        catch (SQLException ex) {
            CpuTable.getLogger().error((Throwable)ex);
        }
    }

    @Override
    public void prepareStatements() {
        try {
            this.createStatement(CpuStatements.INSERT_CPU_DATA, "INSERT OR REPLACE INTO Cpu_Data (AppId, Timestamp, Session, Data) values (?, ?, ?, ?)");
            this.createStatement(CpuStatements.QUERY_CPU_DATA, "SELECT Data from Cpu_Data WHERE AppId = ? AND Session = ? AND Timestamp > ? AND Timestamp <= ? ");
            this.createStatement(CpuStatements.QUERY_TRACE_INFO, "SELECT TraceInfo from Cpu_Trace_Info WHERE AppId = ? AND Session = ? AND ((StartTime < ? AND ? <= EndTime) OR (StartTime > ? AND EndTime = 0));");
            this.createStatement(CpuStatements.FIND_TRACE_DATA, "SELECT Data, ProfilerType from Cpu_Trace WHERE AppId = ? AND TraceId = ? AND Session = ?");
            this.createStatement(CpuStatements.INSERT_TRACE_DATA, "INSERT INTO Cpu_Trace (AppId, TraceId, Session, ProfilerType, Data) values (?, ?, ?, ?, ?)");
            this.createStatement(CpuStatements.INSERT_TRACE_INFO, "INSERT OR REPLACE INTO Cpu_Trace_Info (AppId, Session, StartTime, EndTime, TraceInfo) values (?, ?, ?, ?, ?)");
            this.createStatement(CpuStatements.INSERT_THREAD_ACTIVITY, "INSERT OR REPLACE INTO Thread_Activities (AppId, Session, ThreadId, Timestamp, State, Name) VALUES (?, ?, ?, ?, ?, ?)");
            this.createStatement(CpuStatements.QUERY_THREAD_ACTIVITIES, "SELECT t1.ThreadId, t1.Name, t1.State, ? as ReqStart FROM Thread_Activities AS t1 JOIN (SELECT ThreadId, MAX(Timestamp) AS Timestamp FROM Thread_Activities WHERE AppId = ? AND Session = ? AND Timestamp <= ? GROUP BY ThreadId) AS t2 ON t1.ThreadId = t2.ThreadId AND t1.Timestamp = t2.Timestamp AND t1.State <> 'DEAD' UNION ALL SELECT ThreadId, Name, State, Timestamp FROM Thread_Activities WHERE AppId = ? AND Session = ? AND Timestamp > ? AND Timestamp <= ?;");
        }
        catch (SQLException ex) {
            CpuTable.getLogger().error((Throwable)ex);
        }
    }

    public void insert(Common.Session session, CpuProfiler.CpuProfilerData data) {
        this.execute(CpuStatements.INSERT_CPU_DATA, data.getBasicInfo().getProcessId(), data.getBasicInfo().getEndTimestamp(), session, data.toByteArray());
    }

    public List<CpuProfiler.CpuProfilerData> getCpuDataByRequest(CpuProfiler.CpuDataRequest request) {
        ArrayList<CpuProfiler.CpuProfilerData> cpuData = new ArrayList<CpuProfiler.CpuProfilerData>();
        try {
            ResultSet results = this.executeQuery(CpuStatements.QUERY_CPU_DATA, request.getProcessId(), request.getSession(), request.getStartTimestamp(), request.getEndTimestamp());
            while (results.next()) {
                CpuProfiler.CpuProfilerData.Builder data = CpuProfiler.CpuProfilerData.newBuilder();
                data.mergeFrom(results.getBytes(1));
                cpuData.add(data.build());
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            CpuTable.getLogger().error(ex);
        }
        return cpuData;
    }

    public void insertActivities(int appId, Common.Session session, int tid, String name, List<CpuProfiler.GetThreadsResponse.ThreadActivity> activities) {
        for (CpuProfiler.GetThreadsResponse.ThreadActivity activity : activities) {
            this.execute(CpuStatements.INSERT_THREAD_ACTIVITY, appId, session, tid, activity.getTimestamp(), activity.getNewState().toString(), name);
        }
    }

    public void insertSnapshot(long appId, Common.Session session, long timestamp, List<CpuProfiler.GetThreadsResponse.ThreadSnapshot.Snapshot> snapshots) {
        for (CpuProfiler.GetThreadsResponse.ThreadSnapshot.Snapshot snapshot : snapshots) {
            this.execute(CpuStatements.INSERT_THREAD_ACTIVITY, appId, session, snapshot.getTid(), timestamp, snapshot.getState().toString(), snapshot.getName());
        }
    }

    public List<CpuProfiler.GetThreadsResponse.Thread> getThreadsDataByRequest(CpuProfiler.GetThreadsRequest request) {
        TreeMap<Integer, CpuProfiler.GetThreadsResponse.Thread.Builder> threads = new TreeMap<Integer, CpuProfiler.GetThreadsResponse.Thread.Builder>();
        try {
            ResultSet activities = this.executeQuery(CpuStatements.QUERY_THREAD_ACTIVITIES, request.getStartTimestamp(), request.getProcessId(), request.getSession(), request.getStartTimestamp(), request.getProcessId(), request.getSession(), request.getStartTimestamp(), request.getEndTimestamp());
            while (activities.next()) {
                int tid = activities.getInt(1);
                if (!threads.containsKey(tid)) {
                    CpuProfiler.GetThreadsResponse.Thread.Builder thread = CpuTable.createThreadBuilder(tid, activities.getString(2));
                    threads.put(tid, thread);
                }
                CpuProfiler.GetThreadsResponse.State state = CpuProfiler.GetThreadsResponse.State.valueOf((String)activities.getString(3));
                CpuProfiler.GetThreadsResponse.ThreadActivity.Builder activity = CpuProfiler.GetThreadsResponse.ThreadActivity.newBuilder().setNewState(state).setTimestamp(activities.getLong(4));
                ((CpuProfiler.GetThreadsResponse.Thread.Builder)threads.get(tid)).addActivities(activity.build());
            }
        }
        catch (SQLException ex) {
            CpuTable.getLogger().error((Throwable)ex);
        }
        ArrayList<CpuProfiler.GetThreadsResponse.Thread> cpuData = new ArrayList<CpuProfiler.GetThreadsResponse.Thread>();
        for (CpuProfiler.GetThreadsResponse.Thread.Builder thread : threads.values()) {
            cpuData.add(thread.build());
        }
        return cpuData;
    }

    public List<CpuProfiler.TraceInfo> getTraceInfo(CpuProfiler.GetTraceInfoRequest request) {
        ArrayList<CpuProfiler.TraceInfo> traceInfo = new ArrayList<CpuProfiler.TraceInfo>();
        try {
            ResultSet results = this.executeQuery(CpuStatements.QUERY_TRACE_INFO, request.getProcessId(), request.getSession(), request.getToTimestamp(), request.getFromTimestamp(), request.getFromTimestamp());
            while (results.next()) {
                byte[] data = results.getBytes(1);
                if (data == null) continue;
                traceInfo.add(CpuProfiler.TraceInfo.parseFrom((byte[])data));
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            CpuTable.getLogger().error(ex);
        }
        return traceInfo;
    }

    public TraceData getTraceData(int appId, int traceId, Common.Session session) {
        try {
            byte[] data;
            ResultSet results = this.executeQuery(CpuStatements.FIND_TRACE_DATA, appId, traceId, session);
            if (results.next() && (data = results.getBytes(1)) != null) {
                CpuProfiler.CpuProfilerType profilerType = CpuProfiler.CpuProfilerType.valueOf((String)results.getString(2));
                return new TraceData(ByteString.copyFrom((byte[])data), profilerType);
            }
        }
        catch (SQLException ex) {
            CpuTable.getLogger().error((Throwable)ex);
        }
        return null;
    }

    public void insertTrace(int appId, int traceId, Common.Session session, CpuProfiler.CpuProfilerType profilerType, ByteString data) {
        this.execute(CpuStatements.INSERT_TRACE_DATA, appId, traceId, session, profilerType.toString(), data.toByteArray());
    }

    public void insertTraceInfo(int appId, CpuProfiler.TraceInfo trace, Common.Session session) {
        this.execute(CpuStatements.INSERT_TRACE_INFO, appId, session, trace.getFromTimestamp(), trace.getToTimestamp(), trace.toByteArray());
    }

    private static CpuProfiler.GetThreadsResponse.Thread.Builder createThreadBuilder(int tid, String name) {
        CpuProfiler.GetThreadsResponse.Thread.Builder thread = CpuProfiler.GetThreadsResponse.Thread.newBuilder();
        thread.setTid(tid);
        thread.setName(name);
        return thread;
    }

    public static class TraceData {
        private final ByteString myTraceBytes;
        private final CpuProfiler.CpuProfilerType myProfilerType;

        public TraceData(ByteString traceBytes, CpuProfiler.CpuProfilerType profilerType) {
            this.myTraceBytes = traceBytes;
            this.myProfilerType = profilerType;
        }

        public ByteString getTraceBytes() {
            return this.myTraceBytes;
        }

        public CpuProfiler.CpuProfilerType getProfilerType() {
            return this.myProfilerType;
        }
    }

    public static enum CpuStatements {
        INSERT_THREAD_ACTIVITY,
        QUERY_THREAD_ACTIVITIES,
        INSERT_CPU_DATA,
        QUERY_CPU_DATA,
        QUERY_TRACE_INFO,
        FIND_TRACE_DATA,
        INSERT_TRACE_DATA,
        INSERT_TRACE_INFO;

    }
}

