/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.database;

import com.android.tools.profiler.proto.Common;
import com.intellij.openapi.diagnostic.Logger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class DataStoreTable<T extends Enum> {
    private static final Logger LOG = Logger.getInstance((String)DataStoreTable.class.getCanonicalName());
    private static final long KEYS_ERROR = -1L;
    private static final Set<DataStoreTableErrorCallback> ERROR_CALLBACKS = new HashSet<DataStoreTableErrorCallback>();
    private Connection myConnection;
    private final ThreadLocal<Map<T, PreparedStatement>> myStatementMap = new ThreadLocal();
    protected final Map<Common.Session, Long> mySessionIdLookup;

    public DataStoreTable(@NotNull Map<Common.Session, Long> sesstionIdLookup) {
        this.mySessionIdLookup = sesstionIdLookup;
    }

    public void initialize(@NotNull Connection connection) {
        this.myConnection = connection;
    }

    public abstract void prepareStatements();

    public static void addDataStoreErrorCallback(@NotNull DataStoreTableErrorCallback callback) {
        ERROR_CALLBACKS.add(callback);
    }

    public static void removeDataStoreErrorCallback(@NotNull DataStoreTableErrorCallback callback) {
        ERROR_CALLBACKS.remove(callback);
    }

    public boolean isClosed() {
        try {
            return this.myConnection.isClosed();
        }
        catch (SQLException ex) {
            return true;
        }
    }

    protected static void onError(Throwable t) {
        LOG.error(t);
        for (DataStoreTableErrorCallback callback : ERROR_CALLBACKS) {
            callback.onDataStoreError(t);
        }
    }

    @NotNull
    protected Map<T, PreparedStatement> getStatementMap() {
        if (this.myStatementMap.get() == null) {
            this.myStatementMap.set(new HashMap());
            this.prepareStatements();
        }
        return this.myStatementMap.get();
    }

    protected void createTable(@NotNull String table, String ... columns) throws SQLException {
        this.myConnection.createStatement().execute(String.format("DROP TABLE IF EXISTS %s ", table));
        StringBuilder statement = new StringBuilder();
        statement.append(String.format("CREATE TABLE %s", table));
        this.executeUniqueStatement(statement, columns);
    }

    protected void createUniqueIndex(@NotNull String table, String ... indexList) throws SQLException {
        StringBuilder statement = new StringBuilder();
        statement.append(String.format("CREATE UNIQUE INDEX IF NOT EXISTS idx_%s_pk ON %s", table, table));
        this.executeUniqueStatement(statement, indexList);
    }

    protected void createIndex(@NotNull String table, int indexId, String ... indexList) throws SQLException {
        StringBuilder statement = new StringBuilder();
        statement.append(String.format("CREATE INDEX IF NOT EXISTS idx_%s_%d_pk ON %s", table, indexId, table));
        this.executeUniqueStatement(statement, indexList);
    }

    private void executeUniqueStatement(@NotNull StringBuilder statement, @NotNull String[] params) throws SQLException {
        this.myConnection.createStatement().execute(String.format("%s ( %s )", statement, String.join((CharSequence)",", params)));
    }

    protected void createStatement(@NotNull T statement, @NotNull String stmt) throws SQLException {
        this.getStatementMap().put(statement, this.myConnection.prepareStatement(stmt));
    }

    protected void createStatement(@NotNull T statement, @NotNull String stmt, int statementFlags) throws SQLException {
        this.getStatementMap().put(statement, this.myConnection.prepareStatement(stmt, statementFlags));
    }

    protected void execute(@NotNull T statement, Object ... params) {
        try {
            if (this.isClosed()) {
                return;
            }
            PreparedStatement stmt = this.getStatementMap().get(statement);
            this.applyParams(stmt, params);
            stmt.execute();
        }
        catch (SQLException ex) {
            DataStoreTable.onError(ex);
        }
    }

    protected long executeWithGeneratedKeys(@NotNull T statement, Object ... params) {
        try {
            if (this.isClosed()) {
                return -1L;
            }
            PreparedStatement stmt = this.getStatementMap().get(statement);
            this.applyParams(stmt, params);
            stmt.execute();
            return stmt.getGeneratedKeys().getLong(1);
        }
        catch (SQLException ex) {
            DataStoreTable.onError(ex);
            return -1L;
        }
    }

    protected ResultSet executeQuery(@NotNull T statement, Object ... params) throws SQLException {
        PreparedStatement stmt = this.getStatementMap().get(statement);
        this.applyParams(stmt, params);
        return stmt.executeQuery();
    }

    protected void applyParams(@NotNull PreparedStatement statement, Object ... params) throws SQLException {
        for (int i = 0; params != null && i < params.length; ++i) {
            if (params[i] == null) continue;
            if (params[i] instanceof String) {
                statement.setString(i + 1, (String)params[i]);
                continue;
            }
            if (params[i] instanceof Integer) {
                statement.setLong(i + 1, ((Integer)params[i]).intValue());
                continue;
            }
            if (params[i] instanceof Long) {
                statement.setLong(i + 1, (Long)params[i]);
                continue;
            }
            if (params[i] instanceof byte[]) {
                statement.setBytes(i + 1, (byte[])params[i]);
                continue;
            }
            if (params[i] instanceof Common.Session) {
                Common.Session session = (Common.Session)params[i];
                if (this.mySessionIdLookup.containsKey(session)) {
                    statement.setLong(i + 1, this.mySessionIdLookup.get(session));
                    continue;
                }
                LOG.warn("Session not found: " + params[i]);
                statement.setLong(i + 1, -1L);
                continue;
            }
            assert (false);
        }
    }

    public static interface DataStoreTableErrorCallback {
        public void onDataStoreError(Throwable var1);
    }
}

