/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.database;

import com.android.tools.datastore.database.DataStoreTable;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.EventProfiler;
import com.google.protobuf3jarjar.InvalidProtocolBufferException;
import com.intellij.openapi.diagnostic.Logger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class EventsTable
extends DataStoreTable<EventStatements> {
    private static Logger getLogger() {
        return Logger.getInstance(EventsTable.class);
    }

    public EventsTable(@NotNull Map<Common.Session, Long> sesstionIdLookup) {
        super(sesstionIdLookup);
    }

    @Override
    public void initialize(@NotNull Connection connection) {
        super.initialize(connection);
        try {
            this.createTable("Events_Activity", "Id INTEGER NOT NULL", "AppId INTEGER NOT NULL", "Session INTEGER NOT NULL", "Data BLOB");
            this.createTable("Events_System", "Id INTEGER NOT NULL", "AppId INTEGER NOT NULL", "Session INTEGER NOT NULL", "StartTime INTEGER", "EndTime INTEGER", "Data BLOB");
            this.createUniqueIndex("Events_Activity", "Id", "AppId", "Session");
            this.createUniqueIndex("Events_System", "Id", "AppId", "Session");
        }
        catch (SQLException ex) {
            EventsTable.getLogger().error((Throwable)ex);
        }
    }

    @Override
    public void prepareStatements() {
        try {
            this.createStatement(EventStatements.FIND_ACTIVITY, "SELECT Data from Events_Activity WHERE Id = ? AND AppId = ? AND Session = ?");
            this.createStatement(EventStatements.INSERT_ACTIVITY, "INSERT OR REPLACE INTO Events_Activity (Id, AppId, Session, Data) values (?, ?, ?, ?)");
            this.createStatement(EventStatements.INSERT_SYSTEM, "INSERT OR REPLACE INTO Events_System (Id, AppId, Session, StartTime, EndTime, Data) values ( ?, ?, ?, ?, ?, ?)");
            this.createStatement(EventStatements.QUERY_SYSTEM, "SELECT Data from Events_System WHERE Session = ? AND AppId = ? AND (EndTime >= ? OR EndTime = 0) AND StartTime < ?;");
            this.createStatement(EventStatements.QUERY_ACTIVITY, "SELECT Data from Events_Activity WHERE AppId = ? AND Session = ?");
        }
        catch (SQLException ex) {
            EventsTable.getLogger().error((Throwable)ex);
        }
    }

    public EventProfiler.ActivityData findActivityDataOrNull(long appId, long id, Common.Session session) {
        try {
            ResultSet results = this.executeQuery(EventStatements.FIND_ACTIVITY, id, appId, session);
            List<EventProfiler.ActivityData> datas = this.getActivityDataFromResultSet(results);
            if (!datas.isEmpty()) {
                return datas.get(0);
            }
        }
        catch (SQLException ex) {
            EventsTable.getLogger().error((Throwable)ex);
        }
        return null;
    }

    public void insertOrReplace(long id, Common.Session session, EventProfiler.ActivityData activity) {
        this.execute(EventStatements.INSERT_ACTIVITY, id, activity.getProcessId(), session, activity.toByteArray());
    }

    public List<EventProfiler.ActivityData> getActivityDataByApp(long appId, Common.Session session) {
        try {
            ResultSet results = this.executeQuery(EventStatements.QUERY_ACTIVITY, appId, session);
            return this.getActivityDataFromResultSet(results);
        }
        catch (SQLException ex) {
            EventsTable.getLogger().error((Throwable)ex);
            return null;
        }
    }

    public void insertOrReplace(long id, Common.Session session, EventProfiler.SystemData activity) {
        this.execute(EventStatements.INSERT_SYSTEM, id, activity.getProcessId(), session, activity.getStartTimestamp(), activity.getEndTimestamp(), activity.toByteArray());
    }

    public List<EventProfiler.SystemData> getSystemDataByRequest(EventProfiler.EventDataRequest request) {
        ArrayList<EventProfiler.SystemData> events = new ArrayList<EventProfiler.SystemData>();
        try {
            ResultSet results = this.executeQuery(EventStatements.QUERY_SYSTEM, request.getSession(), request.getProcessId(), request.getStartTimestamp(), request.getEndTimestamp());
            while (results.next()) {
                EventProfiler.SystemData.Builder data = EventProfiler.SystemData.newBuilder();
                data.mergeFrom(results.getBytes(1));
                events.add(data.build());
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            EventsTable.getLogger().error(ex);
        }
        return events;
    }

    private List<EventProfiler.ActivityData> getActivityDataFromResultSet(ResultSet results) {
        ArrayList<EventProfiler.ActivityData> activities = new ArrayList<EventProfiler.ActivityData>();
        try {
            while (results.next()) {
                EventProfiler.ActivityData.Builder data = EventProfiler.ActivityData.newBuilder();
                data.mergeFrom(results.getBytes(1));
                activities.add(data.build());
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            EventsTable.getLogger().error(ex);
        }
        return activities;
    }

    public static enum EventStatements {
        FIND_ACTIVITY,
        INSERT_ACTIVITY,
        INSERT_SYSTEM,
        QUERY_SYSTEM,
        QUERY_ACTIVITY;

    }
}

