/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.database;

import com.android.tools.datastore.database.DataStoreTable;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.NetworkProfiler;
import com.google.protobuf3jarjar.InvalidProtocolBufferException;
import com.intellij.openapi.diagnostic.Logger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class NetworkTable
extends DataStoreTable<NetworkStatements> {
    private static final Map<NetworkProfiler.NetworkProfilerData.DataCase, Integer> DATACASE_REQUEST_TYPE_MAP = new HashMap<NetworkProfiler.NetworkProfilerData.DataCase, Integer>();
    private static final int BODY_COLUMN = 2;
    private static final int REQUEST_COLUMN = 3;
    private static final int RESPONSE_COLUMN = 4;
    private static final int THREADS_COLUMN = 5;

    private static Logger getLogger() {
        return Logger.getInstance(NetworkTable.class);
    }

    public NetworkTable(@NotNull Map<Common.Session, Long> sesstionIdLookup) {
        super(sesstionIdLookup);
    }

    @Override
    public void initialize(@NotNull Connection connection) {
        super.initialize(connection);
        try {
            this.createTable("Network_Data", "Id INTEGER NOT NULL", "Type INTEGER NOT NULL", "EndTime INTEGER", "Data BLOB");
            this.createTable("Network_Connection", "ProcessId INTEGER NOT NULL", "Session INTEGER NOT NULL", "Id INTEGER NOT NULL", "StartTime INTEGER", "EndTime INTEGER", "ConnectionData BLOB", "BodyData BLOB", "RequestData BLOB", "ResponseData BLOB", "ThreadsData BLOB", "PRIMARY KEY(ProcessId, Id)");
            this.createUniqueIndex("Network_Data", "Id", "Type", "EndTime");
            this.createUniqueIndex("Network_Connection", "ProcessId", "Session", "Id");
        }
        catch (SQLException ex) {
            NetworkTable.getLogger().error((Throwable)ex);
        }
    }

    @Override
    public void prepareStatements() {
        try {
            this.createStatement(NetworkStatements.INSERT_NETWORK_DATA, "INSERT OR IGNORE INTO Network_Data (Id, Type, EndTime, Data) VALUES (?, ?, ?, ?)");
            this.createStatement(NetworkStatements.QUERY_NETWORK_DATA_BY_TYPE, "SELECT Data FROM Network_Data WHERE (Id = ? OR Id = ?) AND Type = ? AND EndTime > ? AND EndTime <= ?");
            this.createStatement(NetworkStatements.QUERY_NETWORK_DATA, "SELECT Data FROM Network_Data WHERE (Id = ? OR Id = ? ) AND EndTime > ? AND EndTime <= ?");
            this.createStatement(NetworkStatements.QUERY_COMMON_CONNECTION_DATA, "SELECT ConnectionData FROM Network_Connection WHERE ProcessId = ? AND Session = ? AND (EndTime > ? OR EndTime = 0) AND StartTime <= ?");
            this.createStatement(NetworkStatements.FIND_CONNECTION_DATA, "SELECT ConnectionData, BodyData, RequestData, ResponseData, ThreadsData FROM Network_Connection WHERE Id = ? AND Session = ?");
            this.createStatement(NetworkStatements.INSERT_CONNECTION_DATA, "INSERT OR REPLACE INTO Network_Connection (ProcessId, Session, Id, StartTime, EndTime, ConnectionData, BodyData, RequestData, ResponseData, ThreadsData) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        }
        catch (SQLException ex) {
            NetworkTable.getLogger().error((Throwable)ex);
        }
    }

    public List<NetworkProfiler.HttpConnectionData> getNetworkConnectionDataByRequest(NetworkProfiler.HttpRangeRequest request) {
        ArrayList<NetworkProfiler.HttpConnectionData> datas = new ArrayList<NetworkProfiler.HttpConnectionData>();
        try {
            ResultSet results = this.executeQuery(NetworkStatements.QUERY_COMMON_CONNECTION_DATA, request.getProcessId(), request.getSession(), request.getStartTimestamp(), request.getEndTimestamp());
            while (results.next()) {
                NetworkProfiler.HttpConnectionData.Builder data = NetworkProfiler.HttpConnectionData.newBuilder();
                data.mergeFrom(results.getBytes(1));
                datas.add(data.build());
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            NetworkTable.getLogger().error(ex);
        }
        return datas;
    }

    public List<NetworkProfiler.NetworkProfilerData> getNetworkDataByRequest(NetworkProfiler.NetworkDataRequest request) {
        ArrayList<NetworkProfiler.NetworkProfilerData> datas = new ArrayList<NetworkProfiler.NetworkProfilerData>();
        try {
            ResultSet results = request.getType() == NetworkProfiler.NetworkDataRequest.Type.ALL ? this.executeQuery(NetworkStatements.QUERY_NETWORK_DATA, request.getProcessId(), -1, request.getStartTimestamp(), request.getEndTimestamp()) : this.executeQuery(NetworkStatements.QUERY_NETWORK_DATA_BY_TYPE, request.getProcessId(), -1, request.getType().getNumber(), request.getStartTimestamp(), request.getEndTimestamp());
            while (results.next()) {
                NetworkProfiler.NetworkProfilerData.Builder data = NetworkProfiler.NetworkProfilerData.newBuilder();
                data.mergeFrom(results.getBytes(1));
                datas.add(data.build());
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            NetworkTable.getLogger().error(ex);
        }
        return datas;
    }

    public void insert(int appId, NetworkProfiler.NetworkProfilerData data) {
        this.execute(NetworkStatements.INSERT_NETWORK_DATA, appId, DATACASE_REQUEST_TYPE_MAP.get(data.getDataCase()), data.getBasicInfo().getEndTimestamp(), data.toByteArray());
    }

    public NetworkProfiler.HttpDetailsResponse getHttpDetailsResponseById(long connId, Common.Session session, NetworkProfiler.HttpDetailsRequest.Type type) {
        NetworkProfiler.HttpDetailsResponse.Builder responseBuilder = NetworkProfiler.HttpDetailsResponse.newBuilder();
        try {
            Optional<Integer> column;
            ResultSet results = this.executeQuery(NetworkStatements.FIND_CONNECTION_DATA, connId, session);
            if (results.next() && (column = this.columnFor(type)).isPresent()) {
                byte[] responseBytes = results.getBytes(column.get());
                if (responseBytes != null) {
                    responseBuilder.mergeFrom(responseBytes);
                }
                return responseBuilder.build();
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            NetworkTable.getLogger().error(ex);
        }
        return null;
    }

    private Optional<Integer> columnFor(NetworkProfiler.HttpDetailsRequest.Type type) {
        switch (type) {
            case REQUEST: {
                return Optional.of(3);
            }
            case RESPONSE: {
                return Optional.of(4);
            }
            case RESPONSE_BODY: {
                return Optional.of(2);
            }
            case ACCESSING_THREADS: {
                return Optional.of(5);
            }
            case REQUEST_BODY: 
            case UNSPECIFIED: 
            case UNRECOGNIZED: {
                return Optional.empty();
            }
        }
        throw new AssertionError(type);
    }

    public void insertOrReplace(int processId, Common.Session session, NetworkProfiler.HttpDetailsResponse request, NetworkProfiler.HttpDetailsResponse response, NetworkProfiler.HttpDetailsResponse body, NetworkProfiler.HttpDetailsResponse threads, NetworkProfiler.HttpConnectionData data) {
        long id = data.getConnId();
        long startTime = data.getStartTimestamp();
        long endTime = data.getEndTimestamp();
        byte[] commonData = data.toByteArray();
        byte[] responseData = response == null ? null : response.toByteArray();
        byte[] requestData = request == null ? null : request.toByteArray();
        byte[] bodyData = body == null ? null : body.toByteArray();
        byte[] threadsData = threads == null ? null : threads.toByteArray();
        this.execute(NetworkStatements.INSERT_CONNECTION_DATA, processId, session, id, startTime, endTime, commonData, bodyData, requestData, responseData, threadsData);
    }

    static {
        DATACASE_REQUEST_TYPE_MAP.put(NetworkProfiler.NetworkProfilerData.DataCase.SPEED_DATA, NetworkProfiler.NetworkDataRequest.Type.SPEED.getNumber());
        DATACASE_REQUEST_TYPE_MAP.put(NetworkProfiler.NetworkProfilerData.DataCase.CONNECTION_DATA, NetworkProfiler.NetworkDataRequest.Type.CONNECTIONS.getNumber());
        DATACASE_REQUEST_TYPE_MAP.put(NetworkProfiler.NetworkProfilerData.DataCase.CONNECTIVITY_DATA, NetworkProfiler.NetworkDataRequest.Type.CONNECTIVITY.getNumber());
    }

    public static enum NetworkStatements {
        INSERT_NETWORK_DATA,
        QUERY_NETWORK_DATA_BY_TYPE,
        QUERY_NETWORK_DATA,
        QUERY_COMMON_CONNECTION_DATA,
        FIND_CONNECTION_DATA,
        INSERT_CONNECTION_DATA;

    }
}

