/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.database;

import com.android.tools.datastore.database.DataStoreTable;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Profiler;
import com.google.protobuf3jarjar.InvalidProtocolBufferException;
import com.intellij.openapi.diagnostic.Logger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProfilerTable
extends DataStoreTable<ProfilerStatements> {
    private final Object myLock = new Object();

    private static Logger getLogger() {
        return Logger.getInstance(ProfilerTable.class);
    }

    public ProfilerTable(@NotNull Map<Common.Session, Long> sesstionIdLookup) {
        super(sesstionIdLookup);
    }

    @Override
    public void initialize(@NotNull Connection connection) {
        super.initialize(connection);
        try {
            this.createTable("Profiler_Bytes", "Id STRING NOT NULL", "Session INTEGER NOT NULL", "Data BLOB");
            this.createTable("Profiler_Devices", "Session STRING", "Data BLOB");
            this.createTable("Profiler_Processes", "Session INTEGER", "ProcessId INTEGER", "StartTime INTEGER", "EndTime INTEGER", "HasAgent INTEGER", "LastKnownAttachedTime INTEGER", "Data BLOB");
            this.createUniqueIndex("Profiler_Processes", "Session", "ProcessId", "StartTime");
            this.createUniqueIndex("Profiler_Bytes", "Id", "Session");
            this.createUniqueIndex("Profiler_Devices", "Session");
        }
        catch (SQLException ex) {
            ProfilerTable.getLogger().error((Throwable)ex);
        }
    }

    @Override
    public void prepareStatements() {
        try {
            this.createStatement(ProfilerStatements.INSERT_DEVICE, "INSERT INTO Profiler_Devices (Session, Data) values (?, ?)", 1);
            this.createStatement(ProfilerStatements.UPDATE_DEVICE, "UPDATE Profiler_Devices SET Data = ? WHERE Session = ?");
            this.createStatement(ProfilerStatements.INSERT_PROCESS, "INSERT OR REPLACE INTO Profiler_Processes (Session, ProcessId, StartTime, EndTime, Data) values (?, ?, ?, ?, ?)");
            this.createStatement(ProfilerStatements.UPDATE_PROCESS, "UPDATE Profiler_Processes Set EndTime = ?, Data = ? WHERE Session = ? AND ProcessId = ? AND StartTime = ?");
            this.createStatement(ProfilerStatements.SELECT_PROCESSES, "SELECT Data from Profiler_Processes WHERE Session = ? AND (EndTime > ? OR EndTime = 0) AND StartTime < ?");
            this.createStatement(ProfilerStatements.SELECT_PROCESS_BY_ID, "SELECT Data from Profiler_Processes WHERE Session = ? AND ProcessId = ? AND StartTime = ?");
            this.createStatement(ProfilerStatements.SELECT_DEVICE, "SELECT Data from Profiler_Devices");
            this.createStatement(ProfilerStatements.FIND_AGENT_STATUS, "SELECT HasAgent, LastKnownAttachedTime from Profiler_Processes WHERE Session = ? AND ProcessId = ? AND StartTime = ?");
            this.createStatement(ProfilerStatements.UPDATE_AGENT_STATUS, "UPDATE Profiler_Processes SET HasAgent = ?, LastKnownAttachedTime = ? WHERE Session = ? AND ProcessId = ? AND StartTime = ?");
            this.createStatement(ProfilerStatements.INSERT_BYTES, "INSERT OR REPLACE INTO Profiler_Bytes (Id, Session, Data) VALUES (?, ?, ?)");
            this.createStatement(ProfilerStatements.GET_BYTES, "SELECT Data FROM Profiler_Bytes WHERE ID = ? AND Session = ?");
        }
        catch (SQLException ex) {
            ProfilerTable.getLogger().error((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Profiler.GetDevicesResponse getDevices(Profiler.GetDevicesRequest request) {
        if (this.isClosed()) {
            return Profiler.GetDevicesResponse.getDefaultInstance();
        }
        Object object = this.myLock;
        synchronized (object) {
            Profiler.GetDevicesResponse.Builder responseBuilder = Profiler.GetDevicesResponse.newBuilder();
            try {
                ResultSet results = this.executeQuery(ProfilerStatements.SELECT_DEVICE, new Object[0]);
                while (results.next()) {
                    responseBuilder.addDevice(Profiler.Device.parseFrom((byte[])results.getBytes(1)));
                }
            }
            catch (InvalidProtocolBufferException | SQLException ex) {
                ProfilerTable.getLogger().error(ex);
            }
            return responseBuilder.build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Profiler.GetProcessesResponse getProcesses(Profiler.GetProcessesRequest request) {
        if (this.isClosed()) {
            return Profiler.GetProcessesResponse.getDefaultInstance();
        }
        Object object = this.myLock;
        synchronized (object) {
            Profiler.GetProcessesResponse.Builder responseBuilder = Profiler.GetProcessesResponse.newBuilder();
            try {
                ResultSet results = this.executeQuery(ProfilerStatements.SELECT_PROCESSES, request.getSession(), Long.MIN_VALUE, Long.MAX_VALUE);
                while (results.next()) {
                    byte[] data = results.getBytes(1);
                    Profiler.Process process = data == null ? Profiler.Process.getDefaultInstance() : Profiler.Process.parseFrom((byte[])data);
                    responseBuilder.addProcess(process);
                }
            }
            catch (InvalidProtocolBufferException | SQLException ex) {
                ProfilerTable.getLogger().error(ex);
            }
            return responseBuilder.build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertOrUpdateDevice(Profiler.Device device) {
        Object object = this.myLock;
        synchronized (object) {
            Common.Session session = Common.Session.newBuilder().setBootId(device.getBootId()).setDeviceSerial(device.getSerial()).build();
            if (this.mySessionIdLookup.containsKey(session)) {
                this.execute(ProfilerStatements.UPDATE_DEVICE, device.toByteArray(), session.toString());
            } else {
                long id = this.executeWithGeneratedKeys(ProfilerStatements.INSERT_DEVICE, session.toString(), device.toByteArray());
                this.mySessionIdLookup.put(session, id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertOrUpdateProcess(Common.Session session, Profiler.Process process) {
        Object object = this.myLock;
        synchronized (object) {
            try {
                ResultSet results = this.executeQuery(ProfilerStatements.SELECT_PROCESS_BY_ID, session, process.getPid(), 0L);
                if (results.next()) {
                    this.execute(ProfilerStatements.UPDATE_PROCESS, 0L, process.toByteArray(), session, process.getPid(), 0L);
                } else {
                    this.execute(ProfilerStatements.INSERT_PROCESS, session, process.getPid(), 0L, 0L, process.toByteArray());
                }
            }
            catch (SQLException ex) {
                ProfilerTable.getLogger().error((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAgentStatus(Common.Session session, Profiler.Process process, Profiler.AgentStatusResponse agentStatus) {
        Object object = this.myLock;
        synchronized (object) {
            try {
                ResultSet results = this.executeQuery(ProfilerStatements.FIND_AGENT_STATUS, session, process.getPid(), 0L);
                if (results.next()) {
                    Profiler.AgentStatusResponse.Status status = Profiler.AgentStatusResponse.Status.forNumber((int)results.getInt(1));
                    switch (status) {
                        case DETACHED: 
                        case UNSPECIFIED: 
                        case UNRECOGNIZED: {
                            status = agentStatus.getStatus();
                            break;
                        }
                    }
                    this.execute(ProfilerStatements.UPDATE_AGENT_STATUS, status.ordinal(), agentStatus.getLastTimestamp(), session, process.getPid(), 0L);
                }
            }
            catch (SQLException ex) {
                ProfilerTable.getLogger().error((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Profiler.AgentStatusResponse getAgentStatus(Profiler.AgentStatusRequest request) {
        Object object = this.myLock;
        synchronized (object) {
            Profiler.AgentStatusResponse.Builder responseBuilder = Profiler.AgentStatusResponse.newBuilder();
            try {
                ResultSet results = this.executeQuery(ProfilerStatements.FIND_AGENT_STATUS, request.getSession(), request.getProcessId(), 0L);
                if (results.next()) {
                    responseBuilder.setStatusValue(results.getInt(1));
                    responseBuilder.setLastTimestamp(results.getLong(2));
                }
            }
            catch (SQLException ex) {
                ProfilerTable.getLogger().error((Throwable)ex);
            }
            return responseBuilder.build();
        }
    }

    public void insertOrUpdateBytes(String id, Common.Session session, Profiler.BytesResponse response) {
        this.execute(ProfilerStatements.INSERT_BYTES, id, session, response.toByteArray());
    }

    @Nullable
    public Profiler.BytesResponse getBytes(Profiler.BytesRequest request) {
        try {
            ResultSet results = this.executeQuery(ProfilerStatements.GET_BYTES, request.getId(), request.getSession());
            if (results.next()) {
                return Profiler.BytesResponse.parseFrom((byte[])results.getBytes(1));
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            ProfilerTable.getLogger().error(ex);
        }
        return null;
    }

    public static enum ProfilerStatements {
        INSERT_DEVICE,
        UPDATE_DEVICE,
        INSERT_PROCESS,
        UPDATE_PROCESS,
        SELECT_PROCESSES,
        SELECT_PROCESS_BY_ID,
        SELECT_DEVICE,
        FIND_AGENT_STATUS,
        UPDATE_AGENT_STATUS,
        INSERT_BYTES,
        GET_BYTES;

    }
}

